/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.configuration.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.kuali.coeus.elasticsearch.ElasticsearchEnabledCondition;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexServiceImpl;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchAwardSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDevelopmentProposalSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchInstitutionalProposalSerializer;
import org.kuali.coeus.sys.framework.concurrent.WebappContextForkJoinWorkerThreadFactory;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ForkJoinPoolFactoryBean;

@Configuration
@Conditional(value={ElasticsearchEnabledCondition.class})
public class ElasticsearchConfiguration {
    private static final Logger LOG = LogManager.getLogger(ElasticsearchConfiguration.class);
    private static final String HOST_DELIMITER = ",";

    @Bean
    public RestHighLevelClient elasticsearchClient(ConfigurationService configurationService) {
        String elasticsearchHosts = configurationService.getPropertyValueAsString("elasticsearch.hosts");
        if (StringUtils.isBlank((CharSequence)elasticsearchHosts)) {
            throw new IllegalArgumentException(String.format("No Elasticsearch host(s) provided via the %s configuration parameter", "elasticsearch.hosts"));
        }
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])((HttpHost[])Arrays.stream(elasticsearchHosts.split(HOST_DELIMITER)).map(HttpHost::create).toArray(HttpHost[]::new)));
        String elasticsearchUsername = configurationService.getPropertyValueAsString("elasticsearch.username");
        String elasticsearchPassword = configurationService.getPropertyValueAsString("elasticsearch.password");
        if (StringUtils.isNotBlank((CharSequence)elasticsearchUsername) && StringUtils.isNotBlank((CharSequence)elasticsearchPassword)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(elasticsearchUsername, elasticsearchPassword));
            clientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchConfiguration.lambda$elasticsearchClient$1((CredentialsProvider)credentialsProvider, arg_0));
        }
        return new RestHighLevelClient(clientBuilder);
    }

    @Bean
    public ObjectMapper elasticsearchObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public ElasticsearchDocumentSerializer esAwardSerializer() {
        return new ElasticsearchAwardSerializer();
    }

    @Bean
    public ElasticsearchDocumentSerializer esDevelopmentProposalSerializer() {
        return new ElasticsearchDevelopmentProposalSerializer();
    }

    @Bean
    public ElasticsearchDocumentSerializer esInstitutionalProposalSerializer() {
        return new ElasticsearchInstitutionalProposalSerializer();
    }

    @Bean(value={"elasticsearchForkJoinPool"})
    public ForkJoinPoolFactoryBean elasticsearchForkJoinPool(ConfigurationService configurationService) {
        ForkJoinPoolFactoryBean forkJoinPoolFactoryBean = new ForkJoinPoolFactoryBean();
        forkJoinPoolFactoryBean.setThreadFactory((ForkJoinPool.ForkJoinWorkerThreadFactory)new WebappContextForkJoinWorkerThreadFactory());
        String indexingParallelism = configurationService.getPropertyValueAsString("elasticsearch.bulk.index.parallelism");
        if (StringUtils.isNotBlank((CharSequence)indexingParallelism)) {
            try {
                forkJoinPoolFactoryBean.setParallelism(Integer.parseInt(indexingParallelism));
            }
            catch (NumberFormatException e) {
                LOG.error(String.format("%s is an invalid setting for %s, must be an integer.", indexingParallelism, "elasticsearch.bulk.index.parallelism"));
            }
        }
        return forkJoinPoolFactoryBean;
    }

    @Bean
    public ElasticsearchIndexService elasticsearchIndexService(ConfigurationService configurationService) {
        ElasticsearchIndexServiceImpl elasticsearchIndexService = new ElasticsearchIndexServiceImpl();
        String indexName = configurationService.getPropertyValueAsString("elasticsearch.index.name");
        if (StringUtils.isNotBlank((CharSequence)indexName)) {
            elasticsearchIndexService.setIndexName(indexName);
        }
        return elasticsearchIndexService;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$elasticsearchClient$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpBuilder) {
        return httpBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

