/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetSharedControllerService;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.lock.ProposalBudgetLockService;
import org.kuali.kra.infrastructure.OnOffCampusFlagConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="proposalBudgetCommonController")
@RequestMapping(value={"/proposalBudget"})
public class ProposalBudgetCommonController
extends ProposalBudgetControllerBase {
    private static final String PROP_BUDGET_PERIODS_PAGE = "PropBudget-PeriodsPage";
    private static final String INFO_DATAOVERRIDE_OCCURED_BUDGET = "info.dataoverride.occured.budget";
    @Autowired
    @Qualifier(value="proposalBudgetSharedControllerService")
    private ProposalBudgetSharedControllerService proposalBudgetSharedController;
    @Autowired
    @Qualifier(value="proposalBudgetLockService")
    private ProposalBudgetLockService proposalBudgetLockService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService proposalBudgetService;

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=defaultMapping"})
    public ModelAndView defaultMapping(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getTransactionalDocumentControllerService().start((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@RequestParam(value="budgetId") Long budgetId, @RequestParam(value="viewOnly") String viewOnly, @RequestParam(value="auditActivated") String auditActivated, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        boolean inViewMode = Boolean.parseBoolean(viewOnly);
        form.setBudget(this.loadBudget(budgetId));
        if (CollectionUtils.isNotEmpty(form.getDevelopmentProposal().getBudgetChangedDataList())) {
            this.getGlobalVariableService().getMessageMap().putInfoForSectionId(PROP_BUDGET_PERIODS_PAGE, INFO_DATAOVERRIDE_OCCURED_BUDGET, new String[0]);
        }
        if (!inViewMode) {
            this.getProposalBudgetLockService().establishBudgetLock(form.getBudget());
        }
        form.initialize();
        if (auditActivated != null) {
            form.setAuditActivated(Boolean.parseBoolean(auditActivated));
        }
        ModelAndView result = this.getModelAndViewService().getModelAndViewWithInit((UifFormBase)form, "PropBudget-DefaultView");
        form.setViewOnly(inViewMode);
        form.setCanEditView(!inViewMode);
        boolean canModify = false;
        if (!inViewMode) {
            canModify = this.getProposalBudgetAuthorizer().canModifyBudget(form.getBudget(), this.getGlobalVariableService().getUserSession().getPerson());
        }
        if (canModify && this.getBudgetRatesService().checkActivityTypeChange(form.getBudget().getBudgetRates(), form.getDevelopmentProposal().getActivityTypeCode())) {
            return this.getModelAndViewService().showDialog("PropBudget-ActivityTypeChanged-Dialog", true, (UifFormBase)form);
        }
        if (canModify && form.getBudget().getBudgetRates().isEmpty()) {
            return this.getModelAndViewService().showDialog("PropBudget-NoRates-Dialog", true, (UifFormBase)form);
        }
        return result;
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=initiate"})
    public ModelAndView initiate(@RequestParam(value="budgetId") Long budgetId, @RequestParam(value="auditActivated") String auditActivated, @RequestParam(value="summaryBudget", required=false) Boolean summaryBudget, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        form.setBudget(this.loadBudget(budgetId));
        this.getProposalBudgetLockService().establishBudgetLock(form.getBudget());
        form.initialize();
        if (auditActivated != null) {
            form.setAuditActivated(Boolean.parseBoolean(auditActivated));
        }
        if (summaryBudget != null && !summaryBudget.booleanValue() || summaryBudget == null && !form.getBudget().isSummaryBudget()) {
            return this.getModelAndViewService().getModelAndViewWithInit((UifFormBase)form, "PropBudget-DefaultView", "PropBudget-ProjectPersonnelPage");
        }
        return this.getModelAndViewService().getModelAndViewWithInit((UifFormBase)form, "PropBudget-DefaultView", PROP_BUDGET_PERIODS_PAGE);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=openProposal"})
    public ModelAndView openProposal(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        if (form.isCanEditView().booleanValue()) {
            this.save(form);
        }
        if (this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            this.getProposalBudgetLockService().deleteBudgetLock(form.getBudget());
            form.setDirtyForm(false);
            Properties props = new Properties();
            props.put("methodToCall", "docHandler");
            props.put("command", "displayDocSearchView");
            props.put("pageId", "PropDev-BudgetPage");
            props.put("docId", form.getBudget().getDevelopmentProposal().getProposalDocument().getDocumentNumber());
            props.put("auditActivated", String.valueOf(form.isAuditActivated()));
            props.put("viewOnly", String.valueOf(form.isViewOnly()));
            return this.getModelAndViewService().performRedirect((UifFormBase)form, "proposalDevelopment", props);
        }
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=openBudget"})
    public ModelAndView openBudget(@RequestParam(value="budgetId") String budgetId, @RequestParam(value="viewOnly") boolean viewOnly, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        if (!viewOnly) {
            this.save(form);
        }
        return this.getProposalBudgetSharedController().openBudget(budgetId, viewOnly, form);
    }

    @Override
    @Transactional
    @RequestMapping(params={"methodToCall=save"})
    public ModelAndView save(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        boolean valid = true;
        if (form.getPageId().equalsIgnoreCase("PropBudget-CostSharingPage") || form.getPageId().equalsIgnoreCase("PropBudget-UnrecoveredFandAPage")) {
            valid &= this.proposalBudgetService.validateCostShare(form.getBudget());
        }
        return valid ? super.save(form) : this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Override
    @RequestMapping(params={"methodToCall=navigate"})
    public ModelAndView navigate(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        return super.navigate(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=closeBudget"})
    public ModelAndView closeBudget(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        if (!form.isCanEditView().booleanValue() || form.isViewOnly()) {
            return this.closeWithoutSave(form);
        }
        return this.getModelAndViewService().showDialog("PropDev-CloseBudget-Dialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=closeWithSave"})
    public ModelAndView closeWithSave(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        super.save(form);
        if (this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            this.getProposalBudgetLockService().deleteBudgetLock(form.getBudget());
            return this.getKcCommonControllerService().returnHome(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=closeWithoutSave"})
    public ModelAndView closeWithoutSave(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.getProposalBudgetLockService().deleteBudgetLock(form.getBudget());
        return this.getKcCommonControllerService().returnHome(form);
    }

    @RequestMapping(params={"methodToCall=addBudget"})
    public ModelAndView addBudget(@RequestParam(value="addBudgetDto.budgetName") String budgetName, @RequestParam(value="addBudgetDto.summaryBudget") Boolean summaryBudget, @RequestParam(value="addBudgetDto.modularBudget", defaultValue="false") Boolean modularBudget, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.save(form);
        return this.getProposalBudgetSharedController().addBudget(budgetName, summaryBudget, modularBudget, form.getDevelopmentProposal(), form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=copyBudget"})
    public ModelAndView copyBudget(@RequestParam(value="copyBudgetDto.budgetName") String budgetName, @RequestParam(value="copyBudgetDto.originalBudgetId") Long originalBudgetId, @RequestParam(value="copyBudgetDto.allPeriods") Boolean allPeriods, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.save(form);
        return this.getProposalBudgetSharedController().copyBudget(budgetName, originalBudgetId, allPeriods, form.getDevelopmentProposal(), form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=completeBudget"})
    public ModelAndView completeBudget(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        if (!this.getProposalBudgetSharedController().isAllowedToCompleteBudget(form.getBudget(), form.getPageId())) {
            form.setAuditActivated(true);
            form.setAjaxReturnType("update-page");
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        DialogResponse dialogResponse = form.getDialogResponse("PropDev-CompleteBudgetConfirmationDialog");
        if (dialogResponse == null) {
            return this.getModelAndViewService().showDialog("PropDev-CompleteBudgetConfirmationDialog", false, (UifFormBase)form);
        }
        if (dialogResponse.getResponseAsBoolean()) {
            String budgetStatusCompleteCode = this.parameterService.getParameterValueAsString(Budget.class, "budgetStatusCompleteCode");
            form.getBudget().setBudgetStatus(budgetStatusCompleteCode);
            this.getDataObjectService().wrap((Object)form.getBudget()).fetchRelationship("budgetStatusDo");
            if (form.isSubmitBudgetIndicator()) {
                form.getDevelopmentProposal().setFinalBudget(form.getBudget());
                this.getDataObjectService().save((Object)form.getDevelopmentProposal(), new PersistenceOption[0]);
            }
            super.save(form);
            form.setEvaluateFlagsAndModes(true);
            form.setCanEditView(null);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=saveBudgetSettings"})
    public ModelAndView saveBudgetSettings(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        ProposalDevelopmentBudgetExt originalBudget = (ProposalDevelopmentBudgetExt)this.getOriginalBudget(form);
        if (budget.isBudgetComplete() && !this.getProposalBudgetSharedController().isAllowedToCompleteBudget(budget, "budget.budgetStatus")) {
            form.setAuditActivated(true);
            budget.setBudgetStatus(originalBudget.getBudgetStatus());
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        if (budget.getModularBudgetFlag().booleanValue()) {
            for (BudgetPeriod period : budget.getBudgetPeriods()) {
                this.getBudgetModularService().generateModularPeriod(period);
            }
        }
        if (this.isRateTypeChanged(originalBudget, budget)) {
            return this.getModelAndViewService().showDialog("PropBudget-BudgetSettings-ChangeRateDialog", true, (UifFormBase)form);
        }
        if (this.applyOnOffCampusFlagToLineItems(budget)) {
            this.getBudgetSummaryService().updateOnOffCampusFlag(budget, budget.getOnOffCampusFlag());
        }
        super.save(form);
        form.setEvaluateFlagsAndModes(true);
        form.setCanEditView(null);
        this.getDataObjectService().wrap((Object)form.getBudget()).fetchRelationship("budgetStatusDo");
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    private boolean applyOnOffCampusFlagToLineItems(Budget currentBudget) {
        return !OnOffCampusFlagConstants.Default.getCode().equals(currentBudget.getOnOffCampusFlag());
    }

    @Transactional
    @RequestMapping(params={"methodToCall=markBudgetVersionComplete"})
    public ModelAndView markBudgetVersionComplete(@RequestParam(value="budgetId") Long budgetId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = this.getProposalBudgetSharedController().getSelectedBudget(budgetId, form.getDevelopmentProposal().getBudgets());
        form.getDocument().refreshPessimisticLocks();
        if (this.getProposalBudgetSharedController().isBudgetLocked(budget.getBudgetVersionNumber(), form.getDocument().getPessimisticLocks(), form.getPageId()) || !this.getProposalBudgetSharedController().isAllowedToCompleteBudget(budget, form.getPageId())) {
            form.setAjaxReturnType("update-page");
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        this.getProposalBudgetSharedController().markBudgetVersionStatus(budget, "budgetStatusCompleteCode");
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=markBudgetVersionIncomplete"})
    public ModelAndView markBudgetIncomplete(@RequestParam(value="budgetId") Long budgetId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = this.getProposalBudgetSharedController().getSelectedBudget(budgetId, form.getDevelopmentProposal().getBudgets());
        form.getDocument().refreshPessimisticLocks();
        if (this.getProposalBudgetSharedController().isBudgetLocked(budget.getBudgetVersionNumber(), form.getDocument().getPessimisticLocks(), form.getPageId())) {
            form.setAjaxReturnType("update-page");
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        this.getProposalBudgetSharedController().markBudgetVersionStatus(budget, "budgetStatusIncompleteCode");
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=closeBudgetVersionDialog"})
    public ModelAndView closeBudgetVersionDialog(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        form.setEvaluateFlagsAndModes(true);
        form.setCanEditView(null);
        return this.getKcCommonControllerService().closeDialog("PropBudget-BudgetVersions-Dialog", form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=closeBudgetSettings"})
    public ModelAndView closeBudgetSettings(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.processAuditRuleValidation(form);
        return this.getKcCommonControllerService().closeDialog("PropBudget-BudgetSettings-Dialog", form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=closeBudgetValidation"})
    public ModelAndView closeBudgetValidation(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.processAuditRuleValidation(form);
        return this.getKcCommonControllerService().closeDialog("DataValidationSection", form);
    }

    protected void processAuditRuleValidation(ProposalBudgetForm form) {
        if (form.isAuditActivated()) {
            ((ProposalBudgetViewHelperServiceImpl)form.getViewHelperService()).applyBudgetAuditRules(form);
        }
        form.setAjaxReturnType("update-page");
    }

    @Transactional
    @RequestMapping(params={"methodToCall=confirmBudgetSettings"})
    public ModelAndView confirmBudgetSettings(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        this.getBudgetCalculationService().resetBudgetLineItemCalculatedAmounts(budget);
        form.setEvaluateFlagsAndModes(true);
        return super.save(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=resetBudgetSettings"})
    public ModelAndView resetBudgetSettings(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        Budget originalBudget = this.getOriginalBudget(form);
        budget.setOhRateClassCode(originalBudget.getOhRateClassCode());
        budget.setUrRateClassCode(originalBudget.getUrRateClassCode());
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=sessionTimeout"})
    public ModelAndView sessionTimeout(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getTransactionalDocumentControllerService().sessionTimeout((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addLine"})
    public ModelAndView addLine(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getCollectionControllerService().addLine((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addBlankLine"})
    public ModelAndView addBlankLine(@ModelAttribute(value="KualiForm") ProposalBudgetForm uifForm) {
        return this.getCollectionControllerService().addBlankLine((UifFormBase)uifForm);
    }

    @Override
    @Transactional
    @RequestMapping(params={"methodToCall=saveLine"})
    public ModelAndView saveLine(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return super.saveLine(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deleteLine"})
    public ModelAndView deleteLine(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getCollectionControllerService().deleteLine((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=back"})
    public ModelAndView back(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getNavigationControllerService().back((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=returnToPrevious"})
    public ModelAndView returnToPrevious(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getNavigationControllerService().returnToPrevious((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=returnToHub"})
    public ModelAndView returnToHub(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getKcCommonControllerService().returnHome(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=returnToHistory"})
    public ModelAndView returnToHistory(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, boolean homeFlag) {
        return this.getNavigationControllerService().returnToHistory((UifFormBase)form, false, homeFlag, false);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=refresh"})
    public ModelAndView refresh(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=performLookup"})
    public ModelAndView performLookup(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getQueryControllerService().performLookup((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=checkForm"})
    public ModelAndView checkForm(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getModelAndViewService().checkForm((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=performFieldSuggest"})
    @ResponseBody
    public AttributeQueryResult performFieldSuggest(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getQueryControllerService().performFieldSuggest((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=performFieldQuery"})
    @ResponseBody
    public AttributeQueryResult performFieldQuery(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getQueryControllerService().performFieldQuery((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=tableCsvRetrieval"}, produces={"text/csv"})
    @ResponseBody
    public String tableCsvRetrieval(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.getUifExportControllerService().tableCsvRetrieval(form, request, response);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=tableXlsRetrieval"}, produces={"text/csv"})
    @ResponseBody
    public String tableXlsRetrieval(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.getUifExportControllerService().tableXlsRetrieval(form, request, response);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=tableXmlRetrieval"}, produces={"text/csv"})
    @ResponseBody
    public String tableXmlRetrieval(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.getUifExportControllerService().tableXmlRetrieval(form, request, response);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=tableJsonRetrieval"})
    public ModelAndView tableJsonRetrieval(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getCollectionControllerService().tableJsonRetrieval((UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=retrieveCollectionPage"})
    public ModelAndView retrieveCollectionPage(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        return this.getCollectionControllerService().retrieveCollectionPage((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editLineItem"})
    public ModelAndView editLineItem(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (form.getEditableBudgetLineItems().containsKey(selectedCollectionPath)) {
            form.getEditableBudgetLineItems().get(selectedCollectionPath).add(selectedLine);
        } else {
            ArrayList<String> newKeyList = new ArrayList<String>();
            newKeyList.add(selectedLine);
            form.getEditableBudgetLineItems().put(selectedCollectionPath, newKeyList);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=cancelEditLineItem"})
    public ModelAndView cancelEditLineItem(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (form.getEditableBudgetLineItems().containsKey(selectedCollectionPath)) {
            form.getEditableBudgetLineItems().get(selectedCollectionPath).remove(selectedLine);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=retrieveEditLineDialog"})
    public ModelAndView retrieveEditLineDialog(UifFormBase form) {
        return this.getCollectionControllerService().retrieveEditLineDialog(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=closeEditLineDialog"})
    public ModelAndView closeEditLineDialog(UifFormBase form) {
        return this.getCollectionControllerService().closeEditLineDialog(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editLine"})
    public ModelAndView editLine(UifFormBase form) {
        return this.getCollectionControllerService().editLine(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropBudget-SummaryPage"})
    public ModelAndView navigateToBudgetSummary(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        return super.navigate(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=populateBudgetSummary"})
    public ModelAndView populateBudgetSummary(@RequestParam(value="budgetId") Long budgetId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        super.save(form);
        return this.getProposalBudgetSharedController().populateBudgetSummary(budgetId, form.getDevelopmentProposal().getBudgets(), form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=populatePrintForms"})
    public ModelAndView populatePrintForms(@RequestParam(value="budgetId") Long budgetId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        super.save(form);
        return this.getProposalBudgetSharedController().populatePrintForms(budgetId, form.getDevelopmentProposal().getBudgets(), form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=printBudgetForms"})
    public ModelAndView printBudgetForms(@ModelAttribute(value="KualiForm") ProposalBudgetForm form, HttpServletResponse response) throws Exception {
        return this.getProposalBudgetSharedController().printBudgetForms(form.getSelectedBudget(), form, response);
    }

    public ProposalBudgetLockService getProposalBudgetLockService() {
        return this.proposalBudgetLockService;
    }

    public void setProposalBudgetLockService(ProposalBudgetLockService proposalBudgetLockService) {
        this.proposalBudgetLockService = proposalBudgetLockService;
    }

    public ProposalBudgetSharedControllerService getProposalBudgetSharedController() {
        return this.proposalBudgetSharedController;
    }

    public void setProposalBudgetSharedController(ProposalBudgetSharedControllerService proposalBudgetSharedController) {
        this.proposalBudgetSharedController = proposalBudgetSharedController;
    }
}

