/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.hierarchy;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyErrorWarningDto;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentHierarchyController
extends ProposalDevelopmentControllerBase {
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    ProposalHierarchyService proposalHierarchyService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=createHierarchy"})
    public ModelAndView createHierarchy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        DevelopmentProposal initialChildProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        List<ProposalHierarchyErrorWarningDto> errors = this.getProposalHierarchyService().validateChildCandidate(initialChildProposal);
        if (!this.displayErrors(errors)) {
            String userId = this.getGlobalVariableService().getUserSession().getPrincipalId();
            String hierarchyProposalNumber = this.getProposalHierarchyService().createHierarchy(initialChildProposal, userId).getProposalNumber();
            this.displayMessage("message.hierarchy.create.success", hierarchyProposalNumber);
            form.setAuditActivated(false);
            form.setEvaluateFlagsAndModes(true);
            form.setCanEditView(null);
        }
        return this.updateHierarchySummaryIfNeeded(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=syncAllHierarchy"})
    public ModelAndView syncAllHierarchy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        ProposalDevelopmentDocument hierarchyProposalDoc = form.getProposalDevelopmentDocument();
        List<ProposalHierarchyErrorWarningDto> errors = this.getProposalHierarchyService().validateParent(hierarchyProposalDoc.getDevelopmentProposal());
        if (!this.displayErrors(errors)) {
            this.getProposalHierarchyService().synchronizeAllChildren(hierarchyProposalDoc.getDevelopmentProposal());
            this.displayMessage("message.hierarchy.sync.success", new String[0]);
        }
        return this.updateHierarchySummaryIfNeeded(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=linkToHierarchy"})
    public ModelAndView linkToHierarchy(@RequestParam(value="hierarchyProposalNumber") String hierarchyProposalNumber, @RequestParam(value="hierarchyBudgetTypeCode") String hierarchyBudgetTypeCode, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        DevelopmentProposal hierarchyProposal = this.getProposalHierarchyService().getDevelopmentProposal(hierarchyProposalNumber);
        DevelopmentProposal newChildProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        ProposalDevelopmentBudgetExt childBudget = this.getProposalHierarchyService().getSyncableBudget(newChildProposal);
        if (childBudget == null) {
            this.getGlobalVariableService().getMessageMap().putError("newHierarchyChildProposalNumber", "error.hierarchy.link.noBudgetVersion", new String[0]);
        } else {
            List<ProposalHierarchyErrorWarningDto> errors;
            DialogResponse response = form.getDialogResponse("PropDev-SyncConfirmationDialog");
            if (response == null && this.getProposalHierarchyService().needToExtendProjectDate(hierarchyProposal, newChildProposal)) {
                return this.getModelAndViewService().showDialog("PropDev-SyncConfirmationDialog", true, (UifFormBase)form);
            }
            if ((response == null || response.getResponseAsBoolean()) && !this.displayErrors(errors = this.getProposalHierarchyService().validateLinkToHierarchy(hierarchyProposal, newChildProposal))) {
                this.linkToHierarchy(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode, () -> {
                    this.displayMessage("message.hierarchy.link.success", newChildProposal.getProposalNumber(), hierarchyProposal.getProposalNumber());
                    form.setAuditActivated(false);
                    form.setEvaluateFlagsAndModes(true);
                    form.setCanEditView(null);
                });
            }
        }
        return this.updateHierarchySummaryIfNeeded(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=linkChildToHierarchy"})
    public ModelAndView linkChildToHierarchy(@RequestParam(value="hierarchyProposalNumber") String hierarchyProposalNumber, @RequestParam(value="hierarchyBudgetTypeCode") String hierarchyBudgetTypeCode, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        DevelopmentProposal hierarchyProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        DevelopmentProposal newChildProposal = this.getProposalHierarchyService().getDevelopmentProposal(hierarchyProposalNumber);
        DialogResponse response = form.getDialogResponse("PropDev-SyncConfirmationDialog");
        ArrayList<ProposalHierarchyErrorWarningDto> errors = new ArrayList<ProposalHierarchyErrorWarningDto>();
        if (newChildProposal == null) {
            errors.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.proposal.not.found", Boolean.TRUE, new String[0]));
            this.displayErrors(errors);
        } else {
            if (response == null && this.getProposalHierarchyService().needToExtendProjectDate(hierarchyProposal, newChildProposal)) {
                return this.getModelAndViewService().showDialog("PropDev-SyncConfirmationDialog", true, (UifFormBase)form);
            }
            if (response == null || response.getResponseAsBoolean()) {
                errors.addAll(this.getProposalHierarchyService().validateParent(hierarchyProposal, newChildProposal));
                errors.addAll(this.getProposalHierarchyService().validateChildCandidate(newChildProposal));
                errors.addAll(this.getProposalHierarchyService().validateChildCandidateForHierarchy(hierarchyProposal, newChildProposal, true));
                errors.addAll(this.getProposalHierarchyService().validateSponsor(newChildProposal, hierarchyProposal));
                errors.addAll(this.getProposalHierarchyService().validateIsAggregatorOnChild(newChildProposal));
                errors.addAll(this.getProposalHierarchyService().validateChildBudgetPeriods(hierarchyProposal, newChildProposal, true));
                if (!this.displayErrors(errors)) {
                    this.linkToHierarchy(hierarchyProposal, newChildProposal, hierarchyBudgetTypeCode, () -> this.displayMessage("message.hierarchy.link.success", hierarchyProposal.getProposalNumber(), newChildProposal.getProposalNumber()));
                }
            }
        }
        return this.updateHierarchySummaryIfNeeded(form);
    }

    private void linkToHierarchy(DevelopmentProposal parent, DevelopmentProposal newChild, String hierarchyBudgetTypeCode, Runnable onSuccess) {
        List<String> missingForms = this.updateChildOpportunityFromParent(parent, newChild, Optional.empty());
        if (missingForms.size() == 0) {
            this.getProposalHierarchyService().linkToHierarchy(parent, newChild, hierarchyBudgetTypeCode);
            onSuccess.run();
        } else {
            newChild.setS2sOpportunity(null);
            this.getS2sFormConfigurations(missingForms, Optional.empty()).forEach(missingFormConfig -> this.getGlobalVariableService().getMessageMap().putError("noField", "error.label.value.generic", new String[]{missingFormConfig.getFormName(), missingFormConfig.getInactiveMessage()}));
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=hierarchyActionCanceled"})
    public ModelAndView hierarchyActionCanceled(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        return this.getNavigationControllerService().back((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=syncToHierarchyParent"})
    public ModelAndView syncToHierarchyParent(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        DevelopmentProposal childProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        DevelopmentProposal hierarchy = this.getProposalHierarchyService().getDevelopmentProposal(childProposal.getHierarchyParentProposalNumber());
        List<ProposalHierarchyErrorWarningDto> errors = this.getProposalHierarchyService().validateChildForSync(childProposal, hierarchy, false);
        if (!this.displayErrors(errors)) {
            this.getProposalHierarchyService().synchronizeChild(childProposal);
            this.displayMessage("message.hierarchy.sync.success", new String[0]);
        }
        return this.updateHierarchySummaryIfNeeded(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=removeFromHierarchy"})
    public ModelAndView removeFromHierarchy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        DevelopmentProposal childProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        List<ProposalHierarchyErrorWarningDto> errors = this.getProposalHierarchyService().validateChildForRemoval(childProposal);
        if (!this.displayErrors(errors)) {
            if (childProposal.isMultiProjectChild()) {
                childProposal.setS2sOpportunity(null);
            }
            childProposal = this.getProposalHierarchyService().removeFromHierarchy(childProposal);
            form.getProposalDevelopmentDocument().setDevelopmentProposal(childProposal);
            this.displayMessage("message.hierarchy.remove.success", new String[0]);
            form.setEvaluateFlagsAndModes(true);
            form.setCanEditView(null);
        }
        return this.updateHierarchySummaryIfNeeded(form);
    }

    protected void displayMessage(String messageKey, String ... errorParameters) {
        this.getGlobalVariableService().getMessageMap().putInfo("newHierarchyProposal.x", messageKey, errorParameters);
    }

    protected boolean displayErrors(List<ProposalHierarchyErrorWarningDto> errors) {
        int severeErrors = 0;
        for (ProposalHierarchyErrorWarningDto error : errors) {
            severeErrors += error.isSevere() ? 1 : 0;
            if (error.isSevere()) {
                this.getGlobalVariableService().getMessageMap().putError("newHierarchyProposal.x", error.getErrorKey(), error.getErrorParameters());
                continue;
            }
            this.getGlobalVariableService().getMessageMap().putWarning("newHierarchyProposal.x", error.getErrorKey(), error.getErrorParameters());
        }
        return severeErrors > 0;
    }

    protected ModelAndView updateHierarchySummaryIfNeeded(ProposalDevelopmentDocumentForm form) {
        if (StringUtils.equals((CharSequence)form.getPageId(), (CharSequence)"PropDev-SubmitPage")) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).prepareSummaryPage(form, true);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    @Override
    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }
}

