/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionAgencyDataService;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionValidationService;
import org.kuali.coeus.propdev.impl.s2s.nih.NihValidationMapping;
import org.kuali.coeus.propdev.impl.s2s.nih.NihValidationServiceUtils;
import org.kuali.coeus.propdev.impl.s2s.nih.ValidationMessageDto;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.generate.FormGenerationResult;
import org.kuali.coeus.s2sgen.api.generate.FormGeneratorService;
import org.kuali.coeus.s2sgen.api.generate.MultiProjectFormGenerationResult;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

public class ProposalDevelopmentGrantsGovAuditRule
implements DocumentAuditRule {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentGrantsGovAuditRule.class);
    private static final String VALIDATION_SERVICE = "Validation Service";
    private static final String ERROR = "Error";
    private static final String WARNINGS = "Warnings";
    private static final String SUPPRESSED = "Suppressed";
    private static final String PAGE_SECTION_DELIMETER = ".";
    private static final String ERROR_CODE = "E";
    private static final String UAF = "document.developmentProposal.S2sUserAttachedForms[%d].formName";
    private static final String RULE_NUMBER = "ruleNumber";
    public static final String ACTIVE = "active";
    private ParameterService parameterService;
    private GlobalVariableService globalVariableService;
    private BusinessObjectService businessObjectService;
    private NihSubmissionValidationService nihSubmissionValidationService;
    private NihSubmissionAgencyDataService nihSubmissionAgencyDataService;
    private SponsorHierarchyService sponsorHierarchyService;
    private FormGeneratorService formGeneratorService;
    private ProposalHierarchyService proposalHierarchyService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        if (proposalDevelopmentDocument.getDevelopmentProposal().hasS2sOpportunity() && (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() == null || StringUtils.equalsIgnoreCase((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode(), (CharSequence)""))) {
            valid = false;
            this.getAuditErrors("S2S Opportunity Search", "Opportunity", "", ERROR).add(new AuditError("document.developmentProposal.s2sOpportunity.s2sSubmissionTypeCode", "error.submissionType.notSelected", "PropDev-OpportunityPage.PropDev-OpportunityPage-General"));
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getProposalTypeCode() != null && proposalDevelopmentDocument.getDevelopmentProposal().hasS2sOpportunity() && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null && proposalDevelopmentDocument.getDevelopmentProposal().getProposalTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision")) && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionCode() == null) {
            valid = false;
            this.getAuditErrors("S2S Opportunity Search", "Opportunity", "", ERROR).add(new AuditError("document.developmentProposal.s2sOpportunity.revisionCode", "error.s2sopportunity.revisiontype", "PropDev-OpportunityPage.PropDev-OpportunityPage-General"));
        }
        if ((this.getSponsorHierarchyService().isSponsorNihOsc(proposalDevelopmentDocument.getDevelopmentProposal().getSponsorCode()) || this.getSponsorHierarchyService().isSponsorNihMultiplePi(proposalDevelopmentDocument.getDevelopmentProposal().getSponsorCode())) && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getCompetitionId() != null && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getCompetitionId().equals("ADOBE-FORMS-A")) {
            this.getAuditErrors("S2S Opportunity Search", "Opportunity", "", ERROR).add(new AuditError("document.developmentProposal.s2sOpportunity.competitionId", "error.s2sopportunity.competitionIdInvalid", "PropDev-OpportunityPage.PropDev-OpportunityPage-General"));
            valid = false;
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().hasS2sOpportunity()) {
            S2sOpportunity s2sOpportunity = proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity();
            String provider = s2sOpportunity.getS2sProvider().getDescription();
            try {
                if (s2sOpportunity.isMultiProject()) {
                    return this.validateMultiProjectProposals(valid, proposalDevelopmentDocument);
                }
                FormGenerationResult result = this.getS2sValidatorService().generateAndValidateForms((ProposalDevelopmentDocumentContract)proposalDevelopmentDocument);
                valid &= result.isValid();
                if (result.isValid() && CollectionUtils.isEmpty(proposalDevelopmentDocument.getDevelopmentProposal().getS2sAppSubmission()) && this.isNIHOpportunity(proposalDevelopmentDocument.getDevelopmentProposal())) {
                    valid &= this.nihValidation(proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber(), result.getApplicationXml(), result.getAttachments());
                }
                this.setValidationErrorMessage(result.getErrors(), provider);
            }
            catch (S2SException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Error validating submission information", (Throwable)e);
                }
                this.getAuditErrors("S2S Opportunity Search", "Opportunity", provider, ERROR).add(new AuditError("noField", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-OpportunityPage.PropDev-OpportunityPage-General", new String[]{StringUtils.isNotBlank((CharSequence)e.getErrorMessage()) ? e.getErrorMessage() : e.getMessage()}));
                valid = false;
            }
            valid &= this.allUatIncludedValidation(proposalDevelopmentDocument.getDevelopmentProposal());
            valid &= this.checkOutdatedOpportunity(proposalDevelopmentDocument.getDevelopmentProposal(), provider);
        }
        return valid;
    }

    boolean validateMultiProjectProposals(boolean valid, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        List<ProposalDevelopmentDocument> allProposals;
        List<ProposalDevelopmentDocument> children;
        ProposalDevelopmentDocument parent;
        S2sOpportunity s2sOpportunity = proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity();
        String provider = s2sOpportunity.getS2sProvider().getDescription();
        if (proposalDevelopmentDocument.getDevelopmentProposal().isParent()) {
            parent = proposalDevelopmentDocument;
            children = this.getProposalHierarchyService().getHierarchyChildren(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber()).stream().map(DevelopmentProposal::getProposalDocument).map(pd -> pd).collect(Collectors.toList());
            allProposals = Stream.concat(children.stream(), Stream.of(parent)).collect(Collectors.toList());
        } else {
            parent = this.getProposalHierarchyService().getParentDocument(proposalDevelopmentDocument);
            children = Collections.singletonList(proposalDevelopmentDocument);
            allProposals = children;
        }
        MultiProjectFormGenerationResult result = this.getS2sValidatorService().generateAndValidateMPForms((ProposalDevelopmentDocumentContract)parent, children);
        allProposals.stream().map(pdc -> pdc.getDevelopmentProposal().getProposalNumber()).forEach(proposalNumber -> result.getProposalErrors(proposalNumber).ifPresent(errors -> this.setValidationErrorMessage((List<org.kuali.coeus.s2sgen.api.core.AuditError>)errors, provider, (Optional<String>)Optional.of(" (" + proposalNumber + ")"))));
        valid &= result.isValid();
        try {
            if (result.isValid() && CollectionUtils.isEmpty(parent.getDevelopmentProposal().getS2sAppSubmission()) && this.isNIHOpportunity(parent.getDevelopmentProposal())) {
                valid &= this.nihValidation(parent.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber(), result.getApplicationXml(), result.getAttachments());
            }
        }
        catch (S2SException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Error validating submission information", (Throwable)e);
            }
            this.getAuditErrors("S2S Opportunity Search", "Opportunity", provider, ERROR).add(new AuditError("noField", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-OpportunityPage.PropDev-OpportunityPage-General", new String[]{StringUtils.isNotBlank((CharSequence)e.getErrorMessage()) ? e.getErrorMessage() : e.getMessage()}));
            valid = false;
        }
        valid &= allProposals.stream().map(ProposalDevelopmentDocumentContract::getDevelopmentProposal).allMatch(proposal -> this.allUatIncludedValidation((DevelopmentProposal)proposal));
        return valid &= this.checkOutdatedOpportunity(parent.getDevelopmentProposal(), provider);
    }

    private boolean checkOutdatedOpportunity(DevelopmentProposal developmentProposal, String provider) {
        S2sOpportunity s2sOpportunity = developmentProposal.getS2sOpportunity();
        if (StringUtils.isBlank((CharSequence)s2sOpportunity.getPackageId()) && developmentProposal.getS2sAppSubmission().isEmpty()) {
            this.getAuditErrors("S2S Opportunity Search", "Opportunity", provider, ERROR).add(new AuditError("PropDev-OpportunityPage", "s2s.old.opportunity", "PropDev-OpportunityPage.PropDev-OpportunityPage-General"));
            return false;
        }
        return true;
    }

    boolean isNIHOpportunity(DevelopmentProposal developmentProposal) {
        return StringUtils.isNotBlank((CharSequence)developmentProposal.getS2sOpportunity().getPackageId()) && this.getNihSubmissionAgencyDataService().isNIHOpportunity(developmentProposal.getApplicantOrganization().getOrganization().getDunsNumber(), developmentProposal.getS2sOpportunity().getPackageId());
    }

    private boolean allUatIncludedValidation(DevelopmentProposal developmentProposal) {
        Set includedUafs = developmentProposal.getS2sOppForms().stream().filter(form -> form.getInclude() != null && form.getInclude() != false).filter(form -> form.getUserAttachedForm() != null && form.getUserAttachedForm() != false).map(S2sOppForms::getOppNameSpace).collect(Collectors.toSet());
        for (int i = 0; i < developmentProposal.getS2sUserAttachedForms().size(); ++i) {
            S2sUserAttachedForm form2 = developmentProposal.getS2sUserAttachedForms().get(i);
            if (includedUafs.contains(form2.getNamespace())) continue;
            this.getAuditErrors("S2S Opportunity Search", "Opportunity", developmentProposal.getS2sOpportunity().getS2sProvider().getDescription(), WARNINGS).add(new AuditError(String.format(UAF, i), "warning.s2s.userattachedform.unused", "PropDev-OpportunityPage.PropDev-OpportunityPage-UserAttachedForms", new String[]{form2.getFormName()}));
        }
        return true;
    }

    boolean nihValidation(String dunsNumber, String applicationXml, List<AttachmentData> attachments) {
        boolean result;
        try {
            List<ValidationMessageDto> response = this.getNihSubmissionValidationService().validateApplication(applicationXml, attachments, dunsNumber);
            result = response.isEmpty();
            Map mappingsByRuleNumber = response.stream().map(this::getNihValidationMapping).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(NihValidationMapping::getRuleNumber, Function.identity(), (v1, v2) -> v2));
            Map<String, List<ValidationMessageDto>> categorizedResponses = response.stream().collect(Collectors.groupingBy(msg -> this.getErrorType((ValidationMessageDto)msg, Optional.ofNullable((NihValidationMapping)mappingsByRuleNumber.get(msg.getValidationRuleNumber())))));
            categorizedResponses.keySet().stream().filter(errorType -> !SUPPRESSED.equals(errorType)).forEach(errorType -> this.sortMessages((List)categorizedResponses.get(errorType)).forEach(msg -> this.addToAuditErrors((ValidationMessageDto)msg, Optional.ofNullable((NihValidationMapping)mappingsByRuleNumber.get(msg.getValidationRuleNumber())), (String)errorType)));
        }
        catch (S2sCommunicationException ex) {
            LOG.error("Error validating with nih.gov", (Throwable)ex);
            this.getAuditErrors("S2S Opportunity Search", "Opportunity", VALIDATION_SERVICE, ERROR).add(new AuditError("PropDev-OpportunityPage", ex.getErrorKey(), "", ex.getMessageWithParams()));
            result = false;
        }
        return result;
    }

    private String getErrorType(ValidationMessageDto msg, Optional<NihValidationMapping> mappingOptional) {
        return mappingOptional.map(mapping -> {
            switch (mapping.getOverrideType()) {
                case ERROR: {
                    return ERROR;
                }
                case WARNING: {
                    return WARNINGS;
                }
                case SUPPRESS: {
                    return SUPPRESSED;
                }
            }
            return null;
        }).orElse(ERROR_CODE.equals(msg.getValidationSeverityCode()) ? ERROR : WARNINGS);
    }

    private void addToAuditErrors(ValidationMessageDto error, Optional<NihValidationMapping> mapping, String errorType) {
        String sectionId;
        String pageId;
        if (!mapping.isPresent() || StringUtils.isEmpty((CharSequence)mapping.get().getPageId())) {
            pageId = "S2S Opportunity Search";
            sectionId = "Opportunity";
        } else {
            pageId = mapping.get().getPageId();
            sectionId = mapping.get().getSectionId();
        }
        this.getAuditErrors(pageId, sectionId, VALIDATION_SERVICE, errorType).add(this.getCustomizedAuditError(error, mapping));
    }

    private Stream<ValidationMessageDto> sortMessages(List<ValidationMessageDto> messages) {
        Comparator<ValidationMessageDto> comparator = Comparator.comparing(ValidationMessageDto::getFormName).thenComparing(ValidationMessageDto::getValidationRuleNumber).thenComparingInt(ValidationMessageDto::getValidationMessageId).thenComparing(ValidationMessageDto::getValidationMessageText);
        return messages.stream().sorted(comparator);
    }

    private AuditError getCustomizedAuditError(ValidationMessageDto msg, Optional<NihValidationMapping> mapping) {
        return this.createAuditErrorBasedOnMapping(msg, mapping);
    }

    protected Optional<NihValidationMapping> getNihValidationMapping(ValidationMessageDto msg) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(RULE_NUMBER, msg.getValidationRuleNumber());
        criteria.put(ACTIVE, Boolean.TRUE);
        return Optional.ofNullable((NihValidationMapping)this.getBusinessObjectService().findByPrimaryKey(NihValidationMapping.class, criteria));
    }

    AuditError createAuditErrorBasedOnMapping(ValidationMessageDto msg, Optional<NihValidationMapping> mapping) {
        if (!mapping.isPresent()) {
            return new AuditError("PropDev-OpportunityPage", "error.grantsgov.schemavalidation.generic.errorkey", "", new String[]{NihValidationServiceUtils.toMessageString(msg)});
        }
        NihValidationMapping match = mapping.get();
        Object errorMessage = NihValidationServiceUtils.toMessageString(msg);
        if (!StringUtils.isEmpty((CharSequence)match.getCustomMessage())) {
            errorMessage = match.getAppendToOriginal() ? (String)errorMessage + " " + match.getCustomMessage() : ((String)errorMessage).replace(msg.getValidationMessageText(), match.getCustomMessage());
        }
        return new AuditError(StringUtils.isEmpty((CharSequence)match.getPageId()) ? "PropDev-OpportunityPage" : match.getPageId(), "error.grantsgov.schemavalidation.generic.errorkey", this.getAuditLink(mapping.get()), new String[]{errorMessage});
    }

    protected List<AuditError> getAuditErrors(String areaName, String sectionName, String provider, String level) {
        String clusterKey = areaName + PAGE_SECTION_DELIMETER + sectionName + PAGE_SECTION_DELIMETER + level;
        String s2sClusterKey = clusterKey + ".s2s";
        AuditCluster value = this.getGlobalVariableService().getAuditErrorMap().computeIfAbsent(s2sClusterKey, k -> new AuditCluster(clusterKey, new ArrayList(), provider + " " + level));
        this.getGlobalVariableService().getAuditErrorMap().put(s2sClusterKey, value);
        return this.getGlobalVariableService().getAuditErrorMap().get(clusterKey + ".s2s").getAuditErrorList();
    }

    String getAuditLink(NihValidationMapping match) {
        return StringUtils.isEmpty((CharSequence)match.getPageId()) ? "" : (StringUtils.isEmpty((CharSequence)match.getSectionId()) ? match.getPageId() : match.getPageId() + PAGE_SECTION_DELIMETER + match.getSectionId());
    }

    private void setValidationErrorMessage(List<org.kuali.coeus.s2sgen.api.core.AuditError> s2sErrors, String provider) {
        this.setValidationErrorMessage(s2sErrors, provider, Optional.empty());
    }

    private void setValidationErrorMessage(List<org.kuali.coeus.s2sgen.api.core.AuditError> s2sErrors, String provider, Optional<String> proposalNumber) {
        if (s2sErrors != null) {
            LOG.info("Error list size:" + s2sErrors.size() + s2sErrors.toString());
            for (org.kuali.coeus.s2sgen.api.core.AuditError error : s2sErrors) {
                String errorMessage = error.getMessageKey() + proposalNumber.orElse("");
                if (StringUtils.equals((CharSequence)error.getLink(), (CharSequence)"abstractsAttachments")) {
                    this.getAuditErrors("Attachments", "Proposal Attachments", provider, error.getLevel() == AuditError.Level.WARNING ? WARNINGS : ERROR).add(new AuditError("document.developmentProposal.narratives", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-ProposalSection", new String[]{errorMessage}));
                    continue;
                }
                if (StringUtils.equals((CharSequence)error.getLink(), (CharSequence)"questions")) {
                    this.getAuditErrors("Questionnaire", "", provider, error.getLevel() == AuditError.Level.WARNING ? WARNINGS : ERROR).add(new AuditError("PropDev-QuestionnairePage", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-QuestionnairePage", new String[]{errorMessage}));
                    continue;
                }
                if (StringUtils.equals((CharSequence)error.getLink(), (CharSequence)"keyPersonnel")) {
                    this.getAuditErrors("Personnel", "", provider, error.getLevel() == AuditError.Level.WARNING ? WARNINGS : ERROR).add(new AuditError("PropDev-PersonnelPage", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-PersonnelPage", new String[]{errorMessage}));
                    continue;
                }
                if (StringUtils.equals((CharSequence)error.getLink(), (CharSequence)"proposal.Organization/Location")) {
                    this.getAuditErrors("Organizations & Locations", "Applicant Organization", provider, error.getLevel() == AuditError.Level.WARNING ? WARNINGS : ERROR).add(new AuditError("PropDev-OrganizationLocationsPage", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-OrganizationLocationsPage.PropDev-ApplicantOrganizationPage-Section", new String[]{errorMessage}));
                    continue;
                }
                if (StringUtils.equals((CharSequence)error.getLink(), (CharSequence)"proposal.SponsorProgramInformation")) {
                    this.getAuditErrors("Sponsor & Program Info", "", provider, error.getLevel() == AuditError.Level.WARNING ? WARNINGS : ERROR).add(new AuditError("PropDev-SponsorProgramInfoPage", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-SponsorProgramInfoPage", new String[]{errorMessage}));
                    continue;
                }
                this.getAuditErrors("S2S Opportunity Search", "Opportunity", provider, error.getLevel() == AuditError.Level.WARNING ? WARNINGS : ERROR).add(new AuditError("PropDev-OpportunityPage", "error.grantsgov.schemavalidation.generic.errorkey", "PropDev-OpportunityPage.PropDev-OpportunityPage-General", new String[]{errorMessage}));
            }
        }
    }

    private SponsorHierarchyService getSponsorHierarchyService() {
        if (this.sponsorHierarchyService == null) {
            this.sponsorHierarchyService = KcServiceLocator.getService(SponsorHierarchyService.class);
        }
        return this.sponsorHierarchyService;
    }

    private FormGeneratorService getS2sValidatorService() {
        if (this.formGeneratorService == null) {
            this.formGeneratorService = KcServiceLocator.getService(FormGeneratorService.class);
        }
        return this.formGeneratorService;
    }

    public void setS2sValidatorService(FormGeneratorService formGeneratorService) {
        this.formGeneratorService = formGeneratorService;
    }

    protected NihSubmissionValidationService getNihSubmissionValidationService() {
        if (this.nihSubmissionValidationService == null) {
            this.nihSubmissionValidationService = KcServiceLocator.getService(NihSubmissionValidationService.class);
        }
        return this.nihSubmissionValidationService;
    }

    void setNihSubmissionValidationService(NihSubmissionValidationService nihSubmissionValidationService) {
        this.nihSubmissionValidationService = nihSubmissionValidationService;
    }

    protected NihSubmissionAgencyDataService getNihSubmissionAgencyDataService() {
        if (this.nihSubmissionAgencyDataService == null) {
            this.nihSubmissionAgencyDataService = KcServiceLocator.getService(NihSubmissionAgencyDataService.class);
        }
        return this.nihSubmissionAgencyDataService;
    }

    void setNihSubmissionAgencyDataService(NihSubmissionAgencyDataService nihSubmissionAgencyDataService) {
        this.nihSubmissionAgencyDataService = nihSubmissionAgencyDataService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    protected ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = KcServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }

    void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }
}

