/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingDao;
import org.kuali.kra.printing.schema.AwardReportingRequirementDocument;
import org.kuali.kra.printing.schema.ReportingRequirement;
import org.kuali.kra.printing.schema.ReportingRequirementDetail;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.DocumentService;

public class ReportTrackingXmlStream
implements XmlStream<AwardReportingRequirementDocument> {
    private static final Logger LOG = LogManager.getLogger(ReportTrackingXmlStream.class);
    private DateTimeService dateTimeService;
    private DocumentService documentService;
    private ReportTrackingDao reportTrackingDao;
    private AwardService awardService;

    @Override
    public Class<AwardReportingRequirementDocument> type() {
        return AwardReportingRequirementDocument.class;
    }

    @Override
    public Map<String, AwardReportingRequirementDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        ReportTracking reporTracking = (ReportTracking)printableBusinessObject;
        AwardReportingRequirementDocument awardReportRequirementDoc = AwardReportingRequirementDocument.Factory.newInstance();
        try {
            awardReportRequirementDoc.setAwardReportingRequirement(this.getAwardReporting(reporTracking, reportParameters));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        HashMap<String, AwardReportingRequirementDocument> map = new HashMap<String, AwardReportingRequirementDocument>();
        map.put("AwardReportTracking", awardReportRequirementDoc);
        return map;
    }

    public AwardReportingRequirementDocument.AwardReportingRequirement getAwardReporting(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> htData) throws Exception {
        ReportTracking reportTracking = (ReportTracking)printableBusinessObject;
        AwardReportingRequirementDocument.AwardReportingRequirement awardReporting = AwardReportingRequirementDocument.AwardReportingRequirement.Factory.newInstance();
        HashMap<String, String> searchValues = new HashMap<String, String>();
        if (reportTracking.getPiName() != null) {
            searchValues.put("piName", reportTracking.getPiName());
        }
        if (reportTracking.getFrequencyBaseCode() != null) {
            searchValues.put("frequencyBaseCode", reportTracking.getFrequencyBaseCode());
        }
        if (reportTracking.getFrequencyCode() != null) {
            searchValues.put("frequencyCode", reportTracking.getFrequencyCode());
        }
        if (reportTracking.getReportClassCode() != null) {
            searchValues.put("reportClassCode", reportTracking.getReportClassCode());
        }
        if (reportTracking.getReportCode() != null) {
            searchValues.put("reportCode", reportTracking.getReportCode());
        }
        if (reportTracking.getBaseDate() != null) {
            searchValues.put("baseDate", this.getDateTimeService().toDateString((Date)reportTracking.getBaseDate()));
        }
        if (reportTracking.getSponsorCode() != null) {
            searchValues.put("sponsorCode", reportTracking.getSponsorCode());
        }
        if (reportTracking.getOverdue() != null) {
            searchValues.put("overdue", reportTracking.getOverdue().toString());
        }
        if (reportTracking.getPreparerName() != null) {
            searchValues.put("preparerName", reportTracking.getPreparerName());
        }
        if (reportTracking.getActivityDate() != null) {
            searchValues.put("activityDate", this.getDateTimeService().toDateString((Date)reportTracking.getActivityDate()));
        }
        if (reportTracking.getLeadUnitNumber() != null) {
            searchValues.put("leadUnitNumber", reportTracking.getLeadUnitNumber());
        }
        if (reportTracking.getDueDate() != null) {
            searchValues.put("dueDate", this.getDateTimeService().toDateString((Date)reportTracking.getDueDate()));
        }
        if (reportTracking.getComments() != null) {
            searchValues.put("comments", reportTracking.getComments());
        }
        if (reportTracking.getOspDistributionCode() != null) {
            searchValues.put("ospDistributionCode", reportTracking.getOspDistributionCode());
        }
        ArrayList<String> detailFields = new ArrayList<String>();
        detailFields.add("awardNumber");
        detailFields.add("leadUnitNumber");
        List<ReportTracking> detailResults = this.getReportTrackingDao().getDetailResults(searchValues, detailFields);
        this.setReportingRequirements(awardReporting, reportTracking, detailResults);
        return awardReporting;
    }

    private void setReportingRequirements(AwardReportingRequirementDocument.AwardReportingRequirement awardReporting, ReportTracking reportTracking, List<ReportTracking> detailResults) {
        ArrayList<ReportingRequirement> reportReqList = new ArrayList<ReportingRequirement>();
        ReportingRequirement reportingRequirement = ReportingRequirement.Factory.newInstance();
        reportingRequirement.setPrincipleInvestigatorName(reportTracking.getPiName());
        reportingRequirement.setReportClass(reportTracking.getReportClass().getDescription());
        if (reportTracking.getFrequency() != null) {
            reportingRequirement.setFrequency(reportTracking.getFrequency().getDescription());
        }
        if (reportTracking.getFrequencyBase() != null) {
            reportingRequirement.setFrequencyBase(reportTracking.getFrequencyBase().getDescription());
        }
        if (reportTracking.getBaseDate() != null) {
            reportingRequirement.setBaseDate(reportTracking.getBaseDate().toString());
        }
        reportingRequirement.setReportType(reportTracking.getReport().getDescription());
        reportingRequirement.setCopyOSP(reportTracking.getDistribution().getDescription());
        this.setReportingRequirementsDetail(awardReporting, reportingRequirement, detailResults);
        reportReqList.add(reportingRequirement);
        awardReporting.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        awardReporting.setReportingReqsArray(reportReqList.toArray(new ReportingRequirement[0]));
    }

    private void setReportingRequirementsDetail(AwardReportingRequirementDocument.AwardReportingRequirement awardReporting, ReportingRequirement reportingRequirement, List<ReportTracking> detailResults) {
        ArrayList<ReportingRequirementDetail> reportReqDetailList = new ArrayList<ReportingRequirementDetail>();
        for (ReportTracking reportTracking : detailResults) {
            List<Award> awardList = this.getAwardService().findAwardsForAwardNumber(reportTracking.getAwardNumber());
            for (Award award : awardList) {
                ReportingRequirementDetail reportReqDetails;
                List<Object> recipientList = new ArrayList();
                if (award.getAwardReportTermItems().isEmpty()) continue;
                List<AwardReportTerm> awardReportTermItems = award.getAwardReportTermItems();
                for (AwardReportTerm awardReportTerm : awardReportTermItems) {
                    if (!reportTracking.getAwardReportTermId().equals(awardReportTerm.getAwardReportTermId())) continue;
                    recipientList = awardReportTerm.getAwardReportTermRecipients();
                }
                if (!recipientList.isEmpty()) {
                    for (AwardReportTermRecipient awardReportTermRecipient : recipientList) {
                        reportReqDetails = ReportingRequirementDetail.Factory.newInstance();
                        if (reportTracking.getAwardReportTermId().equals(awardReportTermRecipient.getAwardReportTerm().getAwardReportTermId())) {
                            reportReqDetails.setRecipientName(awardReportTermRecipient.getRolodex().getFullName());
                            reportReqDetails.setRecipientOrganization(awardReportTermRecipient.getRolodex().getOrganization());
                            reportReqDetails.setContact(awardReportTermRecipient.getContactType().getDescription());
                            reportReqDetails.setAddress(awardReportTermRecipient.getRolodex().getAddressLine1() + awardReportTermRecipient.getRolodex().getAddressLine2() + awardReportTermRecipient.getRolodex().getAddressLine3());
                        }
                        reportReqDetails.setAwardNo(reportTracking.getAwardNumber());
                        if (reportTracking.getLeadUnit() != null) {
                            reportReqDetails.setUnitNo(reportTracking.getLeadUnit().getUnitNumber());
                            reportReqDetails.setUnitName(reportTracking.getLeadUnit().getUnitName());
                        }
                        reportReqDetails.setStatus(reportTracking.getReportStatus().getDescription());
                        if (reportTracking.getDueDate() != null) {
                            reportReqDetails.setDueDate(reportTracking.getDueDate().toString());
                        }
                        reportReqDetails.setCopies(reportTracking.getItemCount());
                        if (reportTracking.getOverdue() != null) {
                            reportReqDetails.setOverdueNo(reportTracking.getOverdue());
                        }
                        if (reportTracking.getActivityDate() != null) {
                            reportReqDetails.setActivityDate(reportTracking.getActivityDate().toString());
                        }
                        reportTracking.refreshReferenceObject("awardReportTermRecipient");
                        if (reportTracking.getComments() != null) {
                            reportReqDetails.setComments(reportTracking.getComments());
                        }
                        if (reportTracking.getPreparerName() != null) {
                            reportReqDetails.setPersonName(reportTracking.getPreparerFullname());
                        }
                        reportReqDetailList.add(reportReqDetails);
                    }
                    continue;
                }
                reportReqDetails = ReportingRequirementDetail.Factory.newInstance();
                reportReqDetails.setAwardNo(reportTracking.getAwardNumber());
                if (reportTracking.getLeadUnit() != null) {
                    reportReqDetails.setUnitNo(reportTracking.getLeadUnit().getUnitNumber());
                    reportReqDetails.setUnitName(reportTracking.getLeadUnit().getUnitName());
                }
                reportReqDetails.setStatus(reportTracking.getReportStatus().getDescription());
                if (reportTracking.getDueDate() != null) {
                    reportReqDetails.setDueDate(reportTracking.getDueDate().toString());
                }
                reportReqDetails.setCopies(reportTracking.getItemCount());
                if (reportTracking.getOverdue() != null) {
                    reportReqDetails.setOverdueNo(reportTracking.getOverdue());
                }
                if (reportTracking.getActivityDate() != null) {
                    reportReqDetails.setActivityDate(reportTracking.getActivityDate().toString());
                }
                reportTracking.refreshReferenceObject("awardReportTermRecipient");
                if (reportTracking.getComments() != null) {
                    reportReqDetails.setComments(reportTracking.getComments());
                }
                if (reportTracking.getPreparerName() != null) {
                    reportReqDetails.setPersonName(reportTracking.getPreparerFullname());
                }
                reportReqDetailList.add(reportReqDetails);
            }
        }
        if (!reportReqDetailList.isEmpty()) {
            reportingRequirement.setReportingReqDetailsArray(reportReqDetailList.toArray(new ReportingRequirementDetail[0]));
        }
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ReportTrackingDao getReportTrackingDao() {
        return this.reportTrackingDao;
    }

    public void setReportTrackingDao(ReportTrackingDao reportTrackingDao) {
        this.reportTrackingDao = reportTrackingDao;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

