/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.nih;

import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.propdev.impl.s2s.nih.NihValidationMapping;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NihValidationMappingRule
extends KcMaintenanceDocumentRuleBase {
    public static final String DOCUMENT_NEW_MAINTAINABLE_OBJECT_RULE_NUMBER = "document.newMaintainableObject.ruleNumber";
    public static final String RULE_NUMBER = "ruleNumber";
    private BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = super.processCustomRouteDocumentBusinessRules(document);
        NihValidationMapping nihValidationMapping = (NihValidationMapping)document.getNewMaintainableObject().getDataObject();
        if (!"Delete".equals(document.getNewMaintainableObject().getMaintenanceAction()) && !"Edit".equals(document.getNewMaintainableObject().getMaintenanceAction())) {
            NihValidationMapping existingMapping;
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put(RULE_NUMBER, nihValidationMapping.getRuleNumber());
            List ruleNumbers = (List)this.getBusinessObjectService().findMatching(NihValidationMapping.class, criteria);
            if (!ruleNumbers.isEmpty() && (existingMapping = (NihValidationMapping)ruleNumbers.get(0)).getRuleNumber().equals(nihValidationMapping.getRuleNumber())) {
                this.getGlobalVariableService().getMessageMap().putError(DOCUMENT_NEW_MAINTAINABLE_OBJECT_RULE_NUMBER, "error.unique.nih.validation.mapping", new String[]{""});
                valid = Boolean.FALSE;
            }
        }
        return valid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

