/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;

public interface S2SBudgetInfoService {

    /**
     * This method does the budget related calculations for a given {@link ProposalDevelopmentDocumentContract} and returns them in
     * {@link S2SBudgetDto}
     *
     * @param pdDoc ProposalDevelopmentDocumentContract.
     * @return S2SBudgetDto corresponding to the ProposalDevelopmentDocumentContract object.
     */
    S2SBudgetDto getBudgetInfo(ProposalDevelopmentDocumentContract pdDoc);
}
