/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public final class S2SBudgetPeriodDto {

    private int budgetPeriod;
    private Date startDate;
    private Date endDate;
    private List<S2SKeyPersonDto> keyPersons;
    private List<S2SKeyPersonDto> extraKeyPersons;
    private ScaleTwoDecimal totalFundsKeyPersons;
    private ScaleTwoDecimal totalFundsAttachedKeyPersons;
    private List<S2SOtherPersonnelDto> otherPersonnel;
    private ScaleTwoDecimal totalOtherPersonnelFunds;
    private ScaleTwoDecimal otherPersonnelTotalNumber;
    private ScaleTwoDecimal totalCompensation;
    private List<S2SEquipmentDto> equipment;
    private List<S2SEquipmentDto> extraEquipment;
    private ScaleTwoDecimal totalFundsEquipment;
    private ScaleTwoDecimal totalFundsAttachedEquipment;
    private ScaleTwoDecimal domesticTravelCost;
    private ScaleTwoDecimal foreignTravelCost;
    private ScaleTwoDecimal totalTravelCost;
    private ScaleTwoDecimal partStipendCost;
    private ScaleTwoDecimal partTravelCost;
    private ScaleTwoDecimal partOtherCost;
    private ScaleTwoDecimal partTuition;
    private ScaleTwoDecimal partSubsistence;
    private int participantCount;
    private List<S2SOtherDirectCostInfoDto> otherDirectCosts;
    private ScaleTwoDecimal directCostsTotal;
    private S2SIndirectCostDto indirectCosts;
    private String cognizantFedAgency;
    private ScaleTwoDecimal totalCosts;
    private ScaleTwoDecimal totalIndirectCost;
    private int lineItemCount;
    private List<S2SProjectIncomeDto> projectIncomes;
    private String projectIncomesSummary;

    private ScaleTwoDecimal costSharingAmount;
    private ScaleTwoDecimal domesticTravelCostSharing;
    private ScaleTwoDecimal foreignTravelCostSharing;
    private ScaleTwoDecimal totalTravelCostSharing;
    private ScaleTwoDecimal partStipendCostSharing;
    private ScaleTwoDecimal partTravelCostSharing;
    private ScaleTwoDecimal partTuitionCostSharing;
    private ScaleTwoDecimal partSubsistenceCostSharing;
    private ScaleTwoDecimal partOtherCostSharing;
    private ScaleTwoDecimal totalNonFundsKeyPersons;
    private ScaleTwoDecimal totalNonFundsAttachedKeyPersons;
    private ScaleTwoDecimal totalOtherPersonnelNonFunds;
    private ScaleTwoDecimal totalCompensationCostSharing;
    private ScaleTwoDecimal totalDirectCostSharing;
    private ScaleTwoDecimal totalIndirectCostSharing;
    private ScaleTwoDecimal totalProjectIncome;

    public S2SBudgetPeriodDto() {
        keyPersons = new ArrayList<>();
        extraKeyPersons = new ArrayList<>();
        equipment = new ArrayList<>();
        extraEquipment = new ArrayList<>();
        otherDirectCosts = new ArrayList<>();
        projectIncomes = new ArrayList<>();
    }

    public int getBudgetPeriod() {
        return budgetPeriod;
    }

    public void setBudgetPeriod(int budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<S2SKeyPersonDto> getKeyPersons() {
        return keyPersons;
    }

    public void setKeyPersons(List<S2SKeyPersonDto> keyPersons) {
        this.keyPersons = keyPersons;
    }

    public List<S2SKeyPersonDto> getExtraKeyPersons() {
        return extraKeyPersons;
    }

    public void setExtraKeyPersons(List<S2SKeyPersonDto> extraKeyPersons) {
        this.extraKeyPersons = extraKeyPersons;
    }

    public ScaleTwoDecimal getTotalFundsKeyPersons() {
        return totalFundsKeyPersons;
    }

    public void setTotalFundsKeyPersons(ScaleTwoDecimal totalFundsKeyPersons) {
        this.totalFundsKeyPersons = totalFundsKeyPersons;
    }

    public ScaleTwoDecimal getTotalFundsAttachedKeyPersons() {
        return totalFundsAttachedKeyPersons;
    }

    public void setTotalFundsAttachedKeyPersons(ScaleTwoDecimal totalFundsAttachedKeyPersons) {
        this.totalFundsAttachedKeyPersons = totalFundsAttachedKeyPersons;
    }

    public ScaleTwoDecimal getTotalOtherPersonnelFunds() {
        return totalOtherPersonnelFunds;
    }

    public void setTotalOtherPersonnelFunds(ScaleTwoDecimal totalOtherPersonnelFunds) {
        this.totalOtherPersonnelFunds = totalOtherPersonnelFunds;
    }

    public ScaleTwoDecimal getOtherPersonnelTotalNumber() {
        return otherPersonnelTotalNumber;
    }

    public void setOtherPersonnelTotalNumber(ScaleTwoDecimal otherPersonnelTotalNumber) {
        this.otherPersonnelTotalNumber = otherPersonnelTotalNumber;
    }

    public List<S2SOtherPersonnelDto> getOtherPersonnel() {
        return otherPersonnel;
    }

    public void setOtherPersonnel(List<S2SOtherPersonnelDto> otherPersonnel) {
        this.otherPersonnel = otherPersonnel;
    }

    public ScaleTwoDecimal getTotalCompensation() {
        return totalCompensation;
    }

    public void setTotalCompensation(ScaleTwoDecimal totalCompensation) {
        this.totalCompensation = totalCompensation;
    }

    public List<S2SEquipmentDto> getEquipment() {
        return equipment;
    }

    public void setEquipment(List<S2SEquipmentDto> equipment) {
        this.equipment = equipment;
    }

    public List<S2SEquipmentDto> getExtraEquipment() {
        return extraEquipment;
    }

    public void setExtraEquipment(List<S2SEquipmentDto> extraEquipment) {
        this.extraEquipment = extraEquipment;
    }

    public ScaleTwoDecimal getDomesticTravelCost() {
        return domesticTravelCost;
    }

    public void setDomesticTravelCost(ScaleTwoDecimal domesticTravelCost) {
        this.domesticTravelCost = domesticTravelCost;
    }

    public ScaleTwoDecimal getForeignTravelCost() {
        return foreignTravelCost;
    }

    public void setForeignTravelCost(ScaleTwoDecimal foreignTravelCost) {
        this.foreignTravelCost = foreignTravelCost;
    }

    public ScaleTwoDecimal getTotalTravelCost() {
        return totalTravelCost;
    }

    public void setTotalTravelCost(ScaleTwoDecimal totalTravelCost) {
        this.totalTravelCost = totalTravelCost;
    }

    public ScaleTwoDecimal getPartOtherCost() {
        return partOtherCost;
    }

    public void setPartOtherCost(ScaleTwoDecimal partOtherCost) {
        this.partOtherCost = partOtherCost;
    }

    public int getParticipantCount() {
        return participantCount;
    }

    public void setParticipantCount(int participantCount) {
        this.participantCount = participantCount;
    }

    public ScaleTwoDecimal getPartTravelCost() {
        return partTravelCost;
    }

    public void setPartTravelCost(ScaleTwoDecimal partTravelCost) {
        this.partTravelCost = partTravelCost;
    }

    public ScaleTwoDecimal getPartStipendCost() {
        return partStipendCost;
    }

    public void setPartStipendCost(ScaleTwoDecimal partStipendCost) {
        this.partStipendCost = partStipendCost;
    }

    public List<S2SOtherDirectCostInfoDto> getOtherDirectCosts() {
        return otherDirectCosts;
    }

    public void setOtherDirectCosts(List<S2SOtherDirectCostInfoDto> otherDirectCosts) {
        this.otherDirectCosts = otherDirectCosts;
    }

    public ScaleTwoDecimal getDirectCostsTotal() {
        return directCostsTotal;
    }

    public void setDirectCostsTotal(ScaleTwoDecimal directCostsTotal) {
        this.directCostsTotal = directCostsTotal;
    }

    public S2SIndirectCostDto getIndirectCosts() {
        return indirectCosts;
    }

    public void setIndirectCosts(S2SIndirectCostDto indirectCosts) {
        this.indirectCosts = indirectCosts;
    }

    public String getCognizantFedAgency() {
        return cognizantFedAgency;
    }

    public void setCognizantFedAgency(String cognizantFedAgency) {
        this.cognizantFedAgency = cognizantFedAgency;
    }

    public ScaleTwoDecimal getTotalCosts() {
        return totalCosts;
    }

    public void setTotalCosts(ScaleTwoDecimal totalCosts) {
        this.totalCosts = totalCosts;
    }

    public ScaleTwoDecimal getCostSharingAmount() {
        return costSharingAmount==null? ScaleTwoDecimal.ZERO:costSharingAmount;
    }

    public void setCostSharingAmount(ScaleTwoDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    public ScaleTwoDecimal getDomesticTravelCostSharing() {
        return domesticTravelCostSharing==null? ScaleTwoDecimal.ZERO:domesticTravelCostSharing;
    }

    public void setDomesticTravelCostSharing(ScaleTwoDecimal domesticTravelCostSharing) {
        this.domesticTravelCostSharing = domesticTravelCostSharing;
    }

    public ScaleTwoDecimal getForeignTravelCostSharing() {
        return foreignTravelCostSharing==null? ScaleTwoDecimal.ZERO:foreignTravelCostSharing;
    }

    public void setForeignTravelCostSharing(ScaleTwoDecimal foreignTravelCostSharing) {
        this.foreignTravelCostSharing = foreignTravelCostSharing;
    }

    public ScaleTwoDecimal getTotalTravelCostSharing() {
        return totalTravelCostSharing==null? ScaleTwoDecimal.ZERO:totalTravelCostSharing;
    }

    public void setTotalTravelCostSharing(ScaleTwoDecimal totalTravelCostSharing) {
        this.totalTravelCostSharing = totalTravelCostSharing;
    }

    public ScaleTwoDecimal getPartStipendCostSharing() {
        return partStipendCostSharing==null? ScaleTwoDecimal.ZERO:partStipendCostSharing;
    }

    public void setPartStipendCostSharing(ScaleTwoDecimal partStipendCostSharing) {
        this.partStipendCostSharing = partStipendCostSharing;
    }

    public ScaleTwoDecimal getPartTravelCostSharing() {
        return partTravelCostSharing==null? ScaleTwoDecimal.ZERO:partTravelCostSharing;
    }

    public void setPartTravelCostSharing(ScaleTwoDecimal partTravelCostSharing) {
        this.partTravelCostSharing = partTravelCostSharing;
    }

    public ScaleTwoDecimal getPartOtherCostSharing() {
        return partOtherCostSharing==null? ScaleTwoDecimal.ZERO:partOtherCostSharing;
    }

    public void setPartOtherCostSharing(ScaleTwoDecimal partOtherCostSharing) {
        this.partOtherCostSharing = partOtherCostSharing;
    }

    public ScaleTwoDecimal getTotalNonFundsKeyPersons() {
        return totalNonFundsKeyPersons;
    }

    public void setTotalNonFundsKeyPersons(ScaleTwoDecimal totalNonFundsKeyPersons) {
        this.totalNonFundsKeyPersons = totalNonFundsKeyPersons;
    }

    public ScaleTwoDecimal getTotalNonFundsAttachedKeyPersons() {
        return totalNonFundsAttachedKeyPersons;
    }

    public void setTotalNonFundsAttachedKeyPersons(ScaleTwoDecimal totalNonFundsAttachedKeyPersons) {
        this.totalNonFundsAttachedKeyPersons = totalNonFundsAttachedKeyPersons;
    }

    public ScaleTwoDecimal getTotalOtherPersonnelNonFunds() {
        return totalOtherPersonnelNonFunds;
    }

    public void setTotalOtherPersonnelNonFunds(ScaleTwoDecimal totalOtherPersonnelNonFunds) {
        this.totalOtherPersonnelNonFunds = totalOtherPersonnelNonFunds;
    }

    public ScaleTwoDecimal getTotalCompensationCostSharing() {
        return totalCompensationCostSharing==null? ScaleTwoDecimal.ZERO:totalCompensationCostSharing;
    }

    public void setTotalCompensationCostSharing(ScaleTwoDecimal totalCompensationCostSharing) {
        this.totalCompensationCostSharing = totalCompensationCostSharing;
    }

    public ScaleTwoDecimal getTotalDirectCostSharing() {
        return totalDirectCostSharing==null? ScaleTwoDecimal.ZERO:totalDirectCostSharing;
    }

    public void setTotalDirectCostSharing(ScaleTwoDecimal totalDirectCostSharing) {
        this.totalDirectCostSharing = totalDirectCostSharing;
    }

    public ScaleTwoDecimal getTotalIndirectCostSharing() {
        return totalIndirectCostSharing==null? ScaleTwoDecimal.ZERO:totalIndirectCostSharing;
    }

    public void setTotalIndirectCostSharing(ScaleTwoDecimal totalIndirectCostSharing) {
        this.totalIndirectCostSharing = totalIndirectCostSharing;
    }

    public ScaleTwoDecimal getTotalFundsEquipment() {
        return totalFundsEquipment;
    }

    public void setTotalFundsEquipment(ScaleTwoDecimal totalFundsEquipment) {
        this.totalFundsEquipment = totalFundsEquipment;
    }

    public ScaleTwoDecimal getTotalFundsAttachedEquipment() {
        return totalFundsAttachedEquipment;
    }

    public void setTotalFundsAttachedEquipment(ScaleTwoDecimal totalFundsAttachedEquipment) {
        this.totalFundsAttachedEquipment = totalFundsAttachedEquipment;
    }

    public ScaleTwoDecimal getTotalIndirectCost() {
        return totalIndirectCost;
    }

    public void setTotalIndirectCost(ScaleTwoDecimal totalIndirectCost) {
        this.totalIndirectCost = totalIndirectCost;
    }

    public ScaleTwoDecimal getPartTuition() {
        return partTuition;
    }

    public void setPartTuition(ScaleTwoDecimal partTuition) {
        this.partTuition = partTuition;
    }

    public ScaleTwoDecimal getPartSubsistence() {
        return partSubsistence;
    }

    public void setPartSubsistence(ScaleTwoDecimal partSubsistence) {
        this.partSubsistence = partSubsistence;
    }

    public ScaleTwoDecimal getPartSubsistenceCostSharing() {
        return partSubsistenceCostSharing==null? ScaleTwoDecimal.ZERO:partSubsistenceCostSharing;
    }

    public void setPartSubsistenceCostSharing(ScaleTwoDecimal partSubsistenceCostSharing) {
        this.partSubsistenceCostSharing = partSubsistenceCostSharing;
    }

    public ScaleTwoDecimal getPartTuitionCostSharing() {
        return partTuitionCostSharing==null? ScaleTwoDecimal.ZERO:partTuitionCostSharing;
    }

    public void setPartTuitionCostSharing(ScaleTwoDecimal partTuitionCostSharing) {
        this.partTuitionCostSharing = partTuitionCostSharing;
    }

    public int getLineItemCount() {
        return lineItemCount;
    }

    public void setLineItemCount(int lineItemCount) {
        this.lineItemCount = lineItemCount;
    }

    public List<S2SProjectIncomeDto> getProjectIncomes() {
        return projectIncomes;
    }

    public void setProjectIncomes(List<S2SProjectIncomeDto> projectIncomes) {
        this.projectIncomes = projectIncomes;
    }

    public ScaleTwoDecimal getTotalProjectIncome() {
        return totalProjectIncome;
    }

    public void setTotalProjectIncome(ScaleTwoDecimal totalProjectIncome) {
        this.totalProjectIncome = totalProjectIncome;
    }

    public String getProjectIncomesSummary() {
        return projectIncomesSummary;
    }

    public void setProjectIncomesSummary(String projectIncomesSummary) {
        this.projectIncomesSummary = projectIncomesSummary;
    }
}
