/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

public final class S2SIndirectCostDetailsDto {

    private String costType;
    private ScaleTwoDecimal rate;
    private ScaleTwoDecimal base;
    private ScaleTwoDecimal funds;
    private ScaleTwoDecimal baseCostSharing;
    private ScaleTwoDecimal costSharing;

    public String getCostType() {
        return costType;
    }

    public void setCostType(String costType) {
        this.costType = costType;
    }

    public ScaleTwoDecimal getRate() {
        return rate;
    }

    public void setRate(ScaleTwoDecimal rate) {
        this.rate = rate;
    }

    public ScaleTwoDecimal getBase() {
        return base;
    }

    public void setBase(ScaleTwoDecimal base) {
        this.base = base;
    }

    public ScaleTwoDecimal getFunds() {
        return funds;
    }

    public void setFunds(ScaleTwoDecimal funds) {
        this.funds = funds;
    }

    public ScaleTwoDecimal getBaseCostSharing() {
        return baseCostSharing==null? ScaleTwoDecimal.ZERO:baseCostSharing;
    }

    public void setBaseCostSharing(ScaleTwoDecimal baseCostSharing) {
        this.baseCostSharing = baseCostSharing;
    }

    public ScaleTwoDecimal getCostSharing() {
        return costSharing==null? ScaleTwoDecimal.ZERO:costSharing;
    }

    public void setCostSharing(ScaleTwoDecimal costSharing) {
        this.costSharing = costSharing;
    }
}
