/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

public final class S2SKeyPersonDto {

    private String personId;
    private Integer rolodexId;
    private String lastName;
    private String firstName;
    private String middleName;
    private String role;
    private String keyPersonRole;
    private boolean tbn;
    private String tbnName;
    private S2SCompensationDto compensation = new S2SCompensationDto();

    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getKeyPersonRole() {
        return keyPersonRole;
    }

    public void setKeyPersonRole(String keyPersonRole) {
        this.keyPersonRole = keyPersonRole;
    }

    public boolean isTbn() {
        return this.tbn;
    }

    public void setTbn(boolean tbn) {
        this.tbn = tbn;
    }

    public String getTbnName() {
        return tbnName;
    }

    public void setTbnName(String tbnName) {
        this.tbnName = tbnName;
    }

    public Integer getRolodexId() {
        return rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public S2SCompensationDto getCompensation() {
        return compensation;
    }

    public void setCompensation(S2SCompensationDto compensation) {
        this.compensation = compensation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        S2SKeyPersonDto that = (S2SKeyPersonDto) o;

        if (tbn != that.tbn) return false;
        if (personId != null ? !personId.equals(that.personId) : that.personId != null) return false;
        if (rolodexId != null ? !rolodexId.equals(that.rolodexId) : that.rolodexId != null) return false;
        if (lastName != null ? !lastName.equals(that.lastName) : that.lastName != null) return false;
        if (firstName != null ? !firstName.equals(that.firstName) : that.firstName != null) return false;
        if (middleName != null ? !middleName.equals(that.middleName) : that.middleName != null) return false;
        if (role != null ? !role.equals(that.role) : that.role != null) return false;
        if (keyPersonRole != null ? !keyPersonRole.equals(that.keyPersonRole) : that.keyPersonRole != null) return false;
        return tbnName != null ? tbnName.equals(that.tbnName) : that.tbnName == null;
    }

    @Override
    public int hashCode() {
        int result = personId != null ? personId.hashCode() : 0;
        result = 31 * result + (rolodexId != null ? rolodexId.hashCode() : 0);
        result = 31 * result + (lastName != null ? lastName.hashCode() : 0);
        result = 31 * result + (firstName != null ? firstName.hashCode() : 0);
        result = 31 * result + (middleName != null ? middleName.hashCode() : 0);
        result = 31 * result + (role != null ? role.hashCode() : 0);
        result = 31 * result + (keyPersonRole != null ? keyPersonRole.hashCode() : 0);
        result = 31 * result + (tbn ? 1 : 0);
        result = 31 * result + (tbnName != null ? tbnName.hashCode() : 0);
        return result;
    }
}
