/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.core;

/**
 * This class is for exceptions that occur in the s2s subsystem.
 */
public class S2SException extends RuntimeException {

    public static final String ERROR_S2S_UNKNOWN = "error.s2s.unknown";

    private String errorMessage = "";
    private String errorKey = ERROR_S2S_UNKNOWN;
    private int messageType;
    private String[] params = new String[0];
    private String tabErrorKey;

    public S2SException() {
        super();
    }

    public S2SException(Exception ex) {
        super(ex);
        this.errorMessage = ex.getMessage();
    }

    public S2SException(String message,Exception ex) {
        super(message,ex);
        this.errorMessage = message;
    }

    public S2SException(String msg) {
        super(msg);
        this.errorMessage = msg;
    }

    public S2SException(String errorKey,String msg) {
        super(msg);
        this.errorMessage = msg;
        this.errorKey = errorKey;
    }
    public S2SException(String errorKey,String msg,String... params) {
        super(msg);
        this.errorMessage = msg;
        this.errorKey = errorKey;
        this.params = params;
    }
    public S2SException(String msg, int messageType) {
        super(msg);
        this.errorMessage = msg;
        this.messageType = messageType;
    }

    @Override
    public String getMessage() {
        return errorMessage;
    }

    /**
     * This method returns the message as the first element followed by all params.
     * @return message and parameters in an array.
     */
    public String[] getMessageWithParams() {
        String[] messageWithParams = new String[getParams().length+1];
        messageWithParams[0]=errorMessage;
        System.arraycopy(params, 0, messageWithParams, 1, messageWithParams.length - 1);
        return messageWithParams;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorKey() {
        return errorKey;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public int getMessageType() {
        return messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public String[] getParams() {
        return params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getTabErrorKey() {
        return tabErrorKey;
    }

    public void setTabErrorKey(String tabErrorKey) {
        this.tabErrorKey = tabErrorKey;
    }
}
