/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.generate;

import java.util.Arrays;
import java.util.Objects;

/**
 * 
 * This class is meant to store and retrieve attachments and its associated properties
 */
public class AttachmentData {
    private String fileName;
    private String contentId;
    private byte[] content;
    private String contentType;
    private String hashValue;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String FileName) {
        this.fileName = FileName;
    }

    public String getContentId() {
        return contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public byte[] getContent() {
        return content;
    }

    public void setContent(byte[] Content) {
        this.content = Content;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String ContentType) {
        this.contentType = ContentType;
    }

    public String getHashValue() {
        return hashValue;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AttachmentData that = (AttachmentData) o;
        return Objects.equals(fileName, that.fileName) &&
                Objects.equals(contentId, that.contentId) &&
                Arrays.equals(content, that.content) &&
                Objects.equals(contentType, that.contentType) &&
                Objects.equals(hashValue, that.hashValue);
    }

    @Override
    public int hashCode() {

        int result = Objects.hash(fileName, contentId, contentType, hashValue);
        result = 31 * result + Arrays.hashCode(content);
        return result;
    }
}
