/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.generate;

import org.kuali.coeus.s2sgen.api.core.AuditError;

import java.util.Collections;
import java.util.List;

/**
 * This class holds the result of executing form generation on a proposal document.
 */
public final class FormGenerationResult implements FormGenerationResults {

    private FormGenerationResult(boolean valid, List<AuditError> errors, String applicationXml, List<AttachmentData> attachments) {
        this.valid = valid;
        this.errors = errors;
        this.applicationXml = applicationXml;
        this.attachments = attachments;
    }

    public static FormGenerationResult invalid(List<AuditError> errors) {
        return new FormGenerationResult(false, errors, null, Collections.emptyList());
    }

    public static FormGenerationResult valid(List<AuditError> errors, String applicationXml, List<AttachmentData> attachments) {
        return new FormGenerationResult(true, errors, applicationXml, attachments);
    }

    private final boolean valid;
    private final List<AuditError> errors;
    private final String applicationXml;
    private final List<AttachmentData> attachments;

    @Override
    public String getApplicationXml() {
        return applicationXml;
    }

    @Override
    public List<AttachmentData> getAttachments() {
        return attachments;
    }

    @Override
    public boolean isValid() {
        return valid;
    }

    @Override
    public List<AuditError> getErrors() {
        return errors;
    }
}
