/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.generate;

import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormFileContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;

import java.util.List;

/**
 * 
 * This service allows s2s form generation or form validation.
 */
public interface FormGeneratorService {

    /**
     * This service method executes form generation for a given proposal development document.  The proposal development
     * document cannot be null.  Note that validation is also executed as well.
     *
     * @param pdDoc the proposal development document.  cannot be null.
     * @return the result of the generation.
     * @throws S2SException if unable to validate
     * @throws java.lang.IllegalArgumentException if the pdDoc is null
     */
    FormGenerationResult generateAndValidateForms(ProposalDevelopmentDocumentContract pdDoc) throws S2SException;

    /**
     * This service method executes form generation for a complex project complete structure.  It should be passed both
     * the parent proposal in a hierarchy as well as all children.  Validation is also executed against each form and
     * the entire application xml via GG.
     * @param parent    The parent node in a hierarchy
     * @param children  All children in a hierarchy
     * @return          The validation result, attachments and full application xml
     * @throws S2SException
     */
    MultiProjectFormGenerationResult generateAndValidateMPForms(ProposalDevelopmentDocumentContract parent,
                                                    List<ProposalDevelopmentDocumentContract> children) throws S2SException;

    /**
     * This service method executes form generation for a single component (child) in a complex project.  It should be
     * passed only a single child in a hierarchy.  Validation is executed against each form, but not against the
     * resulting xml.  The returned applicationXml is only valid for an nih validateComponent call.
     * @param child    The component to validate, must be a child node in a hierarchy
     * @return         The validation result, attachments and component xml
     * @throws S2SException
     */
    MultiProjectFormGenerationResult generateAndValidateMPComponentForms(ProposalDevelopmentDocumentContract child,
                                                                         String parentSchemaUrl) throws S2SException;

    /**
     * This service method executes user attach form file validation.  The user attached from form file
     * cannot be null.
     *
     * @param s2sUserAttachedFormFile the user attached form file.  cannot be null.
     * @param formName is the formName. cannot be null.
     * @return the result of the validation
     * @throws S2SException if unable to validate
     * @throws java.lang.IllegalArgumentException if the s2sUserAttachedFormFile is null or if the formName is null.
     */

    FormGenerationResult validateUserAttachedFormFile(S2sUserAttachedFormFileContract s2sUserAttachedFormFile,String formName) throws S2SException;
}
