/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.generate;

import java.util.List;

/**
 * 
 * This class holds information about form generation.  For example: what forms are supported,
 * the name of the generator, the location of the stylesheet.
 */
public class FormMappingInfo {
    private String nameSpace;
    private String generatorName;
    private String formName;
    private List<String> styleSheets;
    private String pdfForm;
    private String pdfFormFillerName;
    private int sortIndex;
    private Boolean userAttachedForm = false;

    private FormMappingInfo(String nameSpace, String generatorName, String formName, List<String> styleSheets, int sortIndex, Boolean userAttachedForm, String pdfForm, String pdfFormFillerName) {
        this.nameSpace = nameSpace;
        this.generatorName = generatorName;
        this.formName = formName;
        this.styleSheets = styleSheets;
        this.sortIndex = sortIndex;
        this.userAttachedForm = userAttachedForm;
        this.pdfForm = pdfForm;
        this.pdfFormFillerName = pdfFormFillerName;
    }

    public static FormMappingInfo styleSheetBased(String nameSpace, String generatorName, String formName, List<String> styleSheets, int sortIndex, Boolean userAttachedForm) {
        return new FormMappingInfo(nameSpace, generatorName, formName, styleSheets, sortIndex, userAttachedForm, null, null);
    }

    public static FormMappingInfo pdfFormBased(String nameSpace, String generatorName, String formName, String pdfForm, String pdfFormFillerName, int sortIndex, Boolean userAttachedForm) {
        return new FormMappingInfo(nameSpace, generatorName, formName, null, sortIndex, userAttachedForm, pdfForm, pdfFormFillerName);
    }

    public String getGeneratorName() {
        return generatorName;
    }

    public void setGeneratorName(String generatorName) {
        this.generatorName = generatorName;
    }

    public String getNameSpace() {
        return nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public List<String> getStyleSheets() {
        return styleSheets;
    }

    public void setStyleSheets(List<String> styleSheets) {
        this.styleSheets = styleSheets;
    }

    public String getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(String pdfForm) {
        this.pdfForm = pdfForm;
    }

    public String getPdfFormFillerName() {
        return pdfFormFillerName;
    }

    public void setPdfFormFillerName(String pdfFormFillerName) {
        this.pdfFormFillerName = pdfFormFillerName;
    }

    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public Boolean getUserAttachedForm() {
        return userAttachedForm;
    }

    public void setUserAttachedForm(Boolean userAttachedForm) {
        this.userAttachedForm = userAttachedForm;
    }

    @Override
    public String toString() {
        return "FormMappingInfo{" +
                "nameSpace='" + nameSpace + '\'' +
                ", generatorName='" + generatorName + '\'' +
                ", formName='" + formName + '\'' +
                ", styleSheet='" + styleSheets + '\'' +
                ", pdfForm='" + pdfForm + '\'' +
                ", pdfFormFillerName='" + pdfFormFillerName + '\'' +
                ", sortIndex=" + sortIndex +
                ", userAttachedForm=" + userAttachedForm +
                '}';
    }
}
