/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.hash;

/**
 * Service to compute hashes for s2s.
 */
public interface GrantApplicationHashService {

    /**
     * Computes a hash for a grant application in string form.  xml cannot be blank.
     * @param xml the grant application xml.  cannot be blank
     * @return the hash
     */
    String computeGrantFormsHash(String xml);

    /**
     * Computes a hash for an attachment in byte array form.  attachment cannot be null or empty.
     * @param attachment the attachment.  cannot be null or empty
     * @return the hash
     */
    String computeAttachmentHash(byte[] attachment);
}
