/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.print;

import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;

/**
 *
 * This service allows s2s forms to be retrieved in pdf form.
 */
public interface FormPrintService {

    /**
     * This service method executes form generation and validation where the result is a pdf document in binary form and
     * any errors that were generated during this process. This happens for a given proposal development document.
     * The proposal development document cannot be null.
     *
     * @param pdDoc the proposal development document.  cannot be null.
     * @return the result of the pdf generation
     * @throws S2SException if unable to generate the pdf
     * @throws java.lang.IllegalArgumentException if the pdDoc is null
     */
    FormPrintResult printForm(ProposalDevelopmentDocumentContract pdDoc) throws S2SException;
}
