/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

import java.util.ArrayList;
import java.util.List;

public final class S2SEquipmentDto {

    private List<S2SCostDto> equipmentList;
    private ScaleTwoDecimal totalFund;
    private List<S2SCostDto> extraEquipmentList;
    private ScaleTwoDecimal totalExtraFund = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal totalNonFund = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal totalExtraNonFund = ScaleTwoDecimal.ZERO;

    public S2SEquipmentDto() {
        equipmentList = new ArrayList<>();
        extraEquipmentList = new ArrayList<>();
    }

    public List<S2SCostDto> getEquipmentList() {
        return equipmentList;
    }

    public void setEquipmentList(List<S2SCostDto> equipmentList) {
        this.equipmentList = equipmentList;
    }

    public ScaleTwoDecimal getTotalFund() {
        return totalFund;
    }

    public void setTotalFund(ScaleTwoDecimal totalFund) {
        this.totalFund = totalFund;
    }


    public List<S2SCostDto> getExtraEquipmentList() {
        return extraEquipmentList;
    }

    public void setExtraEquipmentList(List<S2SCostDto> extraEquipmentList) {
        this.extraEquipmentList = extraEquipmentList;
    }

    public ScaleTwoDecimal getTotalExtraFund() {
        return totalExtraFund;
    }

    public void setTotalExtraFund(ScaleTwoDecimal totalExtraFund) {
        this.totalExtraFund = totalExtraFund;
    }

    public ScaleTwoDecimal getTotalNonFund() {
        return totalNonFund;
    }

    public void setTotalNonFund(ScaleTwoDecimal totalNonFund) {
        this.totalNonFund = totalNonFund;
    }

    public ScaleTwoDecimal getTotalExtraNonFund() {
        return totalExtraNonFund;
    }

    public void setTotalExtraNonFund(ScaleTwoDecimal totalExtraNonFund) {
        this.totalExtraNonFund = totalExtraNonFund;
    }
}
