/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.api.generate;

import org.kuali.coeus.s2sgen.api.core.AuditError;

import java.util.*;
import java.util.stream.Collectors;

public class MultiProjectFormGenerationResult implements FormGenerationResults {
    private final boolean valid;
    private final String applicationXml;
    private final Map<String, List<AuditError>> auditErrors;
    private final Map<String, List<AttachmentData>> attachments;

    private MultiProjectFormGenerationResult(boolean valid, Map<String, List<AuditError>> errors, String applicationXml,
                                             Map<String, List<AttachmentData>> attachments) {
        this.valid = valid;
        this.applicationXml = applicationXml;
        this.auditErrors = errors;
        this.attachments = attachments;
    }

    public static MultiProjectFormGenerationResult invalid(Map<String, List<AuditError>> errors) {
        return new MultiProjectFormGenerationResult(false, errors, null, Collections.emptyMap());
    }

    public static MultiProjectFormGenerationResult valid(Map<String, List<AuditError>> errors, String applicationXml,
                                                         Map<String, List<AttachmentData>> attachments) {
        return new MultiProjectFormGenerationResult(true, errors, applicationXml, attachments);
    }

    @Override
    public boolean isValid() {
        return valid;
    }

    @Override
    public String getApplicationXml() {
        return applicationXml;
    }

    @Override
    public List<AuditError> getErrors() {
        return auditErrors.entrySet().stream()
                .map(Map.Entry::getValue)
                .flatMap(Collection::stream)
                .collect(Collectors.toList());
    }

    public Optional<List<AuditError>> getProposalErrors(String proposalNumber) {
        return Optional.ofNullable(auditErrors.get(proposalNumber));
    }

    @Override
    public List<AttachmentData> getAttachments() {
        return attachments.entrySet().stream()
                .map(Map.Entry::getValue)
                .flatMap(Collection::stream)
                .collect(Collectors.toList());
    }

    public Optional<List<AttachmentData>> getProposalAttachments(String proposalNumber) {
        return Optional.ofNullable(attachments.get(proposalNumber));
    }
}
