/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.budget;

import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapService;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMappingContract;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import java.util.*;

@Component("s2SBudgetCategoryMapService")
public class S2SBudgetCategoryMapServiceImpl implements S2SBudgetCategoryMapService {

    private static final String SPONSOR = "S2S";

    @Autowired
    @Qualifier("budgetCategoryMapService")
    private BudgetCategoryMapService budgetCategoryMapService;

    @Override
    public List<? extends BudgetCategoryMapContract> getBudgetCategoryMapList(List<String> filterTargetCategoryCodes, List<String> filterCategoryTypes) {
        List<? extends BudgetCategoryMappingContract> budgetCategoryMappingList;
        List<BudgetCategoryMapContract> budgetCategoryMapList = new ArrayList<>();
        budgetCategoryMappingList = budgetCategoryMapService.findCatMappingByMappingName(SPONSOR);

        boolean targetMatched;
        boolean duplicateExists;
        for (BudgetCategoryMappingContract categoryMapping : budgetCategoryMappingList) {
            targetMatched = true;
            // Apply mapping list filtering only if targetCategoryCodes size>0
            if (filterTargetCategoryCodes.size() > 0) {
                for (String targetCategoryCode : filterTargetCategoryCodes) {
                    if (categoryMapping.getTargetCategoryCode().equals(targetCategoryCode)) {
                        targetMatched = false;
                        break;
                    }
                }
            }

            if (targetMatched) {

                for (BudgetCategoryMapContract filterMap : budgetCategoryMapService.findCatMapByTargetAndMappingName(
                        categoryMapping.getTargetCategoryCode(), categoryMapping.getMappingName())) {
                    targetMatched = true;
                    if (filterCategoryTypes.size() > 0) {
                        for (String categoryType : filterCategoryTypes) {
                            if (filterMap.getCategoryType().trim().equals(categoryType.trim())) {
                                targetMatched = false;
                                break;
                            }
                        }
                    }

                    if (targetMatched) {
                        // Avoid adding duplicates to list
                        duplicateExists = false;
                        for (BudgetCategoryMapContract map : budgetCategoryMapList) {
                            if (filterMap.getTargetCategoryCode().equals(map.getTargetCategoryCode())) {
                                duplicateExists = true;
                                break;
                            }
                        }
                        if (!duplicateExists) {
                            budgetCategoryMapList.add(filterMap);
                        }
                    }
                }
            }
        }
        return budgetCategoryMapList;
    }

    public void setBudgetCategoryMapService(BudgetCategoryMapService budgetCategoryMapService) {
        this.budgetCategoryMapService = budgetCategoryMapService;
    }

    public BudgetCategoryMapService getBudgetCategoryMapService() {
        return budgetCategoryMapService;
    }


}
