/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398ResearchTrainingProgramPlanV10.PHS398ResearchTrainingProgramPlanDocument;
import gov.grants.apply.forms.phs398ResearchTrainingProgramPlanV10.PHS398ResearchTrainingProgramPlanDocument.PHS398ResearchTrainingProgramPlan;
import gov.grants.apply.forms.phs398ResearchTrainingProgramPlanV10.PHS398ResearchTrainingProgramPlanDocument.PHS398ResearchTrainingProgramPlan.ApplicationType;
import gov.grants.apply.forms.phs398ResearchTrainingProgramPlanV10.PHS398ResearchTrainingProgramPlanDocument.PHS398ResearchTrainingProgramPlan.ResearchTrainingProgramPlanAttachments;
import gov.grants.apply.forms.phs398ResearchTrainingProgramPlanV10.PHS398ResearchTrainingProgramPlanDocument.PHS398ResearchTrainingProgramPlan.ResearchTrainingProgramPlanAttachments.*;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.api.core.ConfigurationConstants;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.ArrayList;
import java.util.List;

@FormGenerator("PHS398ResTrainProgPlanV1_0Generator")
public class PHS398ResTrainProgPlanV1_0Generator extends S2SBaseFormGenerator<PHS398ResearchTrainingProgramPlanDocument> {
    private static final int PHS_RES_TRAINING_PLAN_INTRODUCTION_112 = 112;
    private static final int PHS_RES_TRAINING_PLAN_BACKGROUND_113 = 113;
    private static final int PHS_RES_TRAINING_PLAN_PROGRAM_PLAN_114 = 114;
    private static final int PHS_RES_TRAINING_PLAN_RECRUITMENT_PLAN_115 = 115;
    private static final int PHS_RES_TRAINING_PLAN_RESP_CONDUCT_SEARCH_116 = 116;
    private static final int PHS_RES_TRAINING_PLAN_PROGRESS_REPORT_117 = 117;
    private static final int PHS_RES_TRAINING_PLAN_HUMAN_SUBJECTS_118 = 118;
    private static final int PHS_RES_TRAINING_PLAN_SELECT_AGENT_SEARCH_120 = 120;
    private static final int PHS_RES_TRAINING_PLAN_VERT_ANIMALS_119 = 119;
    private static final int PHS_RES_TRAINING_PLAN_PI_LEADERSHIP_PLAN_121 = 121;
    private static final int PHS_RES_TRAINING_PLAN_CONS_CONTRACTUAL_122 = 122;
    private static final int PHS_RES_TRAINING_PLAN_FAC_BIOSKETCHES_123 = 123;
    private static final int PHS_RES_TRAINING_PLAN_DATA_TABLES_124 = 124;
    private static final int PHS_RES_TRAINING_PLAN_SUPPORT_LETTERS_125 = 125;
    private static final int PHS_RES_TRAINING_PLAN_APPENDIX_126 = 126;

    @Autowired
    @Qualifier("s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

    @Value("http://apply.grants.gov/forms/PHS398_ResearchTrainingProgramPlan-V1.0")
    private String namespace;

    @Value("PHS398_ResearchTrainingProgramPlan-V1.0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_ResearchTrainProPlan_V1.0.xsl")
    private List<Resource> stylesheets;

    @Value("187")
    private int sortIndex;

    private PHS398ResearchTrainingProgramPlan getPHS398ResearchTrainingProgramPlan(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        DevelopmentProposalContract developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        PHS398ResearchTrainingProgramPlan phs398ResTrainProgPlan = PHS398ResearchTrainingProgramPlan.Factory.newInstance();

        ResearchTrainingProgramPlanAttachments researchTrainingProgramPlanAttachments = ResearchTrainingProgramPlanAttachments.Factory.newInstance();

        phs398ResTrainProgPlan.setFormVersion(FormVersion.v1_0.getVersion());
        ApplicationType appType = phs398ResTrainProgPlan.addNewApplicationType();
        appType.setTypeOfApplication(getTypeOfApplication(developmentProposal.getProposalType().getCode()));
        List<AttachedFileDataType> attachedFileDataTypes = new ArrayList<>();

        AttachedFileDataType attachedFileDataType;
        for (NarrativeContract narrative : developmentProposal.getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                    case (PHS_RES_TRAINING_PLAN_INTRODUCTION_112):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            IntroductionToApplication introductionToApplication = researchTrainingProgramPlanAttachments.addNewIntroductionToApplication();
                            introductionToApplication.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_BACKGROUND_113):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            Background backGround = researchTrainingProgramPlanAttachments.addNewBackground();
                            backGround.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_PROGRAM_PLAN_114):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ProgramPlan programPlan = researchTrainingProgramPlanAttachments.addNewProgramPlan();
                            programPlan.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_RECRUITMENT_PLAN_115):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            RecruitmentAndRetentionPlanToEnhanceDiversity recruitmentAndRetentionPlanToEnhanceDiversity = researchTrainingProgramPlanAttachments.addNewRecruitmentAndRetentionPlanToEnhanceDiversity();
                            recruitmentAndRetentionPlanToEnhanceDiversity.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_RESP_CONDUCT_SEARCH_116):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ResponsibleConductOfResearch responsibleConductOfResearch = researchTrainingProgramPlanAttachments.addNewResponsibleConductOfResearch();
                            responsibleConductOfResearch.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_PROGRESS_REPORT_117):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ProgressReport progressReport = researchTrainingProgramPlanAttachments.addNewProgressReport();
                            progressReport.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_HUMAN_SUBJECTS_118):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            HumanSubjects humanSubjects = researchTrainingProgramPlanAttachments.addNewHumanSubjects();
                            humanSubjects.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_SELECT_AGENT_SEARCH_120):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            SelectAgentResearch selectAgentResearch = researchTrainingProgramPlanAttachments.addNewSelectAgentResearch();
                            selectAgentResearch.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_VERT_ANIMALS_119):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            VertebrateAnimals vertebrateAnimals = researchTrainingProgramPlanAttachments.addNewVertebrateAnimals();
                            vertebrateAnimals.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_PI_LEADERSHIP_PLAN_121):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            MultiplePDPILeadershipPlan multiplePDPILeadershipPlan = researchTrainingProgramPlanAttachments.addNewMultiplePDPILeadershipPlan();
                            multiplePDPILeadershipPlan.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_CONS_CONTRACTUAL_122):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ConsortiumContractualArrangements consortiumContractualArrangements = researchTrainingProgramPlanAttachments.addNewConsortiumContractualArrangements();
                            consortiumContractualArrangements.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_FAC_BIOSKETCHES_123):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            ParticipatingFacultyBiosketches participatingFacultyBiosketches = researchTrainingProgramPlanAttachments.addNewParticipatingFacultyBiosketches();
                            participatingFacultyBiosketches.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_DATA_TABLES_124):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            DataTables dataTables = researchTrainingProgramPlanAttachments.addNewDataTables();
                            dataTables.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_SUPPORT_LETTERS_125):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            LettersOfSupport lettersOfSupport = researchTrainingProgramPlanAttachments.addNewLettersOfSupport();
                            lettersOfSupport.setAttFile(attachedFileDataType);
                        }
                        break;
                    case (PHS_RES_TRAINING_PLAN_APPENDIX_126):
                        attachedFileDataType = addAttachedFileType(narrative);
                        if (attachedFileDataType != null) {
                            attachedFileDataTypes.add(attachedFileDataType);
                        }
                        break;
                }
            }
        }
        if (!attachedFileDataTypes.isEmpty()) {
            AttachmentGroupMin0Max100DataType attachmentGroup = researchTrainingProgramPlanAttachments.addNewAppendix();
            attachmentGroup.setAttachedFileArray(attachedFileDataTypes.toArray(new AttachedFileDataType[0]));
        }

        if (researchTrainingProgramPlanAttachments != null)
            phs398ResTrainProgPlan.setResearchTrainingProgramPlanAttachments(researchTrainingProgramPlanAttachments);

        return phs398ResTrainProgPlan;

    }

    private gov.grants.apply.forms.phs398ResearchTrainingProgramPlanV10.PHS398ResearchTrainingProgramPlanDocument.PHS398ResearchTrainingProgramPlan.ApplicationType.TypeOfApplication.Enum getTypeOfApplication(String proposalTypeCode) {
        gov.grants.apply.forms.phs398ResearchTrainingProgramPlanV10.PHS398ResearchTrainingProgramPlanDocument.PHS398ResearchTrainingProgramPlan.ApplicationType.TypeOfApplication.Enum proposalTypeEnum = null;
        if (s2SConfigurationService.getValuesFromCommaSeparatedParam(ConfigurationConstants.PROPOSAL_TYPE_CODE_RENEWAL).contains(proposalTypeCode)) {
            proposalTypeEnum = ApplicationType.TypeOfApplication.RENEWAL;
        } else if (s2SConfigurationService.getValuesFromCommaSeparatedParam(ConfigurationConstants.PROPOSAL_TYPE_CODE_REVISION).contains(proposalTypeCode)) {
            proposalTypeEnum = ApplicationType.TypeOfApplication.REVISION;
        } else if (s2SConfigurationService.getValuesFromCommaSeparatedParam(ConfigurationConstants.PROPOSAL_TYPE_CODE_CONTINUATION).contains(proposalTypeCode)) {
            proposalTypeEnum = ApplicationType.TypeOfApplication.CONTINUATION;
        } else if (s2SConfigurationService.getValuesFromCommaSeparatedParam(ConfigurationConstants.PROPOSAL_TYPE_CODE_NEW).contains(proposalTypeCode)) {
            proposalTypeEnum = ApplicationType.TypeOfApplication.NEW;
        } else if (s2SConfigurationService.getValuesFromCommaSeparatedParam(ConfigurationConstants.PROPOSAL_TYPE_CODE_RESUBMISSION).contains(proposalTypeCode)) {
            proposalTypeEnum = ApplicationType.TypeOfApplication.RESUBMISSION;
        }
        return proposalTypeEnum;
    }

    @Override
    public PHS398ResearchTrainingProgramPlanDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        PHS398ResearchTrainingProgramPlan phs398ResearchTrainingProgramPlan = getPHS398ResearchTrainingProgramPlan(proposalDevelopmentDocument);
        PHS398ResearchTrainingProgramPlanDocument phs398ResearchTrainingProgramPlanDocument = PHS398ResearchTrainingProgramPlanDocument.Factory.newInstance();
        phs398ResearchTrainingProgramPlanDocument.setPHS398ResearchTrainingProgramPlan(phs398ResearchTrainingProgramPlan);
        return phs398ResearchTrainingProgramPlanDocument;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHS398ResearchTrainingProgramPlanDocument> factory() {
        return PHS398ResearchTrainingProgramPlanDocument.Factory;
    }
}
