/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398ResearchPlan40V40.PHS398ResearchPlan40Document;
import gov.grants.apply.forms.phs398ResearchPlan40V40.PHS398ResearchPlan40Document.PHS398ResearchPlan40;
import gov.grants.apply.forms.phs398ResearchPlan40V40.PHS398ResearchPlan40Document.PHS398ResearchPlan40.ResearchPlanAttachments;
import gov.grants.apply.forms.phs398ResearchPlan40V40.PHS398ResearchPlan40Document.PHS398ResearchPlan40.ResearchPlanAttachments.*;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

@FormGenerator("PHS398ResearchPlan_4_0V4_0Generator")
public class PHS398ResearchPlan_4_0V4_0Generator extends
        PHS398ResearchPlanBaseGenerator<PHS398ResearchPlan40Document> implements S2SFormGeneratorPdfFillable<PHS398ResearchPlan40Document> {

    private static final int KEY_BIO_CHEMICAL_RESOURCES = 150;
    @Value("http://apply.grants.gov/forms/PHS398_ResearchPlan_4_0-V4.0")
    private String namespace;

    @Value("PHS398_ResearchPlan_4_0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_ResearchPlan-V4.0.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_ResearchPlan_4_0-V4.0.pdf")
    private Resource pdfForm;

    @Value("195")
    private int sortIndex;


    private PHS398ResearchPlan40Document getPHS398ResearchPlan() {
        PHS398ResearchPlan40Document phsResearchPlanDocument = PHS398ResearchPlan40Document.Factory.newInstance();
        PHS398ResearchPlan40 phsResearchPlan = PHS398ResearchPlan40.Factory.newInstance();
        phsResearchPlan.setFormVersion(FormVersion.v4_0.getVersion());
        ResearchPlanAttachments researchPlanAttachments = ResearchPlanAttachments.Factory.newInstance();
        getNarrativeAttachments(researchPlanAttachments);
        AttachmentGroupMin0Max100DataType attachmentGroupMin0Max100DataType = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachmentGroupMin0Max100DataType.setAttachedFileArray(getAppendixAttachedFileDataTypes());
        researchPlanAttachments.setAppendix(attachmentGroupMin0Max100DataType);
        phsResearchPlan.setResearchPlanAttachments(researchPlanAttachments);
        phsResearchPlanDocument.setPHS398ResearchPlan40(phsResearchPlan);

        return phsResearchPlanDocument;
    }

    private void getNarrativeAttachments(ResearchPlanAttachments researchPlanAttachments) {

        pdDoc.getDevelopmentProposal().getNarratives().forEach(narrative -> {
            switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                case INTRODUCTION_TO_APPLICATION ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            IntroductionToApplication introductionToApplication = IntroductionToApplication.Factory.newInstance();
                            introductionToApplication.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setIntroductionToApplication(introductionToApplication);
                        });

                case SPECIFIC_AIMS ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            SpecificAims specificAims = SpecificAims.Factory.newInstance();
                            specificAims.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setSpecificAims(specificAims);
                        });

                case RESEARCH_STRATEGY ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            ResearchStrategy researchStrategy = ResearchStrategy.Factory.newInstance();
                            researchStrategy.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setResearchStrategy(researchStrategy);
                        });

                case PROGRESS_REPORT_PUBLICATION_LIST ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            ProgressReportPublicationList progressReportPublicationList = ProgressReportPublicationList.Factory.newInstance();
                            progressReportPublicationList.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setProgressReportPublicationList(progressReportPublicationList);
                        });

                case VERTEBRATE_ANIMALS ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            VertebrateAnimals vertebrateAnimals = VertebrateAnimals.Factory.newInstance();
                            vertebrateAnimals.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setVertebrateAnimals(vertebrateAnimals);
                        });
                case SELECT_AGENT_RESEARCH ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            SelectAgentResearch selectAgentResearch = SelectAgentResearch.Factory.newInstance();
                            selectAgentResearch.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setSelectAgentResearch(selectAgentResearch);
                        });

                case MULTIPLE_PI_LEADERSHIP_PLAN ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            MultiplePDPILeadershipPlan multiplePILeadershipPlan = MultiplePDPILeadershipPlan.Factory.newInstance();
                            multiplePILeadershipPlan.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setMultiplePDPILeadershipPlan(multiplePILeadershipPlan);
                        });

                case CONSORTIUM_CONTRACTUAL_ARRANGEMENTS ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            ConsortiumContractualArrangements contractualArrangements = ConsortiumContractualArrangements.Factory.newInstance();
                            contractualArrangements.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setConsortiumContractualArrangements(contractualArrangements);
                        });

                case LETTERS_OF_SUPPORT ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            LettersOfSupport lettersOfSupport = LettersOfSupport.Factory.newInstance();
                            lettersOfSupport.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setLettersOfSupport(lettersOfSupport);
                        });

                case RESOURCE_SHARING_PLANS ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            ResourceSharingPlans resourceSharingPlans = ResourceSharingPlans.Factory.newInstance();
                            resourceSharingPlans.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setResourceSharingPlans(resourceSharingPlans);
                        });

                case KEY_BIO_CHEMICAL_RESOURCES ->
                        doWithAttachedFileType(narrative, attachedFileDataType -> {
                            KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = KeyBiologicalAndOrChemicalResources.Factory.newInstance();
                            keyBiologicalAndOrChemicalResources.setAttFile(attachedFileDataType);
                            researchPlanAttachments.setKeyBiologicalAndOrChemicalResources(keyBiologicalAndOrChemicalResources);
                        });

            }
        });

        setMandatoryAttachments(researchPlanAttachments);
    }

    private void setMandatoryAttachments(ResearchPlanAttachments researchPlanAttachments) {
        if (researchPlanAttachments.getResearchStrategy() == null) {
            researchPlanAttachments.setResearchStrategy(ResearchStrategy.Factory.newInstance());
        }
    }

    @Override
    public PHS398ResearchPlan40Document getFormObject(
            ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return getPHS398ResearchPlan();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(PHS398ResearchPlan40Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            final ResearchPlanAttachments researchPlanAttachments = form.getPHS398ResearchPlan40().getResearchPlanAttachments();
            if (researchPlanAttachments != null) {
                final ResearchPlanAttachments.IntroductionToApplication introductionToApplication = researchPlanAttachments.getIntroductionToApplication();

                if (introductionToApplication != null && introductionToApplication.getAttFile() != null && a.getContentId().equals(introductionToApplication.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile0", a);
                }

                final ResearchPlanAttachments.SpecificAims specificAims = researchPlanAttachments.getSpecificAims();
                if (specificAims != null && specificAims.getAttFile() != null && a.getContentId().equals(specificAims.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile1", a);
                }

                final ResearchPlanAttachments.ResearchStrategy researchStrategy = researchPlanAttachments.getResearchStrategy();
                if (researchStrategy != null && researchStrategy.getAttFile() != null && a.getContentId().equals(researchStrategy.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile2", a);
                }

                final ResearchPlanAttachments.ProgressReportPublicationList progressReportPublicationList = researchPlanAttachments.getProgressReportPublicationList();
                if (progressReportPublicationList != null && progressReportPublicationList.getAttFile() != null && a.getContentId().equals(progressReportPublicationList.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile3", a);
                }

                final ResearchPlanAttachments.VertebrateAnimals vertebrateAnimals = researchPlanAttachments.getVertebrateAnimals();
                if (vertebrateAnimals != null && vertebrateAnimals.getAttFile() != null && a.getContentId().equals(vertebrateAnimals.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile4", a);
                }

                final ResearchPlanAttachments.SelectAgentResearch selectAgentResearch = researchPlanAttachments.getSelectAgentResearch();
                if (selectAgentResearch != null && selectAgentResearch.getAttFile() != null && a.getContentId().equals(selectAgentResearch.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile5", a);
                }

                final ResearchPlanAttachments.MultiplePDPILeadershipPlan multiplePDPILeadershipPlan = researchPlanAttachments.getMultiplePDPILeadershipPlan();
                if (multiplePDPILeadershipPlan != null && multiplePDPILeadershipPlan.getAttFile() != null && a.getContentId().equals(multiplePDPILeadershipPlan.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile6", a);
                }

                final ResearchPlanAttachments.ConsortiumContractualArrangements consortiumContractualArrangements = researchPlanAttachments.getConsortiumContractualArrangements();
                if (consortiumContractualArrangements != null && consortiumContractualArrangements.getAttFile() != null && a.getContentId().equals(consortiumContractualArrangements.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile7", a);
                }

                final ResearchPlanAttachments.LettersOfSupport lettersOfSupport = researchPlanAttachments.getLettersOfSupport();
                if (lettersOfSupport != null && lettersOfSupport.getAttFile() != null && a.getContentId().equals(lettersOfSupport.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile8", a);
                }

                final ResearchPlanAttachments.ResourceSharingPlans resourceSharingPlans = researchPlanAttachments.getResourceSharingPlans();
                if (resourceSharingPlans != null && resourceSharingPlans.getAttFile() != null && a.getContentId().equals(resourceSharingPlans.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile9", a);
                }

                final ResearchPlanAttachments.KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = researchPlanAttachments.getKeyBiologicalAndOrChemicalResources();
                if (keyBiologicalAndOrChemicalResources != null && keyBiologicalAndOrChemicalResources.getAttFile() != null && a.getContentId().equals(keyBiologicalAndOrChemicalResources.getAttFile().getFileLocation().getHref())) {
                    return entry("PHS398_ResearchPlan_4_0_P1.optionalFile10", a);
                }

                final AttachmentGroupMin0Max100DataType appendix = researchPlanAttachments.getAppendix();
                if (appendix != null && appendix.getAttachedFileList() != null) {
                    final List<AttachedFileDataType> atts = appendix.getAttachedFileList();
                    for (int i = 0; i < atts.size(); i++) {
                        final AttachedFileDataType att = atts.get(i);

                        if (att != null && a.getContentId().equals(att.getFileLocation().getHref())) {
                            return entry("PHS398_ResearchPlan_4_0_P1.optionalFile11_" + i, a);
                        }
                    }
                }
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHS398ResearchPlan40Document> factory() {
        return PHS398ResearchPlan40Document.Factory;
    }

    private void doWithAttachedFileType(NarrativeContract narrative, Consumer<AttachedFileDataType> fn) {
        Optional.ofNullable(addAttachedFileType(narrative)).ifPresent(fn);
    }
}
