/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrOtherProjectInfo13V13.RROtherProjectInfo13Document;
import gov.grants.apply.forms.rrOtherProjectInfo13V13.RROtherProjectInfo13Document.RROtherProjectInfo13.*;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;


@FormGenerator("RROtherProjectInfo_1_3V1_3Generator")
public class RROtherProjectInfo_1_3V1_3Generator extends
		RROtherProjectInfoBaseGenerator<RROtherProjectInfo13Document> implements S2SFormGeneratorPdfFillable<RROtherProjectInfo13Document> {
	private static final Integer HISTORIC_DESTIONATION_YNQ = 125;

	List<? extends AnswerHeaderContract> answerHeaders;

    @Value("http://apply.grants.gov/forms/RR_OtherProjectInfo_1_3-V1.3")
    private String namespace;

    @Value("RR_OtherProjectInfo_1_3-V1.3")
    private String formName;

	@FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_OtherProjectInfo_1_3-V1.3.fo.xsl")
    private List<Resource> stylesheets;

	@Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_OtherProjectInfo_1_3-V1.3.pdf")
	private Resource pdfForm;

    @Value("140")
    private int sortIndex;

    @Autowired
    @Qualifier("s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

	private RROtherProjectInfo13Document getRROtherProjectInfo() {
		RROtherProjectInfo13Document rrOtherProjectInfoDocument = RROtherProjectInfo13Document.Factory
				.newInstance();
		RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo = RROtherProjectInfo13Document.RROtherProjectInfo13.Factory
				.newInstance();
		rrOtherProjectInfo.setFormVersion(FormVersion.v1_3.getVersion());
		answerHeaders = getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(pdDoc.getDevelopmentProposal().getProposalNumber());
		rrOtherProjectInfo.
		setHumanSubjectsIndicator(YesNoDataType.N_NO);
		rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.N_NO);
		OrganizationContract organization = pdDoc.getDevelopmentProposal()
				.getApplicantOrganization().getOrganization();
		setHumanSubjAndVertebrateAnimals(rrOtherProjectInfo, organization);
		setProprietaryInformationIndicator(rrOtherProjectInfo);
		setEnvironmentalImpactDetails(rrOtherProjectInfo);
		setHistoricDestionation(rrOtherProjectInfo);
		setInternationalActivities(rrOtherProjectInfo);
		setAttachments(rrOtherProjectInfo);
		rrOtherProjectInfoDocument.setRROtherProjectInfo13(rrOtherProjectInfo);
		return rrOtherProjectInfoDocument;
	}

	private void setHistoricDestionation(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
	    String historicDestinationAnswer = getAnswer(HISTORIC_DESTIONATION_YNQ, answerHeaders);
	    if (historicDestinationAnswer != null && !historicDestinationAnswer.equals(NOT_ANSWERED)) {
	        YesNoDataType.Enum answer = YnqConstant.YES.code().equals(historicDestinationAnswer) ? YesNoDataType.Y_YES
	                : YesNoDataType.N_NO;
	        String answerExplanation = getChildQuestionAnswer(HISTORIC_DESTIONATION_YNQ, EXPLANATION, answerHeaders);
	        rrOtherProjectInfo.setHistoricDesignation(answer);
	        if (answerExplanation != null) {
	            if (answerExplanation.trim().length() > EXPLANATION_MAX_LENGTH) {
	                rrOtherProjectInfo
						    .setHistoricDesignationExplanation(answerExplanation
						            .trim()
						            .substring(0, EXPLANATION_MAX_LENGTH));
	            } else {
	                rrOtherProjectInfo
						    .setHistoricDesignationExplanation(answerExplanation
						            .trim());
	            }
	        } else if (YnqConstant.YES.code().equals(historicDestinationAnswer)) {
	            rrOtherProjectInfo.setHistoricDesignationExplanation(null);
	        }
	    } else {
	        rrOtherProjectInfo.setHistoricDesignation(null);
	    }
	}

	private void setProprietaryInformationIndicator(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
		YesNoDataType.Enum answer;
		String propertyInformationAnswer = getAnswer(PROPRIETARY_INFORMATION_INDICATOR, answerHeaders);
		if (propertyInformationAnswer != null && !propertyInformationAnswer.equals(NOT_ANSWERED)) {
    		answer = YnqConstant.YES.code().equals(
                    propertyInformationAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
    		rrOtherProjectInfo.setProprietaryInformationIndicator(answer);
		} else {
		    rrOtherProjectInfo.setProprietaryInformationIndicator(null);
		}
	}

	private void setEnvironmentalImpactDetails(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
		EnvironmentalImpact environmentalImpact = EnvironmentalImpact.Factory
				.newInstance();
		setEnvironmentalImpactIndicatorAndExplanation(environmentalImpact);
		setEnvironmentalExemption(environmentalImpact);
		rrOtherProjectInfo.setEnvironmentalImpact(environmentalImpact);
	}

	private void setEnvironmentalImpactIndicatorAndExplanation(
			EnvironmentalImpact environmentalImpact) {
		String answerExplanation;
		String environmentalImpactAnswer = getAnswer(ENVIRONMENTAL_IMPACT_YNQ, answerHeaders);
		if (environmentalImpactAnswer != null && !environmentalImpactAnswer.equals(NOT_ANSWERED)) {
    		YesNoDataType.Enum answer = YnqConstant.YES.code()
    				.equals(environmentalImpactAnswer) ? YesNoDataType.Y_YES
    				: YesNoDataType.N_NO;
    		answerExplanation =  getChildQuestionAnswer(ENVIRONMENTAL_IMPACT_YNQ, EXPLANATION, answerHeaders);
    		environmentalImpact.setEnvironmentalImpactIndicator(answer);
    		if (answerExplanation != null) {
    			if (answerExplanation.trim().length() > EXPLANATION_MAX_LENGTH) {
    				environmentalImpact
    						.setEnvironmentalImpactExplanation(answerExplanation
    								.trim()
    								.substring(0, EXPLANATION_MAX_LENGTH));
    			} else {
    				environmentalImpact
    						.setEnvironmentalImpactExplanation(answerExplanation
    								.trim());
    			}
    		} else if (YnqConstant.YES.code().equals(environmentalImpactAnswer)) {
    		    environmentalImpact.setEnvironmentalImpactExplanation(null);
    		}
		} else {
		    environmentalImpact.setEnvironmentalImpactIndicator(null);
		}
	}

	private void setHumanSubjAndVertebrateAnimals(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo,
			OrganizationContract organization) {
		rrOtherProjectInfo.
		setHumanSubjectsIndicator(YesNoDataType.N_NO); 
		rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.N_NO);
		pdDoc.getDevelopmentProposal().getPropSpecialReviews().stream()
				.filter(proposalSpecialReview -> proposalSpecialReview.getSpecialReviewType() != null)
				.forEach(proposalSpecialReview -> {
			if (HUMAN_SUBJECT_SUPPLEMENT.equals(proposalSpecialReview.getSpecialReviewType().getCode())) {
				setHumaSubjectSupplementDetails(rrOtherProjectInfo,
						organization, proposalSpecialReview);
			} else if (VERTEBRATE_ANIMALS_SUPPLEMENT.equals(proposalSpecialReview.getSpecialReviewType().getCode())) {
				setVertebrateAnimalsSupplementDetails(rrOtherProjectInfo,
						organization, proposalSpecialReview);
			}
		});
	}

	private void setEnvironmentalExemption(
			EnvironmentalImpact environmentalImpact) {
		YesNoDataType.Enum answer;
		String answerExplanation;		
		answerExplanation = getChildQuestionAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, EXPLANATION, answerHeaders);
		String ynqAnswer = getAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, answerHeaders);
		if (YnqConstant.YES.code().equals(ynqAnswer)) {
			answer = YesNoDataType.Y_YES;
		} else {
			answer = YesNoDataType.N_NO;
		}
		EnvironmentalImpact.EnvironmentalExemption environmentalExemption = EnvironmentalImpact.EnvironmentalExemption.Factory
        .newInstance();
		if (ynqAnswer != null && !ynqAnswer.equals(NOT_ANSWERED)) {
    		if (!YnqConstant.NA.code().equals(ynqAnswer)) {
    			// Answer not equal to X (not-applicable)			
    			environmentalExemption.setEnvironmentalExemptionIndicator(answer);
    			if (answerExplanation != null) {
    				if (answerExplanation.trim().length() > EXPLANATION_MAX_LENGTH) {
    					environmentalExemption
    							.setEnvironmentalExemptionExplanation(answerExplanation
    									.trim().substring(0,EXPLANATION_MAX_LENGTH));
    				} else {
    					environmentalExemption.setEnvironmentalExemptionExplanation(answerExplanation.trim());
    				}
    			} else if (YnqConstant.YES.code().equals(ynqAnswer)) {
    			    environmentalExemption.setEnvironmentalExemptionExplanation(null);
    			}
    		    environmentalImpact.setEnvironmentalExemption(environmentalExemption);
    
    		}
		} else {
		    environmentalExemption.setEnvironmentalExemptionIndicator(null);
        }    		
	}

	private void setInternationalActivities(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
		InternationalActivities internationalActivities = InternationalActivities.Factory
				.newInstance();
		YesNoDataType.Enum answer;
		String answerExplanation;
		String internationalActivitiesAnswer = getAnswer(INTERNATIONAL_ACTIVITIES_YNQ, answerHeaders);
		if (internationalActivitiesAnswer != null && !internationalActivitiesAnswer.equals(NOT_ANSWERED)) {
    		answer = YnqConstant.YES.code().equals(
                    internationalActivitiesAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
    		answerExplanation = getAnswer(INTERNATIONAL_ACTIVITIES_EXPL, answerHeaders);
    		internationalActivities.setInternationalActivitiesIndicator(answer);
    		if (answerExplanation != null && !answerExplanation.equals(NOT_ANSWERED)) {
    			if (answerExplanation.trim().length() > EXPLANATION_MAX_LENGTH) {
    				internationalActivities
    						.setActivitiesPartnershipsCountries(answerExplanation
    								.trim()
    								.substring(0, EXPLANATION_MAX_LENGTH));
    			} else {
    				internationalActivities
    						.setActivitiesPartnershipsCountries(answerExplanation
    								.trim());
    			}
    			if (getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, answerHeaders) != null) {
    			    internationalActivities.setInternationalActivitiesExplanation(getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, answerHeaders));
    			}
    		} else if (YnqConstant.YES.code().equals(internationalActivitiesAnswer)) {
    		    internationalActivities.setActivitiesPartnershipsCountries(answerExplanation);
    		}
		} else {
		    internationalActivities.setInternationalActivitiesIndicator(null);
		}
		rrOtherProjectInfo.setInternationalActivities(internationalActivities);
	}

	private void setVertebrateAnimalsSupplementDetails(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo,
			OrganizationContract organization,
			ProposalSpecialReviewContract proposalSpecialReview) {
		rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.Y_YES);
		VertebrateAnimalsSupplement vertebrateAnimalsSupplement = VertebrateAnimalsSupplement.Factory
				.newInstance();
		setVertebrateAnimalsIACUCReviewDetails(proposalSpecialReview,
				vertebrateAnimalsSupplement);
		if (organization != null
				&& organization.getAnimalWelfareAssurance() != null) {
			vertebrateAnimalsSupplement.setAssuranceNumber(organization
					.getAnimalWelfareAssurance());
		}
		rrOtherProjectInfo
				.setVertebrateAnimalsSupplement(vertebrateAnimalsSupplement);
	}

	private void setHumaSubjectSupplementDetails(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo,
			OrganizationContract organization,
			ProposalSpecialReviewContract proposalSpecialReview) {
		rrOtherProjectInfo.
		setHumanSubjectsIndicator(YesNoDataType.Y_YES);
		HumanSubjectsSupplement humanSubjectsSupplement = HumanSubjectsSupplement.Factory
				.newInstance();
		HumanSubjectsSupplement.ExemptionNumbers exemptionNumbers = HumanSubjectsSupplement.ExemptionNumbers.Factory
				.newInstance();

		if (proposalSpecialReview.getApprovalType() != null) {
			
			
			setExemptions(proposalSpecialReview, humanSubjectsSupplement,
					exemptionNumbers);
			setHumanSubjectIRBReviewIndicator(proposalSpecialReview,
					humanSubjectsSupplement);
		}

		if (organization != null && organization.getHumanSubAssurance() != null) {
			humanSubjectsSupplement.setHumanSubjectAssuranceNumber(organization
					.getHumanSubAssurance().substring(3));
		}
		if (humanSubjectsSupplement != null) {
			rrOtherProjectInfo
					.setHumanSubjectsSupplement(humanSubjectsSupplement);
		}
	}

	private void setVertebrateAnimalsIACUCReviewDetails(
			ProposalSpecialReviewContract proposalSpecialReview,
			VertebrateAnimalsSupplement vertebrateAnimalsSupplement) {
		if (SPECIAL_REVIEW_ANIMAL_USAGE.equals(proposalSpecialReview
				.getApprovalType().getCode())) {
			vertebrateAnimalsSupplement
					.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.Y_YES);
		} else {
			vertebrateAnimalsSupplement
					.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.N_NO);
			if (proposalSpecialReview.getApprovalDate() != null) {
				vertebrateAnimalsSupplement
						.setVertebrateAnimalsIACUCApprovalDateReviewDate(s2SDateTimeService
								.convertDateToCalendar(proposalSpecialReview
										.getApprovalDate()));
			}
		}
	}

	private void setExemptions(ProposalSpecialReviewContract proposalSpecialReview,
			HumanSubjectsSupplement humanSubjectsSupplement,
			HumanSubjectsSupplement.ExemptionNumbers exemptionNumbers) {
	
		if (Integer.parseInt(proposalSpecialReview.getApprovalType().getCode()) == APPROVAL_TYPE_EXCEMPT) {
			if (proposalSpecialReview.getSpecialReviewExemptions() != null) {
				exemptionNumbers.setExemptionNumberArray(proposalSpecialReview.getSpecialReviewExemptions().stream()
						.filter(Objects::nonNull)
						.map(e -> e.getExemptionType().getCode())
						.map(Integer::parseInt)
						.filter(c -> c > 0 && c < 7)
						.map(HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum::forInt)
						.toArray(HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum[]::new));
				humanSubjectsSupplement.setExemptionNumbers(exemptionNumbers);
			}
			humanSubjectsSupplement.setExemptFedReg(YesNoDataType.Y_YES);
		} 
		else{
		    humanSubjectsSupplement.setExemptFedReg(YesNoDataType.N_NO);
		}
		
	}

	private void setHumanSubjectIRBReviewIndicator(
			ProposalSpecialReviewContract proposalSpecialReview,
			HumanSubjectsSupplement humanSubjectsSupplement) {
        if (SPECIAL_REVIEW_APPROVAL_TYPE_PENDING.equals(proposalSpecialReview
                .getApprovalType().getCode()) || SPECIAL_REVIEW_APPROVAL_TYPE_NOT_YET_APPLIED.equals(proposalSpecialReview.getApprovalType().getCode())) {
            humanSubjectsSupplement
                    .setHumanSubjectIRBReviewIndicator(YesNoDataType.Y_YES);
        } else {
            humanSubjectsSupplement
                    .setHumanSubjectIRBReviewIndicator(YesNoDataType.N_NO);
            if (proposalSpecialReview.getApprovalDate() != null) {
                humanSubjectsSupplement
                        .setHumanSubjectIRBReviewDate(s2SDateTimeService
                                .convertDateToCalendar(proposalSpecialReview
                                        .getApprovalDate()));
            }
        }
    }

	private void setAttachments(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
        Boolean isOtherAttachmentsExists = false;

        for (NarrativeContract narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null) {
                switch(Integer.parseInt(narrative.getNarrativeType().getCode())){
                    case(EQUIPMENT_ATTACHMENT):
						AttachedFileDataType equipmentFileDataType = addAttachedFileType(narrative);
						if(equipmentFileDataType != null){
                            EquipmentAttachments equipmentAttachments = EquipmentAttachments.Factory.newInstance();
							equipmentAttachments.setEquipmentAttachment(equipmentFileDataType);
                            rrOtherProjectInfo.setEquipmentAttachments(equipmentAttachments);
                        }
                    break;
                    case(FACILITIES_ATTACHMENT):
						AttachedFileDataType facilitiesFileDataType = addAttachedFileType(narrative);
						if(facilitiesFileDataType != null){
                            FacilitiesAttachments facilitiesAttachments = FacilitiesAttachments.Factory.newInstance();
							facilitiesAttachments.setFacilitiesAttachment(facilitiesFileDataType);
                            rrOtherProjectInfo.setFacilitiesAttachments(facilitiesAttachments);
                        }
                    break;
                    case(NARRATIVE_ATTACHMENT):
						AttachedFileDataType projectNarrativeFileDataType = addAttachedFileType(narrative);
						if(projectNarrativeFileDataType != null){
							ProjectNarrativeAttachments projectNarrativeAttachments = ProjectNarrativeAttachments.Factory.newInstance();
							projectNarrativeAttachments.setProjectNarrativeAttachment(projectNarrativeFileDataType);
							rrOtherProjectInfo.setProjectNarrativeAttachments(projectNarrativeAttachments);
                        }
                    break;
                    case(BIBLIOGRAPHY_ATTACHMENT):
						AttachedFileDataType bibliographyFileDataType = addAttachedFileType(narrative);
						if(bibliographyFileDataType != null){
                            BibliographyAttachments bibliographyAttachments = BibliographyAttachments.Factory.newInstance();
							bibliographyAttachments.setBibliographyAttachment(bibliographyFileDataType);
                            rrOtherProjectInfo.setBibliographyAttachments(bibliographyAttachments);
                        }
                    break;
                    case(ABSTRACT_PROJECT_SUMMARY_ATTACHMENT):
						AttachedFileDataType abstractFileDataType = addAttachedFileType(narrative);
						if(abstractFileDataType != null){
							AbstractAttachments abstractAttachments = AbstractAttachments.Factory.newInstance();
							abstractAttachments.setAbstractAttachment(abstractFileDataType);
							rrOtherProjectInfo.setAbstractAttachments(abstractAttachments);
                        }
                    break;
                    case(OTHER_ATTACHMENT):
                        isOtherAttachmentsExists = true;
                    break;
                }
            }
        }

        if (isOtherAttachmentsExists) {
            setOtherAttachments(rrOtherProjectInfo);
        }
	}

	private void setOtherAttachments(
			RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
		OtherAttachments otherAttachments = OtherAttachments.Factory
				.newInstance();
		otherAttachments.setOtherAttachmentArray(getAttachedFileDataTypes());
		rrOtherProjectInfo.setOtherAttachments(otherAttachments);
	}


	private AttachedFileDataType[] getAttachedFileDataTypes() {
		AttachedFileDataType attachedFileDataType;
		List<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<>();
		DevelopmentProposalContract developmentProposal = pdDoc
				.getDevelopmentProposal();
		for (NarrativeContract narrative : developmentProposal.getNarratives()) {
			if (narrative.getNarrativeType().getCode() != null
					&& (Integer.parseInt(narrative.getNarrativeType().getCode()) == OTHER_ATTACHMENT)) {
				attachedFileDataType= addAttachedFileType(narrative);
				if(attachedFileDataType != null){
					attachedFileDataTypeList.add(attachedFileDataType);
				}
			}
		}
		return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
	}

	@Override
	public RROtherProjectInfo13Document getFormObject(
			ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
		this.pdDoc = proposalDevelopmentDocument;
		return getRROtherProjectInfo();
	}

    public S2SConfigurationService getS2SConfigurationService() {
        return s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

	@Override
	public List<Resource> getStylesheets() {
		return stylesheets;
	}

	public void setStylesheets(List<Resource> stylesheets) {
		this.stylesheets = stylesheets;
	}

	@Override
	public Resource getPdfForm() {
		return pdfForm;
	}

	public void setPdfForm(Resource pdfForm) {
		this.pdfForm = pdfForm;
	}

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

	@Override
	public Attachments getMappedAttachments(RROtherProjectInfo13Document form, List<AttachmentData> attachments) {
		final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {

			final AbstractAttachments abstractAttachments = form.getRROtherProjectInfo13().getAbstractAttachments();
			if (abstractAttachments != null && abstractAttachments.getAbstractAttachment() != null && a.getContentId().equals(abstractAttachments.getAbstractAttachment().getFileLocation().getHref())) {
				return entry("RR_OtherProjectInfo_1_3_P1.mandatoryFile0", a);
			}

			final ProjectNarrativeAttachments projectNarrativeAttachments = form.getRROtherProjectInfo13().getProjectNarrativeAttachments();
			if (projectNarrativeAttachments != null && projectNarrativeAttachments.getProjectNarrativeAttachment() != null && a.getContentId().equals(projectNarrativeAttachments.getProjectNarrativeAttachment().getFileLocation().getHref())) {
				return entry("RR_OtherProjectInfo_1_3_P1.mandatoryFile1", a);
			}

			final BibliographyAttachments bibliographyAttachments = form.getRROtherProjectInfo13().getBibliographyAttachments();
			if (bibliographyAttachments != null && bibliographyAttachments.getBibliographyAttachment() != null && a.getContentId().equals(bibliographyAttachments.getBibliographyAttachment().getFileLocation().getHref())) {
				return entry("RR_OtherProjectInfo_1_3_P1.optionalFile0", a);
			}

			final FacilitiesAttachments facilitiesAttachments = form.getRROtherProjectInfo13().getFacilitiesAttachments();
			if (facilitiesAttachments != null && facilitiesAttachments.getFacilitiesAttachment() != null && a.getContentId().equals(facilitiesAttachments.getFacilitiesAttachment().getFileLocation().getHref())) {
				return entry("RR_OtherProjectInfo_1_3_P1.optionalFile1", a);
			}

			final EquipmentAttachments equipmentAttachments = form.getRROtherProjectInfo13().getEquipmentAttachments();
			if (equipmentAttachments != null && equipmentAttachments.getEquipmentAttachment() != null && a.getContentId().equals(equipmentAttachments.getEquipmentAttachment().getFileLocation().getHref())) {
				return entry("RR_OtherProjectInfo_1_3_P1.optionalFile2", a);
			}

			final OtherAttachments otherAttachments = form.getRROtherProjectInfo13().getOtherAttachments();
			if (otherAttachments != null && otherAttachments.getOtherAttachmentList() != null) {
				final List<AttachedFileDataType> atts = otherAttachments.getOtherAttachmentList();
				for (int i = 0; i < atts.size(); i++) {
					final AttachedFileDataType att = atts.get(i);

					if (att != null && a.getContentId().equals(att.getFileLocation().getHref())){
						return entry("RR_OtherProjectInfo_1_3_P1.optionalFile3_" + i, a);
					}
				}
			}

			return entry((String) null, a);
		}).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

		return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
				attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
	}

	@Override
	public DocumentFactory<RROtherProjectInfo13Document> factory() {
		return RROtherProjectInfo13Document.Factory;
	}
}
