/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudget30V30.RRBudget30Document;
import gov.grants.apply.forms.rrBudget30V30.RRBudget30Document.RRBudget30;
import gov.grants.apply.forms.rrSubawardBudget30V30.RRSubawardBudget30Document;
import gov.grants.apply.forms.rrSubawardBudget30V30.RRSubawardBudget30Document.RRSubawardBudget30;
import gov.grants.apply.forms.rrSubawardBudget30V30.RRSubawardBudget30Document.RRSubawardBudget30.BudgetAttachments;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@FormGenerator("RRSubAwardBudget3_0V3_0Generator")
public class RRSubAwardBudget3_0V3_0Generator extends S2SAdobeFormAttachmentBaseGenerator<RRSubawardBudget30Document> implements S2SFormGeneratorPdfFillable<RRSubawardBudget30Document> {

    private static final String RR_BUDGET3_0_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget_3_0-V3.0";
    private static final String RR_BUDGET3_0_LOCAL_NAME = "RR_Budget_3_0";

    @Value("http://apply.grants.gov/forms/RR_SubawardBudget_3_0-V3.0")
    private String namespace;

    @Value("RR_SubawardBudget_3_0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SubawardBudget_3_0-V3.0.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_SubawardBudget_3_0-V3.0.pdf")
    private Resource pdfForm;

    @Value("177")
    private int sortIndex;

    private RRSubawardBudget30Document getRRSubawardBudgetDocument() throws S2SException  {

        RRSubawardBudget30Document rrSubawardBudgetDocument = RRSubawardBudget30Document.Factory.newInstance();
        RRSubawardBudget30 rrSubawardBudget = RRSubawardBudget30.Factory.newInstance();
        BudgetAttachments budgetAttachments = BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = getBudgetSubAwards(pdDoc, RR_BUDGET3_0_NAMESPACE_URI,false);
        List<RRBudget30> budgetList = new ArrayList<>();
        rrSubawardBudget.setFormVersion(FormVersion.v3_0.getVersion());

        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            final RRBudget30Document rrBudgetDocument = getRRBudget10(budgetSubAwards);
            if (rrBudgetDocument != null) {
               final  RRBudget30 rrBudget = rrBudgetDocument.getRRBudget30();

                switch (attCount) {
                    case 1:
                        rrSubawardBudget.setATT1(prepareAttName(budgetSubAwards));
                        budgetList.add(0, rrBudget);
                        break;
                    case 2:
                        rrSubawardBudget.setATT2(prepareAttName(budgetSubAwards));
                        budgetList.add(1, rrBudget);
                        break;
                    case 3:
                        rrSubawardBudget.setATT3(prepareAttName(budgetSubAwards));
                        budgetList.add(2, rrBudget);
                        break;
                    case 4:
                        rrSubawardBudget.setATT4(prepareAttName(budgetSubAwards));
                        budgetList.add(3, rrBudget);
                        break;
                    case 5:
                        rrSubawardBudget.setATT5(prepareAttName(budgetSubAwards));
                        budgetList.add(4, rrBudget);
                        break;
                    case 6:
                        rrSubawardBudget.setATT6(prepareAttName(budgetSubAwards));
                        budgetList.add(5, rrBudget);
                        break;
                    case 7:
                        rrSubawardBudget.setATT7(prepareAttName(budgetSubAwards));
                        budgetList.add(6, rrBudget);
                        break;
                    case 8:
                        rrSubawardBudget.setATT8(prepareAttName(budgetSubAwards));
                        budgetList.add(7, rrBudget);
                        break;
                    case 9:
                        rrSubawardBudget.setATT9(prepareAttName(budgetSubAwards));
                        budgetList.add(8, rrBudget);
                        break;
                    case 10:
                        rrSubawardBudget.setATT10(prepareAttName(budgetSubAwards));
                        budgetList.add(9, rrBudget);
                        break;
                }
                addSubAwdAttachments(budgetSubAwards);
                attCount++;
            }
            
        }
        budgetAttachments.setRRBudget30Array(budgetList.toArray(new RRBudget30[0]));
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRSubawardBudget30(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRBudget30Document getRRBudget10(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        final RRBudget30Document rrBudget;
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = stringToDom(subAwdXML);

        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_BUDGET3_0_NAMESPACE_URI, RR_BUDGET3_0_LOCAL_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null){
            if(subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }


        byte[] subAwdNodeBytes = docToBytes(nodeToDom(subAwdNode));

        try {
            rrBudget = RRBudget30Document.Factory.parse(new ByteArrayInputStream(subAwdNodeBytes));
        } catch (XmlException|IOException e) {
            throw new RuntimeException(e);
        }

        return rrBudget;
    }

    @Override
    public RRSubawardBudget30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        pdDoc=proposalDevelopmentDocument;
        return getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(RRSubawardBudget30Document form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRSubawardBudget30Document> factory() {
        return RRSubawardBudget30Document.Factory;
    }
}
