/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.person;


import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;

public interface DepartmentalPersonService {

    /**
     *
     * This method populates and returns the Departmental Person object for a
     * given proposal document
     *
     * @param pdDoc
     *            Proposal Development Document.
     * @return DepartmentalPerson departmental Person object for a given
     *         proposal document.
     */
    DepartmentalPersonDto getDepartmentalPerson(ProposalDevelopmentDocumentContract pdDoc);

    /**
     *
     * This method is used to get the details of Contact person
     *
     * @param pdDoc(ProposalDevelopmentDocument)
     *            proposal development document.
     *            for which the DepartmentalPerson has to be found.
     * @return depPerson(DepartmentalPerson) corresponding to the contact type.
     */
    DepartmentalPersonDto getContactPerson(ProposalDevelopmentDocumentContract pdDoc) ;
}
