/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.print;


import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;

/**
 *
 * This interface marks reports, notifications, BOs and Documents as printable
 * in Kuali Coeus. KC Docs and BOs that will be printed via KC printing services
 * should implement this interface.
 */
public interface S2SPrintable {

    String getName();

    /**
     *
     * This method provides a way to get the XSL Transform(s) for the KC
     * generated XML. This XSLT will create a transformed XML-FO stream that
     * will be converted to PDF. Note that multiple transforms are possible on
     * this data.
     */
    List<Resource> getXslTemplates();

    /**
     *
     * This method will provide the either reflected or XML-Bean based XML for
     * input to the Transform into XML-FO.
     */
    String getXml();

    /**
     * This method will return the PDF attachments specific to the printable.
     * During printing the attachments will be added as bookmarks to the output.
     * The Key in the map is used as the name of the bookmark.
     * @return Map of Attachment pdf bytes with bookmark names.
     */
    Map<String, byte[]> getAttachments();
}
