/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.impl.util;

import org.apache.commons.lang3.StringUtils;

public final class Transformers {

    private Transformers() {
        throw new UnsupportedOperationException("do not call");
    }

    private static final int MAX_STREET_LENGTH = 55;

    public static String truncateStreetAddress(String address) {
        return StringUtils.left(address, MAX_STREET_LENGTH);
    }
}
