/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.validate;

import org.kuali.coeus.propdev.api.s2s.S2sErrorContract;
import org.kuali.coeus.propdev.api.s2s.S2sErrorService;
import org.kuali.coeus.s2sgen.api.core.AuditError;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component("s2SErrorHandlerService")
public class S2SErrorHandlerServiceImpl implements S2SErrorHandlerService {

    @Autowired
    @Qualifier("s2sErrorService")
    private S2sErrorService s2sErrorService;

    @Override
    public AuditError getError(String key, String formName) {
        final S2sErrorContract s2sError = s2sErrorService.findS2sErrorByKey(key);
        return s2sError == null ? new AuditError(AuditError.NO_FIELD_ERROR_KEY, key + " is not valid in "+formName, AuditError.GG_LINK) :
                new AuditError(s2sError.getKey(), s2sError.getMessage(), s2sError.getLink());
    }
}
