/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate;

import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;

public interface S2SFormGeneratorPdfFillable<T extends XmlObject> extends Named, Factory<T> {

    Resource getPdfForm();

    Attachments getMappedAttachments(T form, List<AttachmentData> attachments);

    class Attachments {
        private final Map<String, AttachmentData> mapped;
        private final List<AttachmentData> unmapped;

        public Attachments(Map<String, AttachmentData> mapped, List<AttachmentData> unmapped) {
            this.mapped = mapped;
            this.unmapped = unmapped;
        }

        public Map<String, AttachmentData> getMapped() {
    return mapped;
    }

        public List<AttachmentData> getUnmapped() {
    return unmapped;
    }
    }
}
