/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class PHS398CareerDevelopmentAwardSupBaseGenerator<T extends XmlObject> extends S2SBaseFormGenerator<T> {

	protected static final int NARRATIVE_TYPE_INTRODUCTION_TO_APPLICATION = 70;
	protected static final int NARRATIVE_TYPE_SPECIFIC_AIMS = 71;
	protected static final int NARRATIVE_TYPE_BACKGROUND_SIGNIFICANCE = 72;
	protected static final int NARRATIVE_TYPE_RESEARCH_DESIGN_METHODS = 73;
	protected static final int NARRATIVE_TYPE_INCLUSION_ENROLLMENT_REPORT = 79;
	protected static final int NARRATIVE_TYPE_PROGRESS_REPORT_PUBLICATION_LIST = 80;
	protected static final int NARRATIVE_TYPE_PROTECTION_OF_HUMAN_SUBJECTS = 74;
	protected static final int NARRATIVE_TYPE_INCLUSION_OF_WOMEN_AND_MINORITIES = 75;
	protected static final int NARRATIVE_TYPE_TARGETED_PLANNED_ENROLLMENT_TABLE = 76;
	protected static final int NARRATIVE_TYPE_INCLUSION_OF_CHILDREN = 77;
	protected static final int NARRATIVE_TYPE_VERTEBRATE_ANIMALS = 78;
	protected static final int NARRATIVE_TYPE_SELECT_AGENT_RESEARCH = 81;
	protected static final int NARRATIVE_TYPE_PHS_CAREER_PRELIM_STUDIES_PROGREP = 82;
	protected static final int NARRATIVE_TYPE_PHS_CAREER_CONSORTIUM_CONTRACT = 83;
	protected static final int NARRATIVE_TYPE_PHS_CAREER_RESOURCE_SHARING_PLAN = 84;
	protected static final int NARRATIVE_TYPE_CANDIDATE_BACKGROUND = 62;
	protected static final int NARRATIVE_TYPE_CAREER_GOALS_AND_OBJECTIVES = 63;
	protected static final int NARRATIVE_TYPE_CAREER_DEVELOPMENT_AND_TRAINING = 64;
	protected static final int NARRATIVE_TYPE_RESPONSIBLE_CONDUCT_OF_RESEARCH = 65;
	protected static final int NARRATIVE_TYPE_PHS398_MENTORING_PLAN = 66;
	protected static final int NARRATIVE_TYPE_PHS398_MENTOR_STATEMENTS_LETTERS = 67;
	protected static final int NARRATIVE_TYPE_PHS398_INSTITUTIONAL_ENVIRONMENT = 68;
	protected static final int NARRATIVE_TYPE_PHS398_INSTITUTIONAL_COMMITMENT = 69;
	protected static final int NARRATIVE_TYPE_PHS398_CANDIDATE_CONTRIBUTION = -8;
	protected static final int NARRATIVE_TYPE_PHS_CAREER_APPENDIX = 85;
	protected static final int NARRATIVE_TYPE_PHS_CAREER_REASEARCH_STRATEGY = 128;
	protected static final int NARRATIVE_TYPE_PHS_CAREER_SUPPPORT_LTRS = 144;

	protected static final int RESEARCH_OTHER_PLANS = 190;
	
    @Autowired
    @Qualifier("s2SProposalPersonService")
    protected S2SProposalPersonService s2SProposalPersonService;

    public S2SProposalPersonService getS2SProposalPersonService() {
        return s2SProposalPersonService;
    }

    public void setS2SProposalPersonService(S2SProposalPersonService s2SProposalPersonService) {
        this.s2SProposalPersonService = s2SProposalPersonService;
    }
}
