/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup30V30.NonUSCitizenshipDataType;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup30V30.PHS398CareerDevelopmentAwardSup30Document;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup30V30.PHS398CareerDevelopmentAwardSup30Document.PHS398CareerDevelopmentAwardSup30;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup30V30.PHS398CareerDevelopmentAwardSup30Document.PHS398CareerDevelopmentAwardSup30.CareerDevelopmentAwardAttachments;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup30V30.PHS398CareerDevelopmentAwardSup30Document.PHS398CareerDevelopmentAwardSup30.CareerDevelopmentAwardAttachments.*;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;


@FormGenerator("PHS398CareerDevelopmentAwardSupV3_0Generator")
public class PHS398CareerDevelopmentAwardSupV3_0Generator extends
		PHS398CareerDevelopmentAwardSupBaseGenerator<PHS398CareerDevelopmentAwardSup30Document> implements S2SFormGeneratorPdfFillable<PHS398CareerDevelopmentAwardSup30Document> {

	private static final int NARRATIVE_TYPE_PHS_CAREER_CANDIDATE_INFO_AND_GOALS = 153;
	private static final int NARRATIVE_TYPE_PHS_CAREER_DATA_SAFTEY_MONITORING_PLAN = 154;
	private static final int NARRATIVE_TYPE_PHS_CAREER_KEY_BIO_CHEM_RESOURCES = 155;

    @Value("http://apply.grants.gov/forms/PHS398_CareerDevelopmentAwardSup_3_0-V3.0")
    private String namespace;

    @Value("PHS398_CareerDevelopmentAwardSup_3_0")
    private String formName;

	@FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CareerDevelopmentAwardSup-V3.0.xsl")
    private List<Resource> stylesheets;

	@Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_CareerDevelopmentAwardSup_3_0-V3.0.pdf")
	private Resource pdfForm;

    @Value("192")
    private int sortIndex;

    private PHS398CareerDevelopmentAwardSup30Document getPHS398CareerDevelopmentAwardSup() {
	    PHS398CareerDevelopmentAwardSup30Document phs398CareerDevelopmentAwardSupDocument = PHS398CareerDevelopmentAwardSup30Document.Factory.newInstance();
		PHS398CareerDevelopmentAwardSup30 phs398CareerDevelopmentAwardSup30 = PHS398CareerDevelopmentAwardSup30.Factory.newInstance();
		phs398CareerDevelopmentAwardSup30.setFormVersion(FormVersion.v3_0.getVersion());
		setCitizenshipInfo(phs398CareerDevelopmentAwardSup30);
		phs398CareerDevelopmentAwardSup30.setCareerDevelopmentAwardAttachments(getCareerDevelopmentAwardAttachments());
		phs398CareerDevelopmentAwardSupDocument.setPHS398CareerDevelopmentAwardSup30(phs398CareerDevelopmentAwardSup30);
		return phs398CareerDevelopmentAwardSupDocument;
	}

	private void setCitizenshipInfo(PHS398CareerDevelopmentAwardSup30 phs398CareerDevelopmentAwardSup30) {
		final CitizenshipType citizenShip = pdDoc.getDevelopmentProposal().getProposalPersons().stream()
				.filter(ProposalPersonContract::isInvestigator)
				.map(proposalPerson -> s2SProposalPersonService.getCitizenship(proposalPerson))
				.findFirst()
				.orElse(null);

		if(CitizenshipType.NON_US_CITIZEN_WITH_TEMPORARY_VISA.equals(citizenShip)) {
			phs398CareerDevelopmentAwardSup30.setIsNonUSCitizenship(NonUSCitizenshipDataType.TEMPORARY_U_S_VISA);
			phs398CareerDevelopmentAwardSup30.setCitizenshipIndicator(YesNoDataType.N_NO);
		} else if(CitizenshipType.PERMANENT_RESIDENT_OF_US.equals(citizenShip)) {
			phs398CareerDevelopmentAwardSup30.setIsNonUSCitizenship(NonUSCitizenshipDataType.PERMANENT_U_S_RESIDENT_VISA);
			phs398CareerDevelopmentAwardSup30.setCitizenshipIndicator(YesNoDataType.N_NO);
		} else if(CitizenshipType.NOT_RESIDING_IN_US.equals(citizenShip)) {
			phs398CareerDevelopmentAwardSup30.setIsNonUSCitizenship(NonUSCitizenshipDataType.NOT_RESIDING_IN_THE_U_S);
			phs398CareerDevelopmentAwardSup30.setCitizenshipIndicator(YesNoDataType.N_NO);
		} else if(CitizenshipType.TEMP_VISA_ALSO_APPLIED_FOR_PERM_RESIDENT_STATUS.equals(citizenShip)) {
			phs398CareerDevelopmentAwardSup30.setIsNonUSCitizenship(NonUSCitizenshipDataType.TEMPORARY_U_S_VISA);
			phs398CareerDevelopmentAwardSup30.setPermanentResidentByAwardIndicator(YesNoDataType.Y_YES);
			phs398CareerDevelopmentAwardSup30.setCitizenshipIndicator(YesNoDataType.N_NO);
		} else if(CitizenshipType.US_CITIZEN_OR_NONCITIZEN_NATIONAL.equals(citizenShip)) {
			phs398CareerDevelopmentAwardSup30.setCitizenshipIndicator(YesNoDataType.Y_YES);
		}
        if(phs398CareerDevelopmentAwardSup30.getCitizenshipIndicator() == null) {
            phs398CareerDevelopmentAwardSup30.setCitizenshipIndicator(YesNoDataType.N_NO);
            phs398CareerDevelopmentAwardSup30.setIsNonUSCitizenship(null);
        }
	}

	private CareerDevelopmentAwardAttachments getCareerDevelopmentAwardAttachments() {
		CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments = CareerDevelopmentAwardAttachments.Factory.newInstance();
		AttachmentGroupMin0Max100DataType attachmentGroupMin0Max100DataType = AttachmentGroupMin0Max100DataType.Factory.newInstance();
		List<AttachedFileDataType> attachedFileList = new ArrayList<>();
		AttachedFileDataType attachedFileDataType;
		for (NarrativeContract narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
			int narrativeTypeCode = Integer.parseInt(narrative.getNarrativeType().getCode());
			switch (narrativeTypeCode) {
			case NARRATIVE_TYPE_INTRODUCTION_TO_APPLICATION:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				IntroductionToApplication introductionToApplication = IntroductionToApplication.Factory.newInstance();
				introductionToApplication.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setIntroductionToApplication(introductionToApplication);
				break;
			case NARRATIVE_TYPE_SPECIFIC_AIMS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				SpecificAims specificAims = SpecificAims.Factory.newInstance();
				specificAims.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setSpecificAims(specificAims);
				break;			
			case NARRATIVE_TYPE_PROGRESS_REPORT_PUBLICATION_LIST:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ProgressReportPublicationList progressReportPublicationList = ProgressReportPublicationList.Factory.newInstance();
				progressReportPublicationList.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setProgressReportPublicationList(progressReportPublicationList);
				break;
			case NARRATIVE_TYPE_PROTECTION_OF_HUMAN_SUBJECTS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null) {
	                continue;
	            }
				ProtectionOfHumanSubjects protectionOfHumanSubjects = ProtectionOfHumanSubjects.Factory.newInstance();
				protectionOfHumanSubjects.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
				break;
			case NARRATIVE_TYPE_INCLUSION_OF_WOMEN_AND_MINORITIES:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = InclusionOfWomenAndMinorities.Factory.newInstance();
				inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
				break;			
			case NARRATIVE_TYPE_INCLUSION_OF_CHILDREN:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InclusionOfChildren inclusionOfChildren = InclusionOfChildren.Factory.newInstance();
				inclusionOfChildren.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInclusionOfChildren(inclusionOfChildren);
				break;
			case NARRATIVE_TYPE_VERTEBRATE_ANIMALS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				VertebrateAnimals vertebrateAnimals = VertebrateAnimals.Factory.newInstance();
				vertebrateAnimals.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setVertebrateAnimals(vertebrateAnimals);
				break;
			case NARRATIVE_TYPE_SELECT_AGENT_RESEARCH:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				SelectAgentResearch selectAgentResearch = SelectAgentResearch.Factory.newInstance();
				selectAgentResearch.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setSelectAgentResearch(selectAgentResearch);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_CONSORTIUM_CONTRACT:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ConsortiumContractualArrangements consortiumContractualArrangements = ConsortiumContractualArrangements.Factory.newInstance();
				consortiumContractualArrangements.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setConsortiumContractualArrangements(consortiumContractualArrangements);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_RESOURCE_SHARING_PLAN:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ResourceSharingPlans resourceSharingPlans = ResourceSharingPlans.Factory.newInstance();
				resourceSharingPlans.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setResourceSharingPlans(resourceSharingPlans);
				break;
			case NARRATIVE_TYPE_RESPONSIBLE_CONDUCT_OF_RESEARCH:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ResponsibleConductOfResearch responsibleConductOfResearch = ResponsibleConductOfResearch.Factory.newInstance();
				responsibleConductOfResearch.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setResponsibleConductOfResearch(responsibleConductOfResearch);
				break;
			case NARRATIVE_TYPE_PHS398_MENTORING_PLAN:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				MentoringPlan mentoringPlan = MentoringPlan.Factory.newInstance();
				mentoringPlan.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setMentoringPlan(mentoringPlan);
				break;
			case NARRATIVE_TYPE_PHS398_MENTOR_STATEMENTS_LETTERS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				StatementsOfSupport statementsOfSupport = StatementsOfSupport.Factory.newInstance();
				statementsOfSupport.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setStatementsOfSupport(statementsOfSupport);
				break;
			case NARRATIVE_TYPE_PHS398_INSTITUTIONAL_ENVIRONMENT:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InsitutionalEnvironment insitutionalEnvironment = InsitutionalEnvironment.Factory.newInstance();
				insitutionalEnvironment.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInsitutionalEnvironment(insitutionalEnvironment);
				break;
			case NARRATIVE_TYPE_PHS398_INSTITUTIONAL_COMMITMENT:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InstitutionalCommitment institutionalCommitment = InstitutionalCommitment.Factory.newInstance();
				institutionalCommitment.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInstitutionalCommitment(institutionalCommitment);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_APPENDIX:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				attachedFileList.add(attachedFileDataType);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_REASEARCH_STRATEGY:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ResearchStrategy researchStrategy = ResearchStrategy.Factory.newInstance();
				researchStrategy.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setResearchStrategy(researchStrategy);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_SUPPPORT_LTRS:
                attachedFileDataType = addAttachedFileType(narrative);
                if(attachedFileDataType == null){
                    continue;
                }
                LettersOfSupport lettersOfSupport = LettersOfSupport.Factory.newInstance();
                lettersOfSupport.setAttFile(attachedFileDataType);
                careerDevelopmentAwardAttachments.setLettersOfSupport(lettersOfSupport);
                break;
			case NARRATIVE_TYPE_PHS_CAREER_CANDIDATE_INFO_AND_GOALS:
				attachedFileDataType = addAttachedFileType(narrative);
				if(attachedFileDataType == null){
					continue;
				}
				CandidateInformationAndGoals candidateInformationAndGoals = CandidateInformationAndGoals.Factory.newInstance();
				candidateInformationAndGoals.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setCandidateInformationAndGoals(candidateInformationAndGoals);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_DATA_SAFTEY_MONITORING_PLAN:
				attachedFileDataType = addAttachedFileType(narrative);
				if(attachedFileDataType == null){
					continue;
				}
				DataSafetyMonitoringPlan dataSafetyMonitoringPlan = DataSafetyMonitoringPlan.Factory.newInstance();
				dataSafetyMonitoringPlan.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setDataSafetyMonitoringPlan(dataSafetyMonitoringPlan);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_KEY_BIO_CHEM_RESOURCES:
				attachedFileDataType = addAttachedFileType(narrative);
				if(attachedFileDataType == null){
					continue;
				}
				KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = KeyBiologicalAndOrChemicalResources.Factory.newInstance();
				keyBiologicalAndOrChemicalResources.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setKeyBiologicalAndOrChemicalResources(keyBiologicalAndOrChemicalResources);
				break;
			}
		}
		attachmentGroupMin0Max100DataType.setAttachedFileArray(attachedFileList.toArray(new AttachedFileDataType[0]));
		careerDevelopmentAwardAttachments.setAppendix(attachmentGroupMin0Max100DataType);

		setMandatoryAttachments(careerDevelopmentAwardAttachments);
		return careerDevelopmentAwardAttachments;
	}

	/**
	 * This set any mandatory attachments that aren't set to blank objects so that validation errors can be more user friendly.
	 */
	private void setMandatoryAttachments(CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments) {
		if (careerDevelopmentAwardAttachments.getResearchStrategy() == null) {
			careerDevelopmentAwardAttachments.setResearchStrategy(ResearchStrategy.Factory.newInstance());
		}
	}
	
	@Override
	public PHS398CareerDevelopmentAwardSup30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
		this.pdDoc = proposalDevelopmentDocument;
		return getPHS398CareerDevelopmentAwardSup();
	}

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

	@Override
	public List<Resource> getStylesheets() {
		return stylesheets;
	}

	public void setStylesheets(List<Resource> stylesheets) {
		this.stylesheets = stylesheets;
	}

	@Override
	public Resource getPdfForm() {
		return pdfForm;
	}

	public void setPdfForm(Resource pdfForm) {
		this.pdfForm = pdfForm;
	}

	@Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

	@Override
	public Attachments getMappedAttachments(PHS398CareerDevelopmentAwardSup30Document form, List<AttachmentData> attachments) {
		final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
			final CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments = form.getPHS398CareerDevelopmentAwardSup30().getCareerDevelopmentAwardAttachments();
			if (careerDevelopmentAwardAttachments != null) {
				final CareerDevelopmentAwardAttachments.IntroductionToApplication introduction = careerDevelopmentAwardAttachments.getIntroductionToApplication();
				if (introduction != null && introduction.getAttFile() != null && a.getContentId().equals(introduction.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile0", a);
				}

				final CareerDevelopmentAwardAttachments.CandidateInformationAndGoals candidateInformationAndGoals = careerDevelopmentAwardAttachments.getCandidateInformationAndGoals();
				if (candidateInformationAndGoals != null && candidateInformationAndGoals.getAttFile() != null && a.getContentId().equals(candidateInformationAndGoals.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile1", a);
				}

				final CareerDevelopmentAwardAttachments.SpecificAims specificAims = careerDevelopmentAwardAttachments.getSpecificAims();
				if (specificAims != null && specificAims.getAttFile() != null && a.getContentId().equals(specificAims.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile2", a);
				}

				final CareerDevelopmentAwardAttachments.ResearchStrategy researchStrategy = careerDevelopmentAwardAttachments.getResearchStrategy();
				if (researchStrategy != null && researchStrategy.getAttFile() != null && a.getContentId().equals(researchStrategy.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.mandatoryFile0", a);
				}

				final CareerDevelopmentAwardAttachments.ProgressReportPublicationList progressReportPublicationList = careerDevelopmentAwardAttachments.getProgressReportPublicationList();
				if (progressReportPublicationList != null && progressReportPublicationList.getAttFile() != null && a.getContentId().equals(progressReportPublicationList.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile3", a);
				}

				final CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch responsibleConductOfResearch = careerDevelopmentAwardAttachments.getResponsibleConductOfResearch();
				if (responsibleConductOfResearch != null && responsibleConductOfResearch.getAttFile() != null && a.getContentId().equals(responsibleConductOfResearch.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile4", a);
				}

				final CareerDevelopmentAwardAttachments.MentoringPlan mentoringPlan = careerDevelopmentAwardAttachments.getMentoringPlan();
				if (mentoringPlan != null && mentoringPlan.getAttFile() != null && a.getContentId().equals(mentoringPlan.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile5", a);
				}

				final CareerDevelopmentAwardAttachments.StatementsOfSupport statementsOfSupport = careerDevelopmentAwardAttachments.getStatementsOfSupport();
				if (statementsOfSupport != null && statementsOfSupport.getAttFile() != null && a.getContentId().equals(statementsOfSupport.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile6", a);
				}

				final CareerDevelopmentAwardAttachments.LettersOfSupport lettersOfSupport = careerDevelopmentAwardAttachments.getLettersOfSupport();
				if (lettersOfSupport != null && lettersOfSupport.getAttFile() != null && a.getContentId().equals(lettersOfSupport.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile7", a);
				}

				final CareerDevelopmentAwardAttachments.InsitutionalEnvironment institutionalEnvironment = careerDevelopmentAwardAttachments.getInsitutionalEnvironment();
				if (institutionalEnvironment != null && institutionalEnvironment.getAttFile() != null && a.getContentId().equals(institutionalEnvironment.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile8", a);
				}

				final CareerDevelopmentAwardAttachments.InstitutionalCommitment institutionalCommitment = careerDevelopmentAwardAttachments.getInstitutionalCommitment();
				if (institutionalCommitment != null && institutionalCommitment.getAttFile() != null && a.getContentId().equals(institutionalCommitment.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile9", a);
				}

				final CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects protectionOfHumanSubjects = careerDevelopmentAwardAttachments.getProtectionOfHumanSubjects();
				if (protectionOfHumanSubjects != null && protectionOfHumanSubjects.getAttFile() != null && a.getContentId().equals(protectionOfHumanSubjects.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile10", a);
				}

				final CareerDevelopmentAwardAttachments.DataSafetyMonitoringPlan dataSafetyMonitoringPlan = careerDevelopmentAwardAttachments.getDataSafetyMonitoringPlan();
				if (dataSafetyMonitoringPlan != null && dataSafetyMonitoringPlan.getAttFile() != null && a.getContentId().equals(dataSafetyMonitoringPlan.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile11", a);
				}

				final CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = careerDevelopmentAwardAttachments.getInclusionOfWomenAndMinorities();
				if (inclusionOfWomenAndMinorities != null && inclusionOfWomenAndMinorities.getAttFile() != null && a.getContentId().equals(inclusionOfWomenAndMinorities.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile12", a);
				}

				final CareerDevelopmentAwardAttachments.InclusionOfChildren inclusionOfChildren = careerDevelopmentAwardAttachments.getInclusionOfChildren();
				if (inclusionOfChildren != null && inclusionOfChildren.getAttFile() != null && a.getContentId().equals(inclusionOfChildren.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P1.optionalFile13", a);
				}

				final CareerDevelopmentAwardAttachments.VertebrateAnimals vertebrateAnimals = careerDevelopmentAwardAttachments.getVertebrateAnimals();
				if (vertebrateAnimals != null && vertebrateAnimals.getAttFile() != null && a.getContentId().equals(vertebrateAnimals.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P2.optionalFile0", a);
				}

				final CareerDevelopmentAwardAttachments.SelectAgentResearch selectAgentResearch = careerDevelopmentAwardAttachments.getSelectAgentResearch();
				if (selectAgentResearch != null && selectAgentResearch.getAttFile() != null && a.getContentId().equals(selectAgentResearch.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P2.optionalFile1", a);
				}

				final CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements consortiumContractualArrangements = careerDevelopmentAwardAttachments.getConsortiumContractualArrangements();
				if (consortiumContractualArrangements != null && consortiumContractualArrangements.getAttFile() != null && a.getContentId().equals(consortiumContractualArrangements.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P2.optionalFile2", a);
				}

				final CareerDevelopmentAwardAttachments.ResourceSharingPlans resourceSharingPlans = careerDevelopmentAwardAttachments.getResourceSharingPlans();
				if (resourceSharingPlans != null && resourceSharingPlans.getAttFile() != null && a.getContentId().equals(resourceSharingPlans.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P2.optionalFile3", a);
				}

				final CareerDevelopmentAwardAttachments.KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = careerDevelopmentAwardAttachments.getKeyBiologicalAndOrChemicalResources();
				if (keyBiologicalAndOrChemicalResources != null && keyBiologicalAndOrChemicalResources.getAttFile() != null && a.getContentId().equals(keyBiologicalAndOrChemicalResources.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_3_0_P2.optionalFile4", a);
				}

				if (careerDevelopmentAwardAttachments.getAppendix() != null) {
					final List<AttachedFileDataType> atts = careerDevelopmentAwardAttachments.getAppendix().getAttachedFileList();
					for (int i = 0; i < atts.size(); i++) {
						final AttachedFileDataType att = atts.get(i);
						if (att != null && a.getContentId().equals(att.getFileLocation().getHref())){
							return entry("PHS398_CareerDevelopmentAwardSup_3_0_P2.optionalFile_1_" + i, a);
						}
					}
				}
			}

			return entry((String) null, a);
		}).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

		return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
				attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
	}

	@Override
	public DocumentFactory<PHS398CareerDevelopmentAwardSup30Document> factory() {
		return PHS398CareerDevelopmentAwardSup30Document.Factory;
	}
}
