<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:PHSHumanSubjectsAndClinicalTrialsInfo_2_0="http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0"
	xmlns:HumanSubjectStudy_2_0="http://apply.grants.gov/forms/HumanSubjectStudy_2_0-V2.0"
	xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
	xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
	xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
	xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0"
	xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:param name="studyNumber" />
	<xsl:param name="govTrackingNumber" />
	<xsl:param name="opportunityID" />
	<xsl:param name="receivedDateTime" />

	<xsl:template match="HumanSubjectStudy_2_0:HumanSubjectStudy_2_0">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="rest"
					page-height="11in" page-width="8.5in" margin-left="0.6in"
					margin-right="0.6in">
					<fo:region-body margin-top="0.5in" />
					<fo:region-before region-name="region-before-first" extent="0.1in" /> 
					<fo:region-after region-name="footer" extent="0.6in" />
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="all-pages">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference
							master-reference="rest" page-position="rest" />
					</fo:repeatable-page-master-alternatives>
				</fo:page-sequence-master>
			</fo:layout-master-set>

			<!-- Study -->
			<fo:page-sequence master-reference="rest" format="1">
				
				<fo:static-content flow-name="region-before-first">
					<fo:block-container position="absolute" left="0.2in"
						top="0.7in" height="12px">
						<fo:block text-align="end" font-size="6px" font-family="arialuni">OMB Number: 0925-0001
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.2in"
						top="0.9in" height="12px">
						<fo:block text-align="end" font-size="6px" font-family="arialuni">Expiration Date: 02/28/2023
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				
				<fo:static-content flow-name="footer">
					<fo:table width="100%" space-before.optimum="0pt"
						space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell hyphenate="true" language="en"
									padding-start="0pt" padding-end="0pt" padding-before="1pt"
									padding-after="1pt" display-align="before" text-align="left"
									border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Tracking Number:
											<xsl:value-of select="$govTrackingNumber" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell hyphenate="true" language="en"
									line-height="9pt" padding-start="0pt" padding-end="0pt"
									padding-before="1pt" padding-after="1pt" display-align="before"
									text-align="right" border-style="solid" border-width="0pt"
									border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Funding Opportunity Number:
											<xsl:value-of select="$opportunityID" />
										</fo:inline>
										<fo:inline font-size="8px">
											Received Date:
											<xsl:value-of select="$receivedDateTime" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>


				<fo:flow flow-name="xsl-region-body">
					<xsl:call-template name="humanSubjectStudiesSection1" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<!-- PHS Human Subjects and Clinical Trials Information -> Study -> Section 1 -->
	<xsl:template name="humanSubjectStudiesSection1">
		<fo:block>
				<fo:table font-size="12pt" width="100%"
						space-before.optimum="1pt" space-after.optimum="0.5pt" table-layout="fixed"
						height="100%">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />

				<fo:table-body start-indent="0pt">
					<fo:table-row>
							<fo:table-cell text-align="left" padding-start="1px" padding-end="3pt"
								padding-before="1pt" padding-after="4pt"  number-columns-spanned="6">
							<fo:block padding="10pt">
								<fo:inline font-weight="bold" font-size="10px" padding="2pt">
									<xsl:text>Section 1 - Basic Information</xsl:text>
									<xsl:choose>
										<xsl:when test="normalize-space($studyNumber) != ''">
											(Study <xsl:value-of select="$studyNumber" />)
										</xsl:when>
									</xsl:choose>
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

					<!-- 1.1. Study Title -->
					<fo:table-row>
						<fo:table-cell 	text-align="left" padding-start="1px" padding-end="3pt" number-columns-spanned="5"
										padding-before="1pt" padding-after="4pt" >
					 		<fo:block font-size="8px">1.1. Study Title *</fo:block>
					 	</fo:table-cell>
					</fo:table-row>			
					<fo:table-row>
						<xsl:call-template name="text-field">
							<xsl:with-param name="number-columns-spanned">11</xsl:with-param>
							<xsl:with-param name="field_value" select="HumanSubjectStudy_2_0:StudyTitle"/>
						</xsl:call-template>
					</fo:table-row>			
			
					<!-- 1.2. Exempt from Fed Regulations -->
					<fo:table-row>
								<fo:table-cell display-align="center" number-columns-spanned="4">
									<fo:block font-size="8px">1.2. Is this study exempt from Federal Regulations *</fo:block>
								</fo:table-cell>

						<xsl:call-template name="radio-field">
							<xsl:with-param name="xml_field" select="HumanSubjectStudy_2_0:ExemptFedReg"/>
							<xsl:with-param name="padding-start">24</xsl:with-param>
						</xsl:call-template>
						
						
					</fo:table-row>

					<!-- 1.3. Exemption Number -->
					<fo:table-row>
						
						<fo:table-cell number-columns-spanned="5"
							text-align="left" display-align="center">
									<fo:block font-size="8px">1.3. Exemption Number</fo:block>
								</fo:table-cell>
														
						<fo:table-cell number-columns-spanned="8" padding="1pt" text-align="left" display-align="center">
							<fo:block>
								<fo:table font-size="9px" table-layout="fixed" width="80%">
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell border="solid 1pt white"
												border-spacing="1pt" display-align="center">
												<fo:table font-size="9px" table-layout="fixed"
													width="100%">
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E1</xsl:with-param>
																<xsl:with-param name="checkbox_text">1</xsl:with-param>
															</xsl:call-template>

															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E2</xsl:with-param>
																<xsl:with-param name="checkbox_text">2</xsl:with-param>
															</xsl:call-template>

															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E3</xsl:with-param>
																<xsl:with-param name="checkbox_text">3</xsl:with-param>
															</xsl:call-template>
			
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E4</xsl:with-param>
																<xsl:with-param name="checkbox_text">4</xsl:with-param>
															</xsl:call-template>
														
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E5</xsl:with-param>
																<xsl:with-param name="checkbox_text">5</xsl:with-param>
															</xsl:call-template>
														
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E6</xsl:with-param>
																<xsl:with-param name="checkbox_text">6</xsl:with-param>
															</xsl:call-template>
															
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E7</xsl:with-param>
																<xsl:with-param name="checkbox_text">7</xsl:with-param>
															</xsl:call-template>
															
															 <xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E8</xsl:with-param>
																<xsl:with-param name="checkbox_text">8</xsl:with-param>
															</xsl:call-template>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

					<!-- 1.4 Clinical Trial Questionnaire -->
					<fo:table-row>					
								<fo:table-cell display-align="center" number-columns-spanned="7" padding-before="5pt">
									<fo:block font-size="8px">1.4. Clinical Trial Questionnaire *</fo:block>
								</fo:table-cell>
														
					</fo:table-row>

					<!-- 1.4a -->
					<fo:table-row>

						
								<fo:table-cell display-align="center" number-columns-spanned="7" padding-start="16">
									<fo:block font-size="8px">1.4.a. Does the study involve human participants?</fo:block>
								</fo:table-cell>
						
						
						<xsl:call-template name="radio-field">
							<xsl:with-param name="xml_field" select="HumanSubjectStudy_2_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_2_0:HumanSubjectsIndicator"/>
						</xsl:call-template>
					</fo:table-row>

					<!-- 1.4b -->
					<fo:table-row>

								<fo:table-cell display-align="center" number-columns-spanned="7" padding-start="16">
									<fo:block font-size="8px">1.4.b. Are the participants prospectively assigned to an intervention?</fo:block>
								</fo:table-cell>						
						
						<xsl:call-template name="radio-field">
							<xsl:with-param name="xml_field" select="HumanSubjectStudy_2_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_2_0:InterventionAssigned"/>
						</xsl:call-template>
					</fo:table-row>

					<!-- 1.4c -->
					<fo:table-row>						
								<fo:table-cell display-align="center" number-columns-spanned="7" padding-start="16">
									<fo:block font-size="8px">1.4.c. Is the study designed to evaluate the effect of the intervention on the participants?</fo:block>
								</fo:table-cell>	
						
						<xsl:call-template name="radio-field">
							<xsl:with-param name="xml_field" select="HumanSubjectStudy_2_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_2_0:EvaluateIntervention"/>
						</xsl:call-template>
					</fo:table-row>
					
					<!-- 1.4d -->
					<fo:table-row>						
								<fo:table-cell display-align="center" number-columns-spanned="7" padding-start="16">
									<fo:block font-size="8px">1.4.d. Is the effect that will be evaluated a health-related biomedical or behavioral outcome?</fo:block>
								</fo:table-cell>	
								
						<xsl:call-template name="radio-field">
							<xsl:with-param name="xml_field" select="HumanSubjectStudy_2_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_2_0:HealthRelatedOutcome"/>
						</xsl:call-template>
					</fo:table-row>
					<fo:table-row>
							<fo:table-cell number-columns-spanned="5"
								text-align="left" padding-start="1px" padding-end="3pt"
								padding-before="1pt" padding-after="4pt" >
								<fo:block font-size="8px">
									1.5. Provide the ClinicalTrials.gov Identifier (e.g. NCT87654321) for this trial, if applicable
								</fo:block>
							</fo:table-cell>

						<xsl:call-template name="text-field">
							<xsl:with-param name="number-columns-spanned">6</xsl:with-param>
							<xsl:with-param name="field_value" select="HumanSubjectStudy_2_0:ClinicalTrialsIdentifier"/>
						</xsl:call-template>
					</fo:table-row>						
					
					<!-- End of Clinical Trial Questionnaire -->	
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	 <!-- End of Section 1 -->
	 
	 
	<!-- Utility Templates -->
	<!-- A generic field value area: $text-field will be displayed in the cell -->
	<xsl:template name="text-field">
		<xsl:param name="field_value" />
		<xsl:param name="number-columns-spanned" select="1" />
		<fo:table-cell number-columns-spanned="{$number-columns-spanned}" text-align="left" padding-start="1px" padding-end="3pt"
					   padding-before="1pt" padding-after="4pt" >
			<fo:block>
				<fo:table font-size="9px" table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)" />
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell border="solid 1pt white"
								border-spacing="1pt" padding="2pt" display-align="center">
								<fo:block>
									<fo:inline>
										<xsl:value-of select="$field_value" />
									</fo:inline>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<!--  
	Create checkboxes with display text, ${checkbox_text}, and assign the value, ${checkbox_value}
	If the checkbox value is contained in ExemptionNumber Node, the checkbox is marked off
	 -->
	<xsl:template name="exemption_checkbox">
		<xsl:param name="checkbox_text" />
		<xsl:param name="checkbox_value" />
		<fo:table-cell hyphenate="true" language="en" padding-start="0pt" padding-end="0pt" padding-before="0pt"
		padding-after="0pt" display-align="before" text-align="start"
		border-style="solid" border-width="0pt" border-color="white">
			<fo:block font-size="9px">
				<fo:inline font-family="ZapfDingbats">&#x274F;</fo:inline>
				<fo:block-container keep-together="always"
					position="absolute">
					<fo:block>
						<xsl:choose>
							<xsl:when
								test="normalize-space($checkbox_value) = HumanSubjectStudy_2_0:ExemptionNumbers/HumanSubjectStudy_2_0:ExemptionNumber">
								<fo:inline font-family="ZapfDingbats" font-size="8pt">&#x2714;
								</fo:inline>
							</xsl:when>
						</xsl:choose>
					</fo:block>
				</fo:block-container>
				<fo:block-container position="absolute" left="10pt">
					<fo:block>
						<xsl:value-of select="$checkbox_text" />
					</fo:block>
				</fo:block-container>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	 
 <!--  
	Creates radio field for a given ${xml_field} with 'Yes' or 'No' options
	Marks the value where ${xml_field} = radio_box value as selected
	 -->
	<xsl:template name="radio-field">
		<xsl:param name="xml_field" />
		<xsl:param name="padding-start" select="0"/>
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" padding-start="{$padding-start}" number-columns-spanned="4"
							padding-end="2pt" padding-before="2pt" padding-after="2pt"
							display-align="center" text-align="start" 
							border-width="1pt" border-color="white">
			<fo:block>
				<fo:table font-size="9px" table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)" />
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell border="solid 1pt white" border-spacing="1pt" padding="2pt">
								<fo:table>
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-body>
										<fo:table-row>
											<xsl:call-template name="yesOrNoRadio">
												<xsl:with-param name="xml_field" select="$xml_field" />
											</xsl:call-template>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<xsl:template name="yesOrNoRadio">
		<xsl:param name="xml_field" />
		<!-- YES -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				Yes
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				Y: Yes
			</xsl:with-param>
		</xsl:call-template>
		<!-- NO -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				No
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				N: No
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="options">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_text" />
		<xsl:param name="radio_value" />
		<fo:table-cell  text-align="right" border-spacing="2px" display-align="center">
			<fo:block>
				<xsl:call-template name="radio">
					<xsl:with-param name="xml_field" select="$xml_field" />
					<xsl:with-param name="radio_value" select="$radio_value" />
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell text-align="left" border-spacing="2px" display-align="center">
			<fo:block>
				<xsl:value-of select="$radio_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>

	<xsl:template name="radio">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_value" />
		<xsl:choose>
			<xsl:when
				test="normalize-space($xml_field) = normalize-space($radio_value)">
				<fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="7pt" padding-end="7pt">&#x25cf;</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="7pt" padding-end="7pt" >&#x274d;</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
