/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.person;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.unit.UnitRepositoryService;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component("s2sDivisionService")
public class S2sDivisionServiceImpl implements S2sDivisionService {

    private static final int DIVISION_NAME_MAX_LENGTH = 30;

    @Autowired
    @Qualifier("unitRepositoryService")
    private UnitRepositoryService unitRepositoryService;

    @Override
    public String getDivision(ProposalPersonContract person) {
        if (person != null) {
            if (StringUtils.isNotBlank(person.getDivision())) {
                return StringUtils.substring(person.getDivision(), 0, DIVISION_NAME_MAX_LENGTH);
            } else {
                return getDivisionFromUnit(person.getHomeUnit());
            }
        }
        return null;
    }

    @Override
    public String getDivision(DepartmentalPersonDto person) {
        if (person != null) {
            return getDivisionFromUnit(person.getHomeUnit());
        }
        return null;
    }

    @Override
    public String getDivisionFromUnit(String unitNumber) {
        if (StringUtils.isNotBlank(unitNumber)) {
            final UnitContract unit = getUnitRepositoryService().findUnitByUnitNumber(unitNumber);
            return StringUtils.substring(unit != null && unit.getParentUnit() != null ?
                    unit.getParentUnit().getUnitName() : unit != null && unit.getParentUnit() == null ?
                    unit.getUnitName() : null, 0, DIVISION_NAME_MAX_LENGTH);
        }

        return null;
    }

    public UnitRepositoryService getUnitRepositoryService() {
        return unitRepositoryService;
    }

    public void setUnitRepositoryService(UnitRepositoryService unitRepositoryService) {
        this.unitRepositoryService = unitRepositoryService;
    }
}
