/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.impl.util;

import org.apache.xmlbeans.XmlOptions;

import javax.xml.namespace.QName;
import java.util.HashMap;
import java.util.Map;

import static org.kuali.coeus.s2sgen.impl.util.MultiProjectConstants.META_MULTI_GRANT_APPLICATION_NAMESPACE;

public final class XmlBeansUtils {

    private static final String META_GRANT_APPLICATION_NAMESPACE = "http://apply.grants.gov/system/MetaGrantApplication";

    private XmlBeansUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static XmlOptions getXmlOptionsPrefixes() {
        final XmlOptions xmlOptions = new XmlOptions();
        final Map<String, String> prefixMap = new HashMap<>();
        prefixMap.put(META_GRANT_APPLICATION_NAMESPACE, "");
        xmlOptions.setSaveSuggestedPrefixes(prefixMap);
        xmlOptions.setSaveCDataEntityCountThreshold(Integer.MAX_VALUE);
        xmlOptions.setSaveCDataLengthThreshold(Integer.MAX_VALUE);
        return xmlOptions;
    }

    public static QName createMPElement(String componentType, String elementName) {
        return new QName(META_MULTI_GRANT_APPLICATION_NAMESPACE + "/" + componentType, elementName, generatePrefix(componentType));
    }

    private static String generatePrefix(String componentType) {
        String prefix = componentType.toLowerCase().replaceAll("[^a-z0-9]", "");
        return prefix.length() > 6 ? prefix.substring(0, 6) : prefix;
    }
}
