<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:SFLLL_2_0="http://apply.grants.gov/forms/SFLLL_2_0-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.48in" margin-bottom="0.48in"/>
				<fo:region-after extent=".3in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="SFLLL_2_0:LobbyingActivitiesDisclosure_2_0">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<fo:static-content flow-name="xsl-region-after">
					<fo:block>
						<fo:inline font-size="6px" font-weight="bold"></fo:inline>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
							<fo:table-column/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell font-size="8px" display-align="before" height="531pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
										<fo:block>
											<fo:table width="100%" space-before.optimum="1pt">
												<fo:table-column column-width="172.75pt"/>
												<fo:table-column column-width="172.75pt"/>
												<fo:table-column column-width="172.75pt"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" number-columns-spanned="3" width="172.75pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:block color="black" space-before.optimum="-8pt">
																	<fo:leader leader-length="100%" leader-pattern="rule" rule-thickness="2pt"/>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" height="13pt" number-columns-spanned="3" text-align="center" width="172.75pt" display-align="center" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="12px" font-style="normal" font-weight="bold">DISCLOSURE OF LOBBYING ACTIVITIES</fo:inline>
															</fo:block>
															<fo:block text-align="right">
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">Approved by OMB</fo:inline>
															</fo:block>
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">Complete this form to disclose lobbying activities pursuant to 31 U.S.C. 1352 </fo:inline>
															</fo:block>
															<fo:block text-align="right">
																<fo:inline font-size="8px" font-style="normal">4040-0013</fo:inline>
															</fo:block>
															<fo:block>
																<fo:inline font-size="8px" font-style="normal">&#160;</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell border-after-color="white" border-before-color="black" border-end-color="black" border-start-color="black" font-size="8px" display-align="before" text-align="left" width="172.75pt" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">1.&#160; * Type of Federal Action:</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="white" border-before-color="black" border-end-color="black" border-start-color="black" font-size="8px" display-align="before" text-align="left" width="172.75pt" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">2.&#160; * Status of Federal Action:</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="white" border-before-color="black" border-end-color="black" border-start-color="black" font-size="8px" display-align="before" text-align="left" width="172.75pt" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">3.&#160; * Report Type:</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell hyphenate="true" language="en" border-after-color="white" border-before-color="white" font-size="8px" display-align="before" text-align="left" width="172.75pt" padding-start="3pt" padding-end="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='Contract'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> a. contract</fo:inline>
															</fo:block>
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='Grant'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> b. grant</fo:inline>
															</fo:block>
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='CoopAgree'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> c. cooperative agreement</fo:inline>
															</fo:block>
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='Loan'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> d. loan</fo:inline>
															</fo:block>
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='LoanGuarantee'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt" >&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> e. loan guarantee</fo:inline>
															</fo:block>
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='LoanInsurance'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> f. loan insurance </fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="white" border-before-color="white" font-size="8px" display-align="before" text-align="left" width="172.75pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionStatus">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='BidOffer'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> a. bid/offer/application</fo:inline>
															</fo:block>
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionStatus">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='InitialAward'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> b. initial award</fo:inline>
															</fo:block>
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:FederalActionStatus">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='PostAward'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> c. post-award</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-after-color="white" border-before-color="white" font-size="8px" display-align="before" text-align="left" width="172.75pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																&#160; <xsl:for-each select="SFLLL_2_0:ReportType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='InitialFiling'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> a. initial filing</fo:inline>
															</fo:block>
															<fo:block>&#160; <xsl:for-each select="SFLLL_2_0:ReportType">
																<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:choose>
																			<xsl:when test=".='MaterialChange'">
																				<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline text-decoration="underline" color="black">
																					<fo:leader leader-length="7pt" leader-pattern="rule"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</fo:inline>
																</fo:inline>
															</xsl:for-each>
																<fo:inline font-size="6px" font-style="normal"> b. material change</fo:inline>
															</fo:block>
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">&#160;&#160;&#160;&#160;&#160;&#160; For Material Change Only: </fo:inline>
																<fo:block>
																	<xsl:text>&#xA;</xsl:text>
																</fo:block>
																<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
																	<fo:table-column column-width="20pt"/>
																	<fo:table-column/>
																	<fo:table-column/>
																	<fo:table-column/>
																	<fo:table-column/>
																	<fo:table-column/>
																	<fo:table-body>
																		<fo:table-row>
																			<fo:table-cell font-size="8px" display-align="before" width="20pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<fo:inline font-size="8px" font-style="normal">&#160;</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<fo:inline font-size="6px" font-style="normal"> year </fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<xsl:for-each select="SFLLL_2_0:MaterialChangeSupplement">
																						<xsl:for-each select="SFLLL_2_0:MaterialChangeYear">
																							<fo:inline font-size="8px" font-style="normal">
																								<xsl:apply-templates/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<fo:inline font-size="6px" font-style="normal">quarter </fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<xsl:for-each select="SFLLL_2_0:MaterialChangeSupplement">
																						<xsl:for-each select="SFLLL_2_0:MaterialChangeQuarter">
																							<fo:inline font-size="8px" font-style="normal">
																								<xsl:apply-templates/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<fo:inline font-size="8px" font-style="normal">&#160;</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell font-size="8px" display-align="before" width="20pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<fo:inline font-size="8px" font-style="normal">&#160;</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell border-after-color="white" font-size="8px" display-align="before" number-columns-spanned="5" width="20pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																				<fo:block>
																					<fo:inline font-size="6px" font-style="normal">date of last report </fo:inline>
																					<xsl:for-each select="SFLLL_2_0:MaterialChangeSupplement">
																						<xsl:for-each select="SFLLL_2_0:LastReportDate">
																							<fo:inline font-size="8px">
																								<xsl:value-of select="format-number(substring(.,6,2), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(substring(.,9,2), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(substring(.,1,4), '0000')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
											<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
												<fo:table-column column-width="30pt"/>
												<fo:table-column column-width="30pt"/>
												<fo:table-column/>
												<fo:table-column/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell language="en" hyphenate="true" font-size="8px" display-align="before" height="10pt" number-columns-spanned="4" text-align="left" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">4.&#160; Name and Address of Reporting Entity:</fo:inline>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
															</fo:block>
															<fo:block>
																<xsl:for-each select="SFLLL_2_0:ReportEntity">
																	<xsl:for-each select="SFLLL_2_0:ReportEntityIsPrime">
																		<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																			<fo:inline font-size="8px" font-style="normal">
																				<xsl:choose>
																					<xsl:when test=".='Y: Yes'">
																						<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline text-decoration="underline" color="black">
																							<fo:leader leader-length="7pt" leader-pattern="rule"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:inline>
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
																<fo:inline font-size="8px" font-style="normal">Prime&#160;&#160;&#160;&#160; </fo:inline>
																<xsl:for-each select="SFLLL_2_0:ReportEntity">
																	<xsl:for-each select="SFLLL_2_0:ReportEntityIsPrime">
																		<fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
																			<fo:inline font-size="8px" font-style="normal">
																				<xsl:choose>
																					<xsl:when test=".='N: No'">
																						<fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline text-decoration="underline" color="black">
																							<fo:leader leader-length="7pt" leader-pattern="rule"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:inline>
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
																<fo:inline font-size="8px" font-style="normal"> SubAwardee&#160;&#160;&#160;&#160;&#160; Tier if known: </fo:inline>
																<xsl:for-each select="SFLLL_2_0:ReportEntity">
																	<xsl:for-each select="SFLLL_2_0:Tier">
																		<fo:inline font-size="8px" font-style="normal">
																			<xsl:apply-templates/>
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
															<fo:block>
																<xsl:for-each select="SFLLL_2_0:ReportEntity">
																	<xsl:for-each select="SFLLL_2_0:ReportingEntity">
																		<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
																			<fo:table-column/>
																			<fo:table-column/>
																			<fo:table-column/>
																			<fo:table-body>
																				<fo:table-row>
																					<fo:table-cell language="en" hyphenate="true" keep-together="always" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
																						<fo:block>
																							<fo:inline font-size="8px" font-style="normal">* Name </fo:inline>
																							<xsl:for-each select="SFLLL_2_0:OrganizationName">
																								<fo:inline font-size="8px" font-style="normal">
																									<xsl:apply-templates/>
																								</fo:inline>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																				<fo:table-row>
																					<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																						<fo:block>
																							<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:Street1">
																								<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* Street 1 </fo:inline><xsl:apply-templates/></fo:block>
																							</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																						<fo:block>
																							<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:Street2">
																								<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Street 2 </fo:inline><xsl:apply-templates/></fo:block>
																							</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																				<fo:table-row>
																					<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																						<fo:block>
																							<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:City"><fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* City </fo:inline><xsl:apply-templates/></fo:block>
																							</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																						<fo:block>
																							<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:State">
																								<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  State </fo:inline><xsl:apply-templates/></fo:block>
																							</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																						<fo:block>
																							<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:ZipPostalCode">
																								<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Zip </fo:inline><xsl:apply-templates/></fo:block>
																							</xsl:for-each>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																				<fo:table-row>
																					<fo:table-cell language="en" hyphenate="true" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																						<fo:block>
																							<fo:inline font-size="8px" font-style="normal">Congressional District, if known: </fo:inline>
																							<xsl:for-each select="SFLLL_2_0:CongressionalDistrict">
																								<fo:block keep-together="always">
																									<fo:inline font-size="8px" font-style="normal">
																										<xsl:apply-templates/>
																									</fo:inline>
																								</fo:block>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-body>
																		</fo:table>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row height="40px">
														<fo:table-cell language="en" hyphenate="true" font-size="8px" display-align="before" height="10pt" number-columns-spanned="4" text-align="left" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block></fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell language="en" hyphenate="true" font-size="8px" display-align="before" height="9pt" number-columns-spanned="3" width="30pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">6.&#160; * Federal Department/Agency: </fo:inline>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
																<xsl:for-each select="SFLLL_2_0:FederalAgencyDepartment">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:apply-templates/>
																	</fo:inline>
																</xsl:for-each>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell language="en" hyphenate="true" font-size="8px" display-align="before" height="9pt" width="30pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">7.&#160; * Federal Program Name/Description: </fo:inline>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
																<xsl:for-each select="SFLLL_2_0:FederalProgramName">
																	<xsl:for-each select="SFLLL_2_0:FederalProgramName">
																		<fo:inline font-size="8px" font-style="normal">
																			<xsl:apply-templates/>
																		</fo:inline>
																	</xsl:for-each>
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline font-size="8px" font-style="normal">CFDA Number, if applicable: </fo:inline>
																	<xsl:for-each select="SFLLL_2_0:CFDANumber">
																		<fo:inline font-size="8px" font-style="normal">
																			<xsl:apply-templates/>
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell hyphenate="true" language="en" font-size="8px" display-align="before" number-columns-spanned="3" width="30pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">8. Federal Action Number, if known:</fo:inline>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
																<xsl:for-each select="SFLLL_2_0:FederalActionNumber">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:apply-templates/>
																	</fo:inline>
																</xsl:for-each>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell hyphenate="true" language="en" font-size="8px" display-align="before" width="30pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">9.&#160; Award Amount, if known:</fo:inline>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
																<xsl:for-each select="SFLLL_2_0:AwardAmount">
																	<fo:inline font-size="8px" font-style="normal">
																		<xsl:value-of select="format-number(., '$#,##0.00')"/>
																	</fo:inline>
																</xsl:for-each>
																<fo:block>
																	<fo:leader leader-pattern="space"/>
																</fo:block>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-size="8px" display-align="before" number-columns-spanned="4" text-align="left" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">10. a. Name and Address of Lobbying Registrant:</fo:inline>
																<xsl:for-each select="SFLLL_2_0:LobbyingRegistrant">
																	<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
																		<fo:table-column/>
																		<fo:table-column/>
																		<fo:table-column/>
																		<fo:table-body>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:IndividualName"><xsl:for-each select="globLib:PrefixName"><fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Prefix </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:IndividualName"><xsl:for-each select="globLib:FirstName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* First Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:IndividualName"><xsl:for-each select="globLib:MiddleName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Middle Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:IndividualName"><xsl:for-each select="globLib:LastName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* Last Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:IndividualName"><xsl:for-each select="globLib:SuffixName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Suffix </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:Street1">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* Street 1 </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:Street2">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Street 2 </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:City"><fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* City </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:State">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  State </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:ZipPostalCode">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Zip </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-size="8px" display-align="before" number-columns-spanned="4" text-align="left" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">b. Individual Performing Services</fo:inline><fo:inline font-size="8px" font-style="normal"> (including address if different from No. 10a)</fo:inline>
																<xsl:for-each select="SFLLL_2_0:IndividualsPerformingServices"><xsl:for-each select="SFLLL_2_0:Individual">
																	<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
																		<fo:table-column/>
																		<fo:table-column/>
																		<fo:table-column/>
																		<fo:table-body>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:PrefixName"><fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Prefix </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:FirstName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* First Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:MiddleName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Middle Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:LastName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* Last Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:SuffixName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Suffix </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:Street1">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* Street 1 </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:Street2">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Street 2 </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:City"><fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* City </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:State">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  State </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Address"><xsl:for-each select="SFLLL_2_0:ZipPostalCode">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Zip </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</xsl:for-each></xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell font-size="8px" display-align="before" number-columns-spanned="4" text-align="left" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
															<fo:block>
																<fo:inline font-size="8px" font-style="normal" font-weight="bold">11. </fo:inline><fo:inline font-size="8px">Information requested through this form is authorized by title 31 U.S.C. section  1352.  This disclosure of lobbying activities is a material representation of fact  upon which reliance was placed by the tier above when the transaction was made or entered into.  This disclosure is required pursuant to 31 U.S.C. 1352. This information will be reported to the Congress semi-annually and will be available for public inspection.  Any person who fails to file the required disclosure shall be subject to a civil penalty of not less than $10,000 and not more than $100,000 for each such failure.</fo:inline>
																<xsl:for-each select="SFLLL_2_0:SignatureBlock">
																	<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
																		<fo:table-column/>
																		<fo:table-column/>
																		<fo:table-column/>
																		<fo:table-body>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:PrefixName"><fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal" font-weight="bold">  *Name:         </fo:inline> <fo:inline font-size="8px" font-style="normal">  Prefix </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:FirstName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* First Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:MiddleName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Middle Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:LastName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">* Last Name </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Name"><xsl:for-each select="globLib:SuffixName">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal">  Suffix </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Title"><fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal" font-weight="bold">  Title: </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:Telephone">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal" font-weight="bold">  Telephone No.: </fo:inline><xsl:apply-templates/></fo:block>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell language="en" hyphenate="true" border-after-color="white" border-before-color="white" border-end-color="white" border-start-color="white" font-size="8px" display-align="before" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="start" border-style="solid" border-width="1pt" border-color="white">
																					<fo:block>
																						<xsl:for-each select="SFLLL_2_0:SignedDate">
																							<fo:block keep-together="always"><fo:inline font-size="8px" font-style="normal" font-weight="bold">  Date: </fo:inline><fo:inline font-size="8px">
																								<xsl:value-of select="format-number(substring(.,6,2), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(substring(.,9,2), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(substring(.,1,4), '0000')"/>
																							</fo:inline></fo:block>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell background-color="silver" font-size="7pt" height="9pt" number-columns-spanned="3" text-align="left" width="30pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black" font-weight="bold">
															<fo:block>&#160; Federal Use Only:</fo:block>
														</fo:table-cell>
														<fo:table-cell font-size="6pt" height="9pt" text-align="right" width="30pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="black" font-weight="bold">
															<fo:block>Authorized for Local Reproduction<fo:block>
															</fo:block>Standard Form - LLL (Rev. 7-97)</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
