/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;

import java.util.ArrayList;
import java.util.List;

public abstract class BudgetBaseGenerator<T extends XmlObject> extends S2SBaseFormGenerator<T> implements S2SFormGeneratorPdfFillable<T> {

    private static final Logger LOG = LogManager.getLogger(BudgetV1_1Generator.class);
    private static final int BUDGET_ATTACHMENTS = 57;

    protected AttachedFileDataType[] getAttachedFileDataTypes() {
        LOG.debug("Getting AttachedFileDataType ");
        List<AttachedFileDataType> attachedFileDataTypes = new ArrayList<>();
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null
                    && Integer.parseInt(narrative.getNarrativeType().getCode()) == BUDGET_ATTACHMENTS ) {
                attachedFileDataType = addAttachedFileType(narrative);
                if (attachedFileDataType != null) {
                    attachedFileDataTypes.add(attachedFileDataType);
                    LOG.debug("Attachmentcount" + attachedFileDataTypes.size());
                }
            }
        }
        return attachedFileDataTypes.toArray(new AttachedFileDataType[0]);
    }
}
