/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.faithBasedSurveyOnEEOV12.SurveyOnEEODocument;
import gov.grants.apply.forms.faithBasedSurveyOnEEOV12.SurveyOnEEODocument.SurveyOnEEO;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityCfdaContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.Collections;
import java.util.List;

@FormGenerator("FaithBasedSurveyOnEEOV1_2Generator")
public class FaithBasedSurveyOnEEOV1_2Generator extends S2SBaseFormGenerator<SurveyOnEEODocument> implements S2SFormGeneratorPdfFillable<SurveyOnEEODocument> {

    @Value("http://apply.grants.gov/forms/FaithBased_SurveyOnEEO-V1.2")
    private String namespace;

    @Value("FaithBased_SurveyOnEEO-V1.2")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/FaithBased_SurveyOnEEO-V1.2.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/FaithBased_SurveyOnEEO-V1.2.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    private SurveyOnEEODocument getSurveyOnEEO() {

        SurveyOnEEODocument surveyOnEEODocument = SurveyOnEEODocument.Factory.newInstance();
        SurveyOnEEO surveyOnEEO = SurveyOnEEO.Factory.newInstance();
        surveyOnEEO.setFormVersion(FormVersion.v1_2.getVersion());

        ProposalSiteContract proposalSite = pdDoc.getDevelopmentProposal().getApplicantOrganization();
        if (proposalSite != null) {
            OrganizationContract organization = proposalSite.getOrganization();
            if (proposalSite.getLocationName() != null) {
                surveyOnEEO.setOrganizationName(StringUtils.substring(proposalSite.getLocationName(), 0, ORGANIZATON_NAME_MAX_LENGTH));
            }
            if (organization.getDunsNumber() != null) {
                if (organization.getDunsNumber().length() > DUNS_NUMBER_MAX_LENGTH) {
                    surveyOnEEO.setDUNSID(organization.getDunsNumber().substring(0, DUNS_NUMBER_MAX_LENGTH));
                }
                else {
                    surveyOnEEO.setDUNSID(organization.getDunsNumber());
                }
            }
        }
        S2sOpportunityContract s2sOpportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
        String opportunityTitle = "";
        if (s2sOpportunity != null) {
            opportunityTitle = s2sOpportunity.getOpportunityTitle();
            s2sOpportunity.getS2sOpportunityCfdas().stream().map(S2sOpportunityCfdaContract::getCfdaNumber).findFirst().ifPresent(surveyOnEEO::setCFDANumber);
        }
        surveyOnEEO.setOpportunityTitle(opportunityTitle);
        surveyOnEEODocument.setSurveyOnEEO(surveyOnEEO);
        return surveyOnEEODocument;
    }

    @Override
    public SurveyOnEEODocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {

        this.pdDoc = proposalDevelopmentDocument;
        return getSurveyOnEEO();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(SurveyOnEEODocument form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<SurveyOnEEODocument> factory() {
        return SurveyOnEEODocument.Factory;
    }
}
