/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudget14V14.RRBudget14Document;
import gov.grants.apply.forms.rrBudget14V14.RRBudget14Document.RRBudget14;
import gov.grants.apply.forms.rrSubawardBudget14V14.RRSubawardBudget14Document;
import gov.grants.apply.forms.rrSubawardBudget14V14.RRSubawardBudget14Document.RRSubawardBudget14;
import gov.grants.apply.forms.rrSubawardBudget14V14.RRSubawardBudget14Document.RRSubawardBudget14.BudgetAttachments;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@FormGenerator("RRSubAwardBudget1_4V1_4Generator")
public class RRSubAwardBudget1_4V1_4Generator extends S2SAdobeFormAttachmentBaseGenerator<RRSubawardBudget14Document> implements S2SFormGeneratorPdfFillable<RRSubawardBudget14Document> {

    private static final String RR_BUDGET1_4_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget_1_4-V1.4";
    private static final String RR_BUDGET1_4_LOCAL_NAME = "RR_Budget_1_4";

    @Value("http://apply.grants.gov/forms/RR_SubawardBudget_1_4-V1.4")
    private String namespace;

    @Value("RR_SubawardBudget_1_4")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SubawardBudget-V1.4.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_SubawardBudget_1_4-V1.4.pdf")
    private Resource pdfForm;

    @Value("177")
    private int sortIndex;

    private RRSubawardBudget14Document getRRSubawardBudgetDocument() throws S2SException  {

        RRSubawardBudget14Document rrSubawardBudgetDocument = RRSubawardBudget14Document.Factory.newInstance();
        RRSubawardBudget14 rrSubawardBudget = RRSubawardBudget14.Factory.newInstance();
        BudgetAttachments budgetAttachments = BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = getBudgetSubAwards(pdDoc,RR_BUDGET1_4_NAMESPACE_URI,false);
        List<RRBudget14> budgetList = new ArrayList<>();
        rrSubawardBudget.setFormVersion(FormVersion.v1_4.getVersion());

        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            final RRBudget14Document rrBudgetDocument = getRRBudget10(budgetSubAwards);
            if (rrBudgetDocument != null) {
               final  RRBudget14 rrBudget = rrBudgetDocument.getRRBudget14();

                switch (attCount) {
                    case 1:
                        rrSubawardBudget.setATT1(prepareAttName(budgetSubAwards));
                        budgetList.add(0, rrBudget);
                        break;
                    case 2:
                        rrSubawardBudget.setATT2(prepareAttName(budgetSubAwards));
                        budgetList.add(1, rrBudget);
                        break;
                    case 3:
                        rrSubawardBudget.setATT3(prepareAttName(budgetSubAwards));
                        budgetList.add(2, rrBudget);
                        break;
                    case 4:
                        rrSubawardBudget.setATT4(prepareAttName(budgetSubAwards));
                        budgetList.add(3, rrBudget);
                        break;
                    case 5:
                        rrSubawardBudget.setATT5(prepareAttName(budgetSubAwards));
                        budgetList.add(4, rrBudget);
                        break;
                    case 6:
                        rrSubawardBudget.setATT6(prepareAttName(budgetSubAwards));
                        budgetList.add(5, rrBudget);
                        break;
                    case 7:
                        rrSubawardBudget.setATT7(prepareAttName(budgetSubAwards));
                        budgetList.add(6, rrBudget);
                        break;
                    case 8:
                        rrSubawardBudget.setATT8(prepareAttName(budgetSubAwards));
                        budgetList.add(7, rrBudget);
                        break;
                    case 9:
                        rrSubawardBudget.setATT9(prepareAttName(budgetSubAwards));
                        budgetList.add(8, rrBudget);
                        break;
                    case 10:
                        rrSubawardBudget.setATT10(prepareAttName(budgetSubAwards));
                        budgetList.add(9, rrBudget);
                        break;
                }
                addSubAwdAttachments(budgetSubAwards);
                attCount++;
            }
            
        }
        budgetAttachments.setRRBudget14Array(budgetList.toArray(new RRBudget14[0]));
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRSubawardBudget14(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRBudget14Document getRRBudget10(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        final RRBudget14Document rrBudget;
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = stringToDom(subAwdXML);

        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_BUDGET1_4_NAMESPACE_URI, RR_BUDGET1_4_LOCAL_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null){
            if(subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }


        byte[] subAwdNodeBytes = docToBytes(nodeToDom(subAwdNode));

        try {
            rrBudget = RRBudget14Document.Factory.parse(new ByteArrayInputStream(subAwdNodeBytes));
        } catch (XmlException|IOException e) {
            throw new RuntimeException(e);
        }

        return rrBudget;
    }

    @Override
    public RRSubawardBudget14Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        pdDoc=proposalDevelopmentDocument;
        return getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(RRSubawardBudget14Document form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRSubawardBudget14Document> factory() {
        return RRSubawardBudget14Document.Factory;
    }
}
