<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet xmlns:PHSHumanSubjectsAndClinicalTrialsInfo_3_0="http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_3_0-V3.0"
				xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
				version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  
				xmlns:fo="http://www.w3.org/1999/XSL/Format"
				xmlns:grant="http://apply.grants.gov/system/MetaGrantApplication" 
				xmlns:HumanSubjectStudy_3_0="http://apply.grants.gov/forms/HumanSubjectStudy_3_0-V3.0"
				xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
				xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" 
				xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" 
				xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" 
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:header="http://apply.grants.gov/system/Header-V1.0">
	
	<xsl:param name="govTrackingNumber" />
	<xsl:param name="opportunityID" />
	<xsl:param name="receivedDateTime" />
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:template match="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:PHSHumanSubjectsAndClinicalTrialsInfo_3_0">
		<fo:root>
			<fo:layout-master-set> 
				<fo:simple-page-master master-name="first" 
					page-height="11in" page-width="8.5in" margin-left="0.2in" 
					margin-right="0.2in"> 
					<fo:region-body margin-top="0.5in" margin-bottom="0.6in" /> 
					<fo:region-before region-name="region-before-first" 
						extent="0.1in" /> 
					<fo:region-after region-name="region-after-all" 
						extent="0.6in" />
				</fo:simple-page-master>
				<fo:simple-page-master master-name="rest"
					page-height="11in" page-width="8.5in" margin-left="0.2in"
					margin-right="0.2in">
					<fo:region-body margin-top="0.5in" margin-bottom="0.6in" />
					<fo:region-after region-name="region-after-all"
						extent="0.6in" />
				</fo:simple-page-master>
 
				<fo:page-sequence-master master-name="all-pages">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference
							master-reference="first" page-position="first" />
						<fo:conditional-page-master-reference
							master-reference="rest" page-position="rest" />
					</fo:repeatable-page-master-alternatives>
				</fo:page-sequence-master>
			</fo:layout-master-set> 
			
			<fo:page-sequence master-reference="all-pages" initial-page-number="1" format="1">
											
				<fo:static-content flow-name="region-after-all">
					<fo:table width="100%" space-before.optimum="0pt"
						space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-body> 
						<!--  -->
							<fo:table-row>
								<fo:table-cell hyphenate="true" language="en"
									padding-start="0pt" padding-end="0pt" padding-before="1pt"
									padding-after="1pt" display-align="before" text-align="left"
									border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Tracking Number: 
											<xsl:value-of select="$govTrackingNumber" />
										</fo:inline>
									</fo:block>
								</fo:table-cell> 
								<fo:table-cell hyphenate="true" language="en" 
									line-height="9pt" padding-start="0pt" padding-end="0pt" 
									padding-before="1pt" padding-after="1pt" display-align="before" 
									text-align="right" border-style="solid" border-width="0pt" 
									border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Funding Opportunity Number:
											<xsl:value-of select="$opportunityID" />
										</fo:inline>
										<fo:inline font-size="8px">
											Received Date: 
											<xsl:value-of select="$receivedDateTime" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>			
			
		
			
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
							<xsl:call-template name="phsClinicalTrialDelayedOnsetStudyTemplate" />
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
			
		</fo:root>
	</xsl:template>
	
	<xsl:template name="phsClinicalTrialDelayedOnsetStudyTemplate">
					<!-- table which should have all the attachment listings -->
				<fo:table font-size="12pt" width="100%"
						space-before.optimum="1pt" space-after.optimum="1pt" table-layout="fixed"
						height="100%">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />

						<fo:table-body start-indent="20pt">											                  
								<fo:table-row>
									<fo:table-cell hyphenate="true" language="en"
										line-height="11pt" number-columns-spanned="13" padding-before="2pt" padding-after="2pt"
										 text-align="left" border-style="solid"
										border-width="1pt" border-color="white">
										<fo:block>
											<fo:inline font-size="9px" font-weight="bold">
												Delayed Onset Studies
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell hyphenate="true" language="en"
										line-height="11pt" number-columns-spanned="13" padding-before="2pt" padding-after="2pt" padding-start="1pt"
										 text-align="left" border-style="solid"
										border-width="1pt" border-color="white">
										<fo:block>
											<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt" table-layout="fixed"  border-style="solid">
																		<fo:table-column column-width="10%"/> 
																		<fo:table-column column-width="50%"/> 
																		<fo:table-column column-width="15%"/> 
																		<fo:table-column column-width="25%"/>
																		 <fo:table-header start-indent="0pt">
																			  <fo:table-cell padding="2pt"  border-style="solid">
													                             	<fo:block font-weight="bold" font-size="8px"> Delayed Onset Study#</fo:block>
													                          </fo:table-cell>
													                          <fo:table-cell padding="2pt"  border-style="solid">
													                           		<fo:block font-weight="bold" font-size="8px"> Study Title</fo:block>
													                          </fo:table-cell>
													                           <fo:table-cell padding="2pt"  border-style="solid">
													                                 <fo:block font-weight="bold" font-size="8px">Anticipated Clinical Trial?</fo:block>
													                           </fo:table-cell>	
													                           <fo:table-cell padding="2pt"  border-style="solid">
													                                 <fo:block font-weight="bold" font-size="8px">Justification</fo:block>
													                           </fo:table-cell>				 	
																		 </fo:table-header>
																			<fo:table-body start-indent="0pt">
																				<xsl:variable name="length" select="count(PHSHumanSubjectsAndClinicalTrialsInfo_3_0:DelayedOnsetStudy)"/>
																				<xsl:if test="$length = 0">
																				<fo:table-cell padding="2pt"  number-columns-spanned="3">
													                           			<fo:block font-size="8px">The form does not have any delayed onset studies</fo:block>
													                          	</fo:table-cell>
																		</xsl:if>
																		<xsl:for-each select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:DelayedOnsetStudy">
																				<xsl:variable name="i" select="position()" />
																				<fo:table-row>
																					<fo:table-cell padding="2pt"  border-style="solid">
															                             <fo:block font-size="8px"><xsl:value-of select='$i'/></fo:block>
															                            </fo:table-cell>
															                          <fo:table-cell padding="2pt"  border-style="solid">
															                            <fo:block font-size="8px"><xsl:value-of select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:StudyTitle"/></fo:block>
															                            </fo:table-cell>
															                          <fo:table-cell padding="2pt" text-align="center"  border-style="solid">
																						<xsl:choose>
																							<xsl:when
																								test="normalize-space(PHSHumanSubjectsAndClinicalTrialsInfo_3_0:AnticipatedClinicalTrial) = 'Y: Yes'">
																	                            <fo:block font-size="8px">Yes</fo:block>
																							</xsl:when>
																							<xsl:when
																								test="normalize-space(PHSHumanSubjectsAndClinicalTrialsInfo_3_0:AnticipatedClinicalTrial) = 'N: No'">
																	                            <fo:block font-size="8px">No</fo:block>
																							</xsl:when>
																							<xsl:when
																								test="normalize-space(PHSHumanSubjectsAndClinicalTrialsInfo_3_0:AnticipatedClinicalTrial) = ''">
																	                            <fo:block font-size="8px"></fo:block>
																							</xsl:when>
																						</xsl:choose>
															                          </fo:table-cell>
															                          <fo:table-cell padding="2pt" space-after.optimum="1pt"  border-style="solid" hyphenate="true">
															                            <fo:block font-size="8px" wrap-option="wrap" linefeed-treatment="preserve" white-space-treatment="preserve" white-space-collapse="false">
																									<xsl:call-template name="intersperse-with-zero-spaces">
																									<xsl:with-param name="str"
																										select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:Justification/PHSHumanSubjectsAndClinicalTrialsInfo_3_0:attFile/att:FileName" />
																									</xsl:call-template>
																						</fo:block>
															                           </fo:table-cell>
																	</fo:table-row>
																</xsl:for-each>
																			 
														</fo:table-body>
												</fo:table>															
										</fo:block>
									</fo:table-cell>
								</fo:table-row>																				                                                                 
			               </fo:table-body>
						</fo:table>
						
<!-- adding space between gap -->
				
	</xsl:template>
		<xsl:template name="string-replace">
		        <xsl:param name="str"/>
		        <xsl:param name="gap"/>		        
		        <xsl:choose>
		            <xsl:when test="string-length($str) > $gap">
		                <xsl:value-of select="substring($str,1,$gap)"/>
		                <xsl:value-of select="' '"/>		                
		                <xsl:call-template name="string-replace">
		                    <xsl:with-param name="str" select="substring($str,$gap + 1)"/>
		                    <xsl:with-param name="gap" select="$gap"/>
		                </xsl:call-template>
		            </xsl:when>
		            <xsl:otherwise>
		                <xsl:value-of select="$str"/>
		            </xsl:otherwise>
		        </xsl:choose>
		    </xsl:template>

	<!--  
	Create checkboxes with display text, ${checkbox_text}, and assign the value, ${checkbox_value}
	If the checkbox value is contained in ExemptionNumber Node, the checkbox is marked off
	 -->
	<xsl:template name="anticipated_text">
		<xsl:param name="checkbox_value" />
		<fo:table-cell hyphenate="true" language="en" padding-start="0pt" padding-end="0pt" padding-before="0pt"
		padding-after="0pt" display-align="before" text-align="start"
		border-style="solid" border-width="0pt" border-color="white">
			<fo:block font-size="9px">
				<fo:inline font-family="ZapfDingbats">&#x274F;</fo:inline>
				<fo:block-container keep-together="always"
					position="absolute">
					<fo:block>
						<xsl:choose>
							<xsl:when
								test="normalize-space($checkbox_value) = 'Y: Yes'">
								<fo:inline font-family="ZapfDingbats" font-size="8pt">&#x2714;
								</fo:inline>
							</xsl:when>
						</xsl:choose>
					</fo:block>
				</fo:block-container>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<xsl:template name="intersperse-with-zero-spaces">
		<xsl:param name="str" />
		<xsl:variable name="spacechars">
		</xsl:variable>

		<xsl:if test="string-length($str) > 0">
			<xsl:variable name="c1" select="substring($str, 1, 1)" />

			<xsl:value-of select="$c1" />
			<xsl:text>​&#8203;</xsl:text>

			<xsl:call-template name="intersperse-with-zero-spaces">
				<xsl:with-param name="str" select="substring($str, 2)" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
   
 
</xsl:stylesheet>
