/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.impl.util;

import org.kuali.coeus.s2sgen.api.core.AuditError;

public final class UnsupportedOtherCostsErrorBuilder {

    private UnsupportedOtherCostsErrorBuilder() {
        throw new UnsupportedOperationException("do not call");
    }

    public static AuditError build(int numSupportedOtherCosts) {
        String builder = "This form only supports " +
                numSupportedOtherCosts +
                " other direct costs categories. Please adjust your categories.";
        return new AuditError(AuditError.NO_FIELD_ERROR_KEY, builder, AuditError.GG_LINK);
    }
}
