/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.edSF424Supplement20V20.EDSF424Supplement20Document;
import gov.grants.apply.forms.edSF424Supplement20V20.EDSF424Supplement20Document.EDSF424Supplement20;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoNotApplicableDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewExemptionContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

/**
 *
 * This class is used to generate XML Document object for grants.gov
 * EDSF424SupplementV2.0 This form is generated using XMLBean API's generated
 * by compiling EDSF424SupplementV2.0 schema.
 *
 */
@FormGenerator("EDSF424SupplementV2_0Generator")
public class EDSF424SupplementV2_0Generator extends
        EDSF424SupplementBaseGenerator<EDSF424Supplement20Document> implements S2SFormGeneratorPdfFillable<EDSF424Supplement20Document> {

    @Value("http://apply.grants.gov/forms/ED_SF424_Supplement_2_0-V2.0")
    private String namespace;

    @Value("ED_SF424_Supplement_2_0-V2.0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_SF424_Supplement-V2.0.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ED_SF424_Supplement_2_0-V2.0.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    @Autowired
    @Qualifier("s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

    private EDSF424Supplement20Document getEDSF424Supplement() {

        EDSF424Supplement20Document edsF424Supplement20Document = EDSF424Supplement20Document.Factory
                .newInstance();
        EDSF424Supplement20 edsf424Supplement = EDSF424Supplement20.Factory
                .newInstance();
        edsf424Supplement.setFormVersion(FormVersion.v2_0.getVersion());
        ProposalPersonContract pi = getS2SProposalPersonService().getPrincipalInvestigator(pdDoc);
        edsf424Supplement.setProjectDirector(globLibV20Generator.getContactPersonDataTypeV3(pi));
        setQuestionnaireAnswers(edsf424Supplement);
        setHumanSubjectsInformation(edsf424Supplement);
        setNarratives(edsf424Supplement);
        edsF424Supplement20Document.setEDSF424Supplement20(edsf424Supplement);
        return edsF424Supplement20Document;
    }

    private void setHumanSubjectsInformation(EDSF424Supplement20 edsf424Supplement) {
        edsf424Supplement.setIsHumanResearch(YesNoDataType.N_NO);
        boolean areSpecialReviewsPresent = Boolean.FALSE;
        for (ProposalSpecialReviewContract specialReview : pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (specialReview.getSpecialReviewType() != null && specialReview.getSpecialReviewType().getCode().equals(SPECIAL_REVIEW_CODE)) {
                edsf424Supplement.setIsHumanResearch(YesNoDataType.Y_YES);
                if (specialReview.getApprovalType() != null && specialReview.getApprovalType().getCode().equals(APPROVAL_TYPE_CODE)) {
                    edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.Y_YES);
                    areSpecialReviewsPresent = Boolean.TRUE;

                    if (specialReview.getSpecialReviewExemptions() != null && specialReview.getSpecialReviewExemptions().size() > 0) {
                        for (ProposalSpecialReviewExemptionContract exemption : specialReview.getSpecialReviewExemptions()) {
                            switch (exemption.getExemptionType().getCode()) {
                                case "1" : edsf424Supplement.setExemptionNumber1(YesNoDataType.Y_YES);
                                    break;
                                case "2" : edsf424Supplement.setExemptionNumber2(YesNoDataType.Y_YES);
                                    break;
                                case "3" : edsf424Supplement.setExemptionNumber3(YesNoDataType.Y_YES);
                                    break;
                                case "4" : edsf424Supplement.setExemptionNumber4(YesNoDataType.Y_YES);
                                    break;
                                case "5" : edsf424Supplement.setExemptionNumber5(YesNoDataType.Y_YES);
                                    break;
                                case "6" : edsf424Supplement.setExemptionNumber6(YesNoDataType.Y_YES);
                                    break;
                            }
                        }
                    }
                }
            }
        }
        if (!areSpecialReviewsPresent) {
            populateAssuranceInformation(edsf424Supplement);
        }
    }

    protected void populateAssuranceInformation(EDSF424Supplement20 edsf424Supplement) {
        final OrganizationContract organization = pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.N_NO);
            if (organization.getHumanSubAssurance() != null) {
                edsf424Supplement.setAssuranceNumber(organization.getHumanSubAssurance());
            }
        }
    }

    private void setQuestionnaireAnswers(EDSF424Supplement20 edsf424Supplement) {
        String answer;
        final List<? extends AnswerContract> questionnaireAnswers = getPropDevQuestionAnswerService().getQuestionnaireAnswers(pdDoc.getDevelopmentProposal().getProposalNumber(),
                getNamespace(), getFormName());

        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionSeqId();
            if (answer != null) {
                if (PROPOSAL_YNQ_NOVICE_APPLICANT == questionId) {
                    if (YnqConstant.YES.code().equals(answer)) {
                        edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.Y_YES);
                    } else if (YnqConstant.NO.code().equals(answer)) {
                        edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.N_NO);
                    } else if (YnqConstant.NA.code().equals(answer)) {
                        edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.NA_NOT_APPLICABLE);
                    }
                }
            } else {
                edsf424Supplement.setIsNoviceApplicant(null);
            }

        }
    }

    protected void setNarratives(EDSF424Supplement20 edsf424Supplement) {

        final Optional<? extends NarrativeContract> edsf424SupplementNarrativeOptional = pdDoc.getDevelopmentProposal().getNarratives().stream()
                .filter(narrative -> narrative.getNarrativeType().getCode() != null && Integer.parseInt(narrative.getNarrativeType().getCode()) == NARRATIVE_TYPE_ED_SF424_SUPPLIMENT)
                .findFirst();

        if (edsf424SupplementNarrativeOptional.isPresent()) {
            final AttachedFileDataType attachment = addAttachedFileType(edsf424SupplementNarrativeOptional.get());
            if (attachment != null) {
                edsf424Supplement.setAttachment(attachment);
            }
        }
    }

    /**
     * This method creates {@link XmlObject} of type
     * {@link EDSF424Supplement20Document} by populating data from the given
     * {@link ProposalDevelopmentDocumentContract}
     *
     * @param proposalDevelopmentDocument
     *            for which the {@link XmlObject} needs to be created
     * @return {@link XmlObject} which is generated using the given
     *         {@link ProposalDevelopmentDocumentContract}
     */
    @Override
    public EDSF424Supplement20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        pdDoc = proposalDevelopmentDocument;
        return getEDSF424Supplement();
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(EDSF424Supplement20Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getEDSF424Supplement20().getAttachment() != null && a.getContentId().equals(form.getEDSF424Supplement20().getAttachment().getFileLocation().getHref())) {
                return entry("ED_SF424_Supplement_2_0_P1.optionalFile0", a);
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<EDSF424Supplement20Document> factory() {
        return EDSF424Supplement20Document.Factory;
    }
}
