/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.person;

import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;

import java.util.List;

public interface S2SProposalPersonService {

    /**
     *
     * This method limits the number of key persons to n, returns list of key persons.
     *
     * @param keyPersons
     *            list of {@link org.kuali.coeus.propdev.api.person.ProposalPersonContract}
     * @param n
     *            number of key persons that are considered as not extra persons
     * @return list of {@link org.kuali.coeus.propdev.api.person.ProposalPersonContract}
     */
    List<ProposalPersonContract> getNKeyPersons(List<? extends ProposalPersonContract> keyPersons, int n);

    /**
     *
     * This method is to get PrincipalInvestigator from person list
     *
     * @param pdDoc
     *            Proposal development document.
     * @return ProposalPerson PrincipalInvestigator for the proposal.
     */
    ProposalPersonContract getPrincipalInvestigator(
            ProposalDevelopmentDocumentContract pdDoc);

    /**
     * Finds all the co-investigators associated with the provided pdDoc.
     * @return List of Co-Investigators {@link org.kuali.coeus.propdev.api.person.ProposalPersonContract}.
     */

    List<ProposalPersonContract> getCoInvestigators(ProposalDevelopmentDocumentContract pdDoc);

    /**
     * Finds all the key Person associated with the provided pdDoc.
     * @return List of Key Persons {@link org.kuali.coeus.propdev.api.person.ProposalPersonContract}.
     */

    List<ProposalPersonContract> getKeyPersons (ProposalDevelopmentDocumentContract pdDoc);

    /**
     *
     * This method is used to get the citizenship from either warehouse or from person custom element
     */
    CitizenshipType getCitizenship(ProposalPersonContract proposalPerson);

    /**
     * Return the UEI of a proposal person, at this time will only return a value if the person
     * is a rolodex contact.
     * @return UEI from rolodex contact or null
     */
    String getPersonUei(ProposalPersonContract proposalPerson);
}
