/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jdbc.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.framework.persistence.jdbc.sql.Criteria;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.core.web.format.BooleanFormatter;

public class SqlBuilder {
    private static final Logger LOG = LogManager.getLogger(SqlBuilder.class);
    private DateTimeService dateTimeService;
    private DatabasePlatform dbPlatform;
    public static final String EMPTY_STRING = "";

    public static boolean isJoinClass(Class clazz) {
        return clazz.isAssignableFrom(JoinType.class);
    }

    public Criteria createCriteria(String columnName, String searchValue, String tableName, String tableAlias, Class propertyType) {
        return this.createCriteria(columnName, searchValue, tableName, tableAlias, propertyType, false, true);
    }

    public Criteria createCriteria(String columnName, String searchValue, String tableName, String tableAlias, Class propertyType, boolean caseInsensitive) {
        return this.createCriteria(columnName, searchValue, tableName, tableAlias, propertyType, caseInsensitive, true);
    }

    public Criteria createCriteria(String columnName, String searchValue, String tableName, String tableAlias, Class propertyType, boolean caseInsensitive, boolean allowWildcards) {
        if (propertyType == null) {
            return null;
        }
        Criteria criteria = new Criteria(tableName, tableAlias);
        criteria.setDbPlatform(this.getDbPlatform());
        this.addCriteria(columnName, searchValue, propertyType, caseInsensitive, allowWildcards, criteria);
        return criteria;
    }

    public void andCriteria(String columnName, String searchValue, String tableName, String tableAlias, Class propertyType, boolean caseInsensitive, boolean allowWildcards, Criteria addToThisCriteria) {
        Criteria crit = this.createCriteria(columnName, searchValue, tableName, tableAlias, propertyType, caseInsensitive, allowWildcards);
        addToThisCriteria.and(crit);
    }

    public void andCriteria(Criteria addToThisCriteria, Criteria newCriteria) {
        addToThisCriteria.and(newCriteria);
    }

    public void orCriteria(String columnName, String searchValue, String tableName, String tableAlias, Class propertyType, boolean caseInsensitive, boolean allowWildcards, Criteria addToThisCriteria) {
        Criteria crit = this.createCriteria(columnName, searchValue, tableName, tableAlias, propertyType, caseInsensitive, allowWildcards);
        addToThisCriteria.or(crit);
    }

    public void addCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, boolean allowWildcards, Criteria criteria) {
        if (SqlBuilder.isJoinClass(propertyType)) {
            String temp = SQLUtils.cleanString(propertyValue);
            criteria.eq((String)propertyName, temp, propertyType);
            return;
        }
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.OR.op())) {
            this.addOrCriteria((String)propertyName, propertyValue, propertyType, caseInsensitive, criteria, allowWildcards);
            return;
        }
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.AND.op())) {
            this.addAndCriteria((String)propertyName, propertyValue, propertyType, caseInsensitive, criteria, allowWildcards);
            return;
        }
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.NOT.op())) {
            this.addNotCriteria((String)propertyName, propertyValue, propertyType, caseInsensitive, criteria, allowWildcards);
            return;
        }
        if (TypeUtils.isStringClass((Class)propertyType)) {
            if (propertyValue != null && (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op()) || propertyValue.startsWith(">") || propertyValue.startsWith("<"))) {
                this.addStringRangeCriteria((String)propertyName, propertyValue, criteria, propertyType, caseInsensitive, allowWildcards);
            } else {
                if (caseInsensitive) {
                    propertyName = this.getDbPlatform().getUpperCaseFunction() + "(__JPA_ALIAS__." + (String)propertyName + ")";
                    propertyValue = propertyValue.toUpperCase();
                }
                criteria.like((String)propertyName, propertyValue, propertyType, allowWildcards);
            }
        } else if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
            this.addNumericRangeCriteria((String)propertyName, propertyValue, criteria, propertyType);
        } else if (TypeUtils.isTemporalClass((Class)propertyType)) {
            this.addDateRangeCriteria((String)propertyName, propertyValue, criteria, propertyType);
        } else if (TypeUtils.isBooleanClass((Class)propertyType)) {
            String temp = SQLUtils.cleanString(propertyValue);
            criteria.eq((String)propertyName, new BooleanFormatter().convertFromPresentationFormat((Object)temp), propertyType);
        } else {
            LOG.error("not adding criterion for: " + (String)propertyName + "," + String.valueOf(propertyType) + "," + propertyValue);
        }
    }

    private void addOrCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria, boolean allowWildcards) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.OR.op(), allowWildcards);
    }

    private void addAndCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria, boolean allowWildcards) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.AND.op(), allowWildcards);
    }

    private void addNotCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria, boolean allowWildcards) {
        Object[] splitPropVal = StringUtils.split((String)propertyValue, (String)SearchOperator.NOT.op());
        int strLength = splitPropVal.length;
        if (strLength == 0) {
            throw new IllegalArgumentException("Improper syntax of NOT operator in " + propertyName);
        }
        if (strLength > 1) {
            String expandedNot = String.valueOf(SearchOperator.NOT) + StringUtils.join((Object[])splitPropVal, (String)(SearchOperator.AND.op() + SearchOperator.NOT.op()));
            this.addCriteria(propertyName, expandedNot, propertyType, caseInsensitive, allowWildcards, criteria);
        } else if (TypeUtils.isDecimalClass((Class)propertyType)) {
            criteria.notEqual(propertyName, splitPropVal[0], propertyType, allowWildcards);
        } else {
            criteria.notLike(propertyName, splitPropVal[0], propertyType, allowWildcards);
        }
    }

    private void addLogicalOperatorCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria, String splitValue, boolean allowWildcards) {
        String[] splitPropVal = StringUtils.split((String)propertyValue, (String)splitValue);
        Criteria subCriteria = new Criteria("N/A");
        for (String element : splitPropVal) {
            Criteria predicate = new Criteria("N/A", criteria.getAlias());
            this.addCriteria(propertyName, element, propertyType, caseInsensitive, allowWildcards, predicate);
            if (splitValue == SearchOperator.OR.op()) {
                subCriteria.or(predicate);
            }
            if (splitValue != SearchOperator.AND.op()) continue;
            subCriteria.and(predicate);
        }
        criteria.and(subCriteria);
    }

    private Timestamp parseDate(String dateString) {
        dateString = dateString.trim();
        try {
            Timestamp dt = this.getDateTimeService().convertToSqlTimestamp(dateString);
            return dt;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public boolean isValidDate(String dateString) {
        try {
            this.createCriteria("date", dateString.trim(), "validation", "test", Date.class);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean containsRangeCharacters(String string) {
        boolean bRet = false;
        for (SearchOperator op : SearchOperator.RANGE_CHARACTERS) {
            if (!StringUtils.contains((String)string, (String)op.op())) continue;
            bRet = true;
        }
        return bRet;
    }

    private void addDateRangeCriteria(String propertyName, String propertyValue, Criteria criteria, Class propertyType) {
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
            String[] rangeValues = propertyValue.split("\\.\\.");
            if (rangeValues.length < 2) {
                throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
            }
            criteria.between(propertyName, this.parseDate(SQLUtils.cleanDate(rangeValues[0])), this.parseDate(this.cleanUpperBound(SQLUtils.cleanDate(rangeValues[1]))), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
            criteria.gte(propertyName, this.parseDate(SQLUtils.cleanDate(propertyValue)), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
            criteria.lte(propertyName, this.parseDate(this.cleanUpperBound(SQLUtils.cleanDate(propertyValue))), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
            criteria.gt(propertyName, this.parseDate(this.cleanUpperBound(SQLUtils.cleanDate(propertyValue))), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
            criteria.lt(propertyName, this.parseDate(SQLUtils.cleanDate(propertyValue)), propertyType);
        } else {
            String sDate = this.convertSimpleDateToDateRange(SQLUtils.cleanDate(propertyValue));
            if (sDate.contains(SearchOperator.BETWEEN.op())) {
                this.addDateRangeCriteria(propertyName, sDate, criteria, propertyType);
            } else {
                criteria.eq(propertyName, this.parseDate(sDate), propertyType);
            }
        }
    }

    public static boolean isValidNumber(String value) {
        try {
            SqlBuilder.stringToBigDecimal(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String cleanNumeric(String value) {
        Object cleanedValue = value.replaceAll("[^-0-9.]", EMPTY_STRING);
        if (((String)cleanedValue).lastIndexOf(45) > 0) {
            cleanedValue = ((String)cleanedValue).charAt(0) == '-' ? "-" + ((String)cleanedValue).replaceAll("-", EMPTY_STRING) : ((String)cleanedValue).replaceAll("-", EMPTY_STRING);
        }
        int decimalLoc = ((String)cleanedValue).lastIndexOf(46);
        if (((String)cleanedValue).indexOf(46) != decimalLoc) {
            cleanedValue = ((String)cleanedValue).substring(0, decimalLoc).replaceAll("\\.", EMPTY_STRING) + ((String)cleanedValue).substring(decimalLoc);
        }
        return cleanedValue;
    }

    public static BigDecimal stringToBigDecimal(String value) {
        return new BigDecimal(SqlBuilder.cleanNumeric(value));
    }

    private void addNumericRangeCriteria(String propertyName, String propertyValue, Criteria criteria, Class propertyType) {
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
            String[] rangeValues = propertyValue.split("\\.\\.");
            if (rangeValues.length < 2) {
                throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
            }
            criteria.between(propertyName, SqlBuilder.stringToBigDecimal(rangeValues[0]), SqlBuilder.stringToBigDecimal(rangeValues[1]), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
            criteria.gte(propertyName, SqlBuilder.stringToBigDecimal(propertyValue), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
            criteria.lte(propertyName, SqlBuilder.stringToBigDecimal(propertyValue), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
            criteria.gt(propertyName, SqlBuilder.stringToBigDecimal(propertyValue), propertyType);
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
            criteria.lt(propertyName, SqlBuilder.stringToBigDecimal(propertyValue), propertyType);
        } else {
            criteria.eq(propertyName, SqlBuilder.stringToBigDecimal(propertyValue), propertyType);
        }
    }

    private void addStringRangeCriteria(String propertyName, String propertyValue, Criteria criteria, Class propertyType, boolean caseInsensitive, boolean allowWildcards) {
        if (StringUtils.contains((String)propertyValue, (String)SearchOperator.BETWEEN.op())) {
            String[] rangeValues = propertyValue.split("\\.\\.");
            if (rangeValues.length < 2) {
                throw new IllegalArgumentException("Improper syntax of BETWEEN operator in " + propertyName);
            }
            propertyName = this.getCaseAndLiteralPropertyName(propertyName, caseInsensitive);
            String val1 = this.getCaseAndLiteralPropertyValue(rangeValues[0], caseInsensitive, allowWildcards);
            String val2 = this.getCaseAndLiteralPropertyValue(rangeValues[1], caseInsensitive, allowWildcards);
            criteria.between(propertyName, val1, val2, propertyType);
        } else {
            propertyName = this.getCaseAndLiteralPropertyName(propertyName, caseInsensitive);
            String value = this.getCaseAndLiteralPropertyValue(SQLUtils.cleanString(propertyValue), caseInsensitive, allowWildcards);
            if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
                criteria.gte(propertyName, value, propertyType);
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
                criteria.lte(propertyName, value, propertyType);
            } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
                criteria.gt(propertyName, value, propertyType);
            } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
                criteria.lt(propertyName, value, propertyType);
            }
        }
    }

    private String getCaseAndLiteralPropertyName(String propertyName, boolean caseInsensitive) {
        if (caseInsensitive) {
            propertyName = this.getDbPlatform().getUpperCaseFunction() + "(__JPA_ALIAS__." + (String)propertyName + ")";
        }
        return propertyName;
    }

    private String getCaseAndLiteralPropertyValue(String propertyValue, boolean caseInsensitive, boolean allowWildcards) {
        if (caseInsensitive) {
            propertyValue = propertyValue.toUpperCase();
        }
        return propertyValue;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)GlobalResourceLoader.getService((String)"dateTimeService");
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DatabasePlatform getDbPlatform() {
        if (this.dbPlatform == null) {
            this.dbPlatform = (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
        }
        return this.dbPlatform;
    }

    public void setDbPlatform(DatabasePlatform dbPlatform) {
        this.dbPlatform = dbPlatform;
    }

    private String cleanUpperBound(String stringDate) {
        Timestamp dt;
        try {
            dt = this.getDateTimeService().convertToSqlTimestamp((String)stringDate);
        }
        catch (ParseException e) {
            throw new SQLBuilderException(e);
        }
        SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
        if ("00:00:00".equals(sdfTime.format(dt)) && !StringUtils.contains((String)stringDate, (String)"00:00:00") && !StringUtils.contains((String)stringDate, (String)"12:00 AM")) {
            stringDate = (String)stringDate + " 23:59:59";
        }
        return stringDate;
    }

    private String convertSimpleDateToDateRange(String stringDate) {
        Timestamp dt;
        try {
            dt = this.getDateTimeService().convertToSqlTimestamp((String)stringDate);
        }
        catch (ParseException e) {
            throw new SQLBuilderException(e);
        }
        SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
        if ("00:00:00".equals(sdfTime.format(dt)) && !StringUtils.contains((String)stringDate, (String)"00:00:00") && !StringUtils.contains((String)stringDate, (String)"12:00 AM")) {
            stringDate = (String)stringDate + " .. " + (String)stringDate + " 23:59:59";
        }
        return stringDate;
    }

    public static final class JoinType {
    }

    public static final class SQLBuilderException
    extends RiceRuntimeException {
        public SQLBuilderException(Throwable t) {
            super(t);
        }
    }
}

