/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.resourceloader;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SpringResourceLoader
extends BaseResourceLoader {
    private SpringResourceLoader parentSpringResourceLoader;
    private ApplicationContext parentContext;
    private ConfigurableApplicationContext context;
    private ServletContext servletContextcontext;
    private final List<String> fileLocs;

    public SpringResourceLoader(QName name, String fileLoc, ServletContext context) {
        this(name, Collections.singletonList(fileLoc), context);
    }

    public SpringResourceLoader(QName name, List<String> fileLocs, ServletContext servletContextcontext) {
        super(name);
        this.fileLocs = fileLocs;
        this.servletContextcontext = servletContextcontext;
    }

    @Override
    public Object getService(QName serviceName) {
        if (!this.isStarted()) {
            return null;
        }
        if (this.getContext().containsBean(serviceName.toString())) {
            Object service = this.getContext().getBean(serviceName.toString());
            return this.postProcessService(serviceName, service);
        }
        return super.getService(serviceName);
    }

    @Override
    public void start() throws Exception {
        if (!this.isStarted()) {
            LOG.info("Creating Spring context " + StringUtils.join(this.fileLocs, (String)","));
            if (this.parentSpringResourceLoader != null && this.parentContext != null) {
                throw new ConfigurationException("Both a parentSpringResourceLoader and parentContext were defined.  Only one can be defined!");
            }
            if (this.parentSpringResourceLoader != null) {
                this.parentContext = this.parentSpringResourceLoader.getContext();
            }
            if (this.servletContextcontext != null) {
                XmlWebApplicationContext lContext = new XmlWebApplicationContext();
                lContext.setServletContext(this.servletContextcontext);
                lContext.setParent(this.parentContext);
                lContext.setConfigLocations(this.fileLocs.toArray(new String[0]));
                lContext.refresh();
                this.context = lContext;
            } else {
                this.context = new ClassPathXmlApplicationContext(this.fileLocs.toArray(new String[0]), this.parentContext);
            }
            super.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.context != null) {
            LOG.info("Stopping Spring context " + StringUtils.join(this.fileLocs, (String)","));
            this.context.close();
        }
        super.stop();
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public void setParentSpringResourceLoader(SpringResourceLoader parentSpringResourceLoader) {
        this.parentSpringResourceLoader = parentSpringResourceLoader;
    }

    @Override
    public String getContents(String indent, boolean servicePerLine) {
        Object contents = "";
        for (String name : this.context.getBeanDefinitionNames()) {
            contents = servicePerLine ? (String)contents + indent + "+++" + name + "\n" : (String)contents + name + ", ";
        }
        return contents;
    }
}

