/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import javax.xml.namespace.QName;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

final class DocumentRefreshQueueAsyncCapableImpl
implements DocumentRefreshQueue {
    private final AsyncCapableService asyncCapableService;
    private final DocumentRefreshQueue documentRefreshQueue;
    private final QName qname;
    private final String applicationId;

    DocumentRefreshQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, DocumentRefreshQueue documentRefreshQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }
        if (documentRefreshQueue == null) {
            throw new IllegalArgumentException("documentRefreshQueue is null");
        }
        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }
        this.asyncCapableService = asyncCapableService;
        this.documentRefreshQueue = documentRefreshQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    public void refreshDocument(String documentId) throws RiceIllegalArgumentException {
        this.asyncCapableService.executeCall(this.qname, this.applicationId, documentId, null, new CallMetadata("refreshDocument", new Class[]{String.class}, new Object[]{documentId}), () -> this.documentRefreshQueue.refreshDocument(documentId));
    }
}

