/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actionrequest.service.impl.NotificationSuppression;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.impl.document.DocumentRefreshQueueAsyncCapableImpl;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

public class DocumentRefreshQueueImpl
implements DocumentRefreshQueue,
AsyncWrappable<DocumentRefreshQueue> {
    private AsyncCapableService asyncCapableService;
    private RouteHelper helper = new RouteHelper();

    public void refreshDocument(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId is null or blank");
        }
        PerformanceLogger performanceLogger = new PerformanceLogger();
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId);
        List<RouteNodeInstance> activeNodes = this.getRouteNodeService().getActiveNodeInstances(documentId);
        ArrayList<ActionRequestValue> requestsToDelete = new ArrayList<ActionRequestValue>();
        NotificationSuppression notificationSuppression = new NotificationSuppression();
        for (RouteNodeInstance nodeInstance : activeNodes) {
            if (!this.helper.isRequestActivationNode(nodeInstance.getRouteNode())) continue;
            List<ActionRequestValue> deletesForThisNode = this.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(documentId, nodeInstance.getRouteNodeInstanceId());
            for (ActionRequestValue deleteForThisNode : deletesForThisNode) {
                boolean containsRoleOrRuleRequests = deleteForThisNode.isRouteModuleRequest();
                if (!containsRoleOrRuleRequests && CollectionUtils.isNotEmpty(deleteForThisNode.getChildrenRequests())) {
                    containsRoleOrRuleRequests = deleteForThisNode.getChildrenRequests().get(0).isRouteModuleRequest();
                }
                if (!containsRoleOrRuleRequests) continue;
                requestsToDelete.add(deleteForThisNode);
                notificationSuppression.addNotificationSuppression(nodeInstance, deleteForThisNode);
            }
            nodeInstance.setInitial(true);
            this.getRouteNodeService().save(nodeInstance);
        }
        for (ActionRequestValue requestToDelete : requestsToDelete) {
            this.getActionRequestService().deleteActionRequestGraphNoOutbox(requestToDelete);
        }
        try {
            OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.STANDARD);
            KEWServiceLocator.getWorkflowEngineFactory().newEngine(config).process(documentId);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        performanceLogger.log("Time to run DocumentRequeuer for document " + documentId);
    }

    private ActionRequestService getActionRequestService() {
        return KEWServiceLocator.getActionRequestService();
    }

    private RouteNodeService getRouteNodeService() {
        return KEWServiceLocator.getRouteNodeService();
    }

    public DocumentRefreshQueue wrap(QName qname, String applicationId) {
        return new DocumentRefreshQueueAsyncCapableImpl(this.asyncCapableService, this, qname, applicationId);
    }

    public AsyncCapableService getAsyncCapableService() {
        return this.asyncCapableService;
    }

    public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
        this.asyncCapableService = asyncCapableService;
    }
}

