/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.configuration.impl;

import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheDefaultImpl;
import org.apache.ojb.broker.core.PBPoolConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.IndirectionHandlerJDKImpl;
import org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyConfiguration;
import org.apache.ojb.broker.core.proxy.ProxyFactory;
import org.apache.ojb.broker.core.proxy.ProxyFactoryJDKImpl;
import org.apache.ojb.broker.core.proxy.SetProxyDefaultImpl;
import org.apache.ojb.broker.metadata.MetadataConfiguration;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDirectImpl;
import org.apache.ojb.broker.util.configuration.impl.ConfigurationAbstractImpl;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.collections.DListImpl;

public class OjbConfiguration
extends ConfigurationAbstractImpl
implements OdmgConfiguration,
PersistenceBrokerConfiguration,
ProxyConfiguration,
PBPoolConfiguration,
MetadataConfiguration {
    public static final String OJB_PROPERTIES_FILE = "OJB.properties";
    public static final String OJB_METADATA_FILE = "repository.xml";
    private String repositoryFilename;
    private Class objectCacheClass;
    private Class persistentFieldClass;
    private Class persistenceBrokerClass;
    private Class listProxyClass;
    private Class setProxyClass;
    private Class collectionProxyClass;
    private Class indirectionHandlerClass;
    private Class proxyFactoryClass;
    private int sqlInLimit;
    private int maxActive;
    private int maxIdle;
    private long maxWait;
    private long timeBetweenEvictionRunsMillis;
    private long minEvictableIdleTimeMillis;
    private byte whenExhaustedAction;
    private boolean useImplicitLocking;
    private boolean lockAssociationAsWrites;
    private Class oqlCollectionClass;
    private boolean useSerializedRepository;

    @Override
    public boolean useSerializedRepository() {
        return this.useSerializedRepository;
    }

    @Override
    public boolean lockAssociationAsWrites() {
        return this.lockAssociationAsWrites;
    }

    @Override
    public String getRepositoryFilename() {
        return this.repositoryFilename;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public long getMaxWaitMillis() {
        return this.maxWait;
    }

    @Override
    public long getTimeBetweenEvictionRunsMilli() {
        return this.timeBetweenEvictionRunsMillis;
    }

    @Override
    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    @Override
    public byte getWhenExhaustedAction() {
        return this.whenExhaustedAction;
    }

    @Override
    public Class getObjectCacheClass() {
        return this.objectCacheClass;
    }

    @Override
    public Class getOqlCollectionClass() {
        return this.oqlCollectionClass;
    }

    @Override
    public Class getPersistentFieldClass() {
        return this.persistentFieldClass;
    }

    @Override
    public Class getPersistenceBrokerClass() {
        return this.persistenceBrokerClass;
    }

    @Override
    public Class getIndirectionHandlerClass() {
        return this.indirectionHandlerClass;
    }

    @Override
    public Class getListProxyClass() {
        return this.listProxyClass;
    }

    @Override
    public Class getSetProxyClass() {
        return this.setProxyClass;
    }

    @Override
    public Class getCollectionProxyClass() {
        return this.collectionProxyClass;
    }

    @Override
    public Class getProxyFactoryClass() {
        return this.proxyFactoryClass;
    }

    @Override
    protected void load() {
        String string = System.getProperty(OJB_PROPERTIES_FILE, OJB_PROPERTIES_FILE);
        this.setFilename(string);
        super.load();
        this.repositoryFilename = this.getString("repositoryFile", OJB_METADATA_FILE);
        this.objectCacheClass = this.getClass("ObjectCacheClass", ObjectCacheDefaultImpl.class, ObjectCache.class);
        this.persistentFieldClass = this.getClass("PersistentFieldClass", PersistentFieldDirectImpl.class, PersistentField.class);
        this.persistenceBrokerClass = this.getClass("PersistenceBrokerClass", PersistenceBrokerImpl.class, PersistenceBroker.class);
        this.listProxyClass = this.getClass("ListProxyClass", ListProxyDefaultImpl.class);
        this.setProxyClass = this.getClass("SetProxyClass", SetProxyDefaultImpl.class);
        this.collectionProxyClass = this.getClass("CollectionProxyClass", CollectionProxyDefaultImpl.class);
        this.indirectionHandlerClass = this.getClass("IndirectionHandlerClass", IndirectionHandlerJDKImpl.class, IndirectionHandler.class);
        this.proxyFactoryClass = this.getClass("ProxyFactoryClass", ProxyFactoryJDKImpl.class, ProxyFactory.class);
        this.useImplicitLocking = this.getBoolean("ImplicitLocking", false);
        this.lockAssociationAsWrites = this.getString("LockAssociations", "WRITE").equalsIgnoreCase("WRITE");
        this.oqlCollectionClass = this.getClass("OqlCollectionClass", DListImpl.class, ManageableCollection.class);
        this.sqlInLimit = this.getInteger("SqlInLimit", -1);
        this.maxActive = this.getInteger("maxActive", 21);
        this.maxIdle = this.getInteger("maxIdle", -1);
        this.maxWait = this.getLong("maxWait", 5000L);
        this.timeBetweenEvictionRunsMillis = this.getLong("timeBetweenEvictionRunsMillis", -1L);
        this.minEvictableIdleTimeMillis = this.getLong("minEvictableIdleTimeMillis", 600000L);
        this.whenExhaustedAction = this.getByte("whenExhaustedAction", (byte)0);
        this.useSerializedRepository = this.getBoolean("useSerializedRepository", false);
    }

    @Override
    public int getSqlInLimit() {
        return this.sqlInLimit;
    }

    public void setPersistentFieldClass(Class clazz) {
        this.persistentFieldClass = clazz;
    }

    @Override
    public boolean useImplicitLocking() {
        return this.useImplicitLocking;
    }

    public void setUseImplicitLocking(boolean bl) {
        this.useImplicitLocking = bl;
    }
}

