/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock.wait;

import java.util.HashMap;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.wait.ConcurrentModificationException;
import org.apache.ojb.otm.lock.wait.DeadlockException;
import org.apache.ojb.otm.lock.wait.LockWaitStrategy;

public class TimeoutStrategy
implements LockWaitStrategy {
    private static HashMap _waitsFor = new HashMap();
    private long _timeout;

    public TimeoutStrategy(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Illegal timeout value: " + l);
        }
        this._timeout = l;
    }

    public TimeoutStrategy() {
        this(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForLock(ObjectLock objectLock, Transaction transaction) throws LockingException {
        ObjectLock objectLock2;
        Transaction transaction2 = objectLock.getWriter();
        while (transaction2 != null && (objectLock2 = (ObjectLock)_waitsFor.get(transaction2)) != null && (transaction2 = objectLock2.getWriter()) != null) {
            if (transaction2 != transaction) continue;
            StringBuffer stringBuffer = new StringBuffer();
            transaction2 = objectLock.getWriter();
            stringBuffer.append(objectLock.getTargetIdentity());
            while (transaction2 != transaction) {
                objectLock2 = (ObjectLock)_waitsFor.get(transaction2);
                stringBuffer.append(" -> ");
                stringBuffer.append(objectLock2.getTargetIdentity());
                transaction2 = objectLock2.getWriter();
            }
            throw new DeadlockException(stringBuffer.toString());
        }
        _waitsFor.put(transaction, objectLock);
        try {
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis() + this._timeout;
            do {
                if (objectLock.getWriter() == null) {
                    return;
                }
                try {
                    long l3 = Math.min(l2 - l, 1000L);
                    Thread.sleep(l3);
                    l += l3;
                }
                catch (InterruptedException interruptedException) {
                    l = System.currentTimeMillis();
                }
            } while (l < l2);
            transaction2 = objectLock.getWriter();
            if (transaction2 != null) {
                throw new ConcurrentModificationException("Object [id: " + objectLock.getTargetIdentity() + "] locked by Transaction " + transaction2);
            }
        }
        finally {
            _waitsFor.remove(transaction);
        }
    }
}

