/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.bus.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.impl.bus.LocalService;
import org.kuali.rice.ksb.impl.bus.RemoteService;
import org.kuali.rice.ksb.impl.bus.diff.CompleteServiceDiff;
import org.kuali.rice.ksb.impl.bus.diff.LocalServicesDiff;
import org.kuali.rice.ksb.impl.bus.diff.RemoteServicesDiff;
import org.kuali.rice.ksb.impl.bus.diff.ServiceRegistryDiffCalculator;

public class ServiceRegistryDiffCalculatorImpl
implements ServiceRegistryDiffCalculator {
    private static final Logger LOG = LogManager.getLogger(ServiceRegistryDiffCalculatorImpl.class);
    private ServiceRegistry serviceRegistry;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public CompleteServiceDiff diffServices(String instanceId, List<LocalService> localServices, List<RemoteService> clientRegistryCache) {
        List allRegistryServices = this.serviceRegistry.getAllOnlineServices();
        List allRegistryServicesForInstance = this.serviceRegistry.getAllServicesForInstance(instanceId);
        LocalServicesDiff localServicesDiff = this.calculateLocalServicesDiff(allRegistryServicesForInstance, instanceId, localServices);
        RemoteServicesDiff remoteServicesDiff = this.calculateRemoteServicesDiff(allRegistryServices, clientRegistryCache);
        return new CompleteServiceDiff(localServicesDiff, remoteServicesDiff);
    }

    protected LocalServicesDiff calculateLocalServicesDiff(List<ServiceInfo> allRegistryServicesForInstance, String instanceId, List<LocalService> localServices) {
        ArrayList<ServiceInfo> servicesToRemoveFromRegistry = new ArrayList<ServiceInfo>();
        ArrayList<LocalService> localServicesToPublish = new ArrayList<LocalService>();
        HashMap<LocalService, ServiceInfo> localServicesToUpdate = new HashMap<LocalService, ServiceInfo>();
        Map<QName, LocalService> localServiceIndex = this.indexLocalServices(instanceId, localServices);
        for (ServiceInfo serviceInfo : allRegistryServicesForInstance) {
            if (!instanceId.equals(serviceInfo.getInstanceId())) {
                StringBuffer errorMessage = new StringBuffer("ServiceInfo given for local service diff does not have a valid instance id.  Should have been '" + instanceId + "' but was '" + serviceInfo.getInstanceId() + "'");
                if (serviceInfo.getInstanceId() == null) {
                    errorMessage.append(" Null instanceIds can be the result of multiple asm.jars or none in the classpath.");
                }
                throw new IllegalArgumentException(errorMessage.toString());
            }
            LocalService localService = localServiceIndex.get(serviceInfo.getServiceName());
            if (localService == null) {
                servicesToRemoveFromRegistry.add(serviceInfo);
                continue;
            }
            if (!localService.getServiceEndpoint().getInfo().equals((Object)serviceInfo)) {
                localServicesToUpdate.put(localService, serviceInfo);
            }
            localServiceIndex.remove(serviceInfo.getServiceName());
        }
        localServicesToPublish.addAll(localServiceIndex.values());
        if (LOG.isDebugEnabled()) {
            LOG.info("For instance '" + instanceId + "', found " + servicesToRemoveFromRegistry.size() + " services to remove from registry, " + localServicesToPublish.size() + " local services to publish");
        }
        return new LocalServicesDiff(servicesToRemoveFromRegistry, localServicesToPublish, localServicesToUpdate);
    }

    private Map<QName, LocalService> indexLocalServices(String instanceId, List<LocalService> localServices) {
        HashMap<QName, LocalService> localServiceIndex = new HashMap<QName, LocalService>(localServices.size());
        for (LocalService localService : localServices) {
            String localServiceInstanceId = localService.getServiceEndpoint().getInfo().getInstanceId();
            if (!instanceId.equals(localServiceInstanceId)) {
                throw new IllegalStateException("Instance id of local service (" + localServiceInstanceId + ") does not match instance id given to the diff calculator (" + instanceId + ")");
            }
            localServiceIndex.put(localService.getServiceName(), localService);
        }
        return localServiceIndex;
    }

    protected RemoteServicesDiff calculateRemoteServicesDiff(List<ServiceInfo> allRegistryServices, List<RemoteService> clientRegistryCache) {
        Map<String, ServiceInfo> indexedRegistryServices = this.indexRegistryServices(allRegistryServices);
        HashMap<String, ServiceInfo> servicesToAddToClientRegistryCache = new HashMap<String, ServiceInfo>(indexedRegistryServices);
        ArrayList<RemoteService> servicesToRemoveFromClientRegistryCache = new ArrayList<RemoteService>();
        for (RemoteService remoteService : clientRegistryCache) {
            ServiceInfo indexedRegistryService = indexedRegistryServices.get(remoteService.getServiceInfo().getServiceId());
            if (indexedRegistryService == null) {
                servicesToRemoveFromClientRegistryCache.add(remoteService);
                continue;
            }
            if (!remoteService.getServiceInfo().getChecksum().equals(indexedRegistryService.getChecksum())) {
                servicesToRemoveFromClientRegistryCache.add(remoteService);
                continue;
            }
            servicesToAddToClientRegistryCache.remove(remoteService.getServiceInfo().getServiceId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("For instance found " + servicesToRemoveFromClientRegistryCache.size() + " services to remove from client registry cache, " + servicesToAddToClientRegistryCache.size() + " services to add to client registry cache");
        }
        return new RemoteServicesDiff(new ArrayList<ServiceInfo>(servicesToAddToClientRegistryCache.values()), servicesToRemoveFromClientRegistryCache);
    }

    private Map<String, ServiceInfo> indexRegistryServices(List<ServiceInfo> allRegistryServices) {
        HashMap<String, ServiceInfo> indexedRegistryServices = new HashMap<String, ServiceInfo>(allRegistryServices.size());
        for (ServiceInfo serviceInfo : allRegistryServices) {
            indexedRegistryServices.put(serviceInfo.getServiceId(), serviceInfo);
        }
        return indexedRegistryServices;
    }
}

