/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public final class KimCacheUtils {
    private KimCacheUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isDynamicRoleMembership(List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return false;
        }
        RoleService roleService = KimApiServiceLocator.getRoleService();
        for (String roleId : roleIds) {
            if (!roleService.isDynamicRoleMembership(roleId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDynamicMembshipRoleByNamespaceAndName(String namespaceCode, String roleName) {
        List<String> roleIds = Collections.singletonList(KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName(namespaceCode, roleName));
        return KimCacheUtils.isDynamicRoleMembership(roleIds);
    }

    public static boolean isResponsibilityIdAssignedToDynamicRole(String responsibilityId) {
        if (StringUtils.isBlank((String)responsibilityId)) {
            return false;
        }
        List<String> roleIds = KimApiServiceLocator.getResponsibilityService().getRoleIdsForResponsibility(responsibilityId);
        return KimCacheUtils.isDynamicRoleMembership(roleIds);
    }

    public static boolean isResponsibilityAssignedToDynamicRole(String namespaceCode, String responsibilityName) {
        if (StringUtils.isBlank((String)namespaceCode) || StringUtils.isBlank((String)responsibilityName)) {
            return false;
        }
        Responsibility responsibility = KimApiServiceLocator.getResponsibilityService().findRespByNamespaceCodeAndName(namespaceCode, responsibilityName);
        if (responsibility != null) {
            return KimCacheUtils.isResponsibilityIdAssignedToDynamicRole(responsibility.getId());
        }
        return false;
    }

    public static boolean isResponsibilityTemplateAssignedToDynamicRole(String namespaceCode, String responsibilityTemplateName) {
        if (StringUtils.isBlank((String)namespaceCode) || StringUtils.isBlank((String)responsibilityTemplateName)) {
            return false;
        }
        ResponsibilityService respService = KimApiServiceLocator.getResponsibilityService();
        List<Responsibility> responsibilities = KimApiServiceLocator.getResponsibilityService().findResponsibilitiesByTemplate(namespaceCode, responsibilityTemplateName);
        ArrayList<String> roleIds = new ArrayList<String>();
        for (Responsibility resp : responsibilities) {
            roleIds.addAll(respService.getRoleIdsForResponsibility(resp.getId()));
        }
        return KimCacheUtils.isDynamicRoleMembership(roleIds);
    }
}

